/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.doc;

import gololang.FunctionReference;
import gololang.TemplateEngine;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.golo.compiler.parser.ASTCompilationUnit;
import org.eclipse.golo.compiler.parser.ASTModuleDeclaration;

public abstract class AbstractProcessor {
    private TemplateEngine templateEngine = new TemplateEngine();
    private HashMap<String, FunctionReference> templateCache = new HashMap();

    public abstract String render(ASTCompilationUnit var1) throws Throwable;

    public abstract void process(Map<String, ASTCompilationUnit> var1, Path var2) throws Throwable;

    protected FunctionReference template(String name, String format) throws IOException {
        String key = name + "-" + format;
        if (this.templateCache.containsKey(key)) {
            return this.templateCache.get(key);
        }
        InputStream in = AbstractProcessor.class.getResourceAsStream("/org/eclipse/golo/doc/" + name + "-" + format);
        if (in == null) {
            throw new IllegalArgumentException("There is no template " + name + " for format: " + format);
        }
        try (InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);){
            int nread;
            StringBuilder builder = new StringBuilder();
            char[] buffer = new char[1024];
            while ((nread = reader.read(buffer)) > 0) {
                builder.append(buffer, 0, nread);
            }
            FunctionReference compiledTemplate = this.templateEngine.compile(builder.toString());
            this.templateCache.put(key, compiledTemplate);
            FunctionReference functionReference = compiledTemplate;
            return functionReference;
        }
    }

    protected void ensureFolderExists(Path path) throws IOException {
        if (path != null) {
            Files.createDirectories(path, new FileAttribute[0]);
        }
    }

    protected Path outputFile(Path targetFolder, String moduleName, String extension) {
        return targetFolder.resolve(moduleName.replace('.', '/') + extension);
    }

    protected String moduleName(ASTCompilationUnit unit) {
        return ((ASTModuleDeclaration)unit.jjtGetChild(0)).getName();
    }

    private static String subsection(String line, int level) {
        if (!line.trim().startsWith("#") || line.startsWith("    ")) {
            return line;
        }
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            output.append('#');
        }
        output.append(line.trim());
        return output.toString();
    }

    public static String adaptSections(String documentation, int rootLevel) {
        StringBuilder output = new StringBuilder();
        for (String line : documentation.split("\n")) {
            output.append(AbstractProcessor.subsection(line, rootLevel));
            output.append("\n");
        }
        return output.toString();
    }
}

