/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collections;
import java.util.List;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.eclipse.golo.compiler.ClosureCaptureGoloIrVisitor;
import org.eclipse.golo.compiler.CodeGenerationResult;
import org.eclipse.golo.compiler.GoloCompilationException;
import org.eclipse.golo.compiler.JavaBytecodeGenerationGoloIrVisitor;
import org.eclipse.golo.compiler.LocalReferenceAssignmentAndVerificationVisitor;
import org.eclipse.golo.compiler.ParseTreeToGoloIrVisitor;
import org.eclipse.golo.compiler.SugarExpansionVisitor;
import org.eclipse.golo.compiler.ir.GoloModule;
import org.eclipse.golo.compiler.parser.ASTCompilationUnit;
import org.eclipse.golo.compiler.parser.GoloOffsetParser;
import org.eclipse.golo.compiler.parser.GoloParser;
import org.eclipse.golo.compiler.parser.ParseException;

public class GoloCompiler {
    private GoloParser parser;
    private GoloCompilationException.Builder exceptionBuilder = null;

    public final void setExceptionBuilder(GoloCompilationException.Builder builder) {
        this.exceptionBuilder = builder;
    }

    private GoloCompilationException.Builder getOrCreateExceptionBuilder(String goloSourceFile) {
        if (this.exceptionBuilder == null) {
            this.exceptionBuilder = new GoloCompilationException.Builder(goloSourceFile);
        }
        return this.exceptionBuilder;
    }

    public void resetExceptionBuilder() {
        this.exceptionBuilder = null;
    }

    public final GoloParser initParser(String goloSourceFilename, InputStream sourceCodeInputStream) throws GoloCompilationException {
        try {
            return this.initParser(new InputStreamReader(sourceCodeInputStream, Charset.forName("UTF-8")));
        }
        catch (UnsupportedCharsetException e) {
            this.getOrCreateExceptionBuilder(goloSourceFilename).report(e).doThrow();
            return null;
        }
    }

    public final GoloParser initParser(Reader sourceReader) {
        if (this.parser == null) {
            this.parser = this.createGoloParser(sourceReader);
        } else {
            this.parser.ReInit(sourceReader);
        }
        return this.parser;
    }

    public final List<CodeGenerationResult> compile(String goloSourceFilename, InputStream sourceCodeInputStream) throws GoloCompilationException {
        this.resetExceptionBuilder();
        ASTCompilationUnit compilationUnit = this.parse(goloSourceFilename, this.initParser(goloSourceFilename, sourceCodeInputStream));
        GoloModule goloModule = this.check(compilationUnit);
        JavaBytecodeGenerationGoloIrVisitor bytecodeGenerator = new JavaBytecodeGenerationGoloIrVisitor();
        return bytecodeGenerator.generateBytecode(goloModule, goloSourceFilename);
    }

    private void throwIfErrorEncountered() {
        if (!this.getProblems().isEmpty()) {
            this.exceptionBuilder.doThrow();
        }
    }

    public List<GoloCompilationException.Problem> getProblems() {
        if (this.exceptionBuilder == null) {
            return Collections.emptyList();
        }
        return this.exceptionBuilder.getProblems();
    }

    public final void compileTo(String goloSourceFilename, InputStream sourceCodeInputStream, File targetFolder) throws GoloCompilationException, IOException {
        if (targetFolder.isFile()) {
            throw new IllegalArgumentException(targetFolder + " already exists and is a file.");
        }
        List<CodeGenerationResult> results = this.compile(goloSourceFilename, sourceCodeInputStream);
        for (CodeGenerationResult result : results) {
            File outputFolder = new File(targetFolder, result.getPackageAndClass().packageName().replaceAll("\\.", "/"));
            if (!outputFolder.exists() && !outputFolder.mkdirs()) {
                throw new IOException("mkdir() failed on " + outputFolder);
            }
            File outputFile = new File(outputFolder, result.getPackageAndClass().className() + ".class");
            FileOutputStream out = new FileOutputStream(outputFile);
            Throwable throwable = null;
            try {
                out.write(result.getBytecode());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out == null) continue;
                if (throwable != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                out.close();
            }
        }
    }

    public final void compileToJar(String goloSourceFilename, InputStream sourceCodeInputStream, JarOutputStream jarOutputStream) throws IOException {
        List<CodeGenerationResult> results = this.compile(goloSourceFilename, sourceCodeInputStream);
        for (CodeGenerationResult result : results) {
            String entryName = result.getPackageAndClass().packageName().replaceAll("\\.", "/");
            if (!entryName.isEmpty()) {
                entryName = entryName + "/";
            }
            entryName = entryName + result.getPackageAndClass().className() + ".class";
            jarOutputStream.putNextEntry(new ZipEntry(entryName));
            jarOutputStream.write(result.getBytecode());
            jarOutputStream.closeEntry();
        }
    }

    public final ASTCompilationUnit parse(String goloSourceFilename, GoloParser parser) throws GoloCompilationException {
        ASTCompilationUnit compilationUnit = null;
        parser.exceptionBuilder = this.getOrCreateExceptionBuilder(goloSourceFilename);
        try {
            compilationUnit = parser.CompilationUnit();
        }
        catch (ParseException pe) {
            this.exceptionBuilder.report(pe, compilationUnit);
        }
        this.throwIfErrorEncountered();
        return compilationUnit;
    }

    public final ASTCompilationUnit parse(String goloSourceFilename) throws GoloCompilationException, IOException {
        try (FileInputStream in = new FileInputStream(goloSourceFilename);){
            ASTCompilationUnit aSTCompilationUnit = this.parse(goloSourceFilename, this.initParser(goloSourceFilename, in));
            return aSTCompilationUnit;
        }
    }

    public final GoloModule check(ASTCompilationUnit compilationUnit) {
        GoloModule goloModule = this.transform(compilationUnit);
        this.refine(goloModule);
        return goloModule;
    }

    public final GoloModule transform(ASTCompilationUnit compilationUnit) {
        return new ParseTreeToGoloIrVisitor().transform(compilationUnit, this.exceptionBuilder);
    }

    public final void refine(GoloModule goloModule) {
        if (goloModule != null) {
            goloModule.accept(new SugarExpansionVisitor());
            goloModule.accept(new ClosureCaptureGoloIrVisitor());
            goloModule.accept(new LocalReferenceAssignmentAndVerificationVisitor(this.exceptionBuilder));
        }
        this.throwIfErrorEncountered();
    }

    protected GoloParser createGoloParser(Reader sourceReader) {
        return new GoloOffsetParser(sourceReader);
    }
}

