/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.cli.command;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.golo.cli.command.spi.CliCommand;
import org.eclipse.golo.compiler.GoloCompilationException;
import org.eclipse.golo.compiler.GoloCompiler;

@Parameters(commandNames={"check"}, commandDescription="Check Golo source files for correctness")
public class CheckCommand
implements CliCommand {
    @Parameter(names={"--exit"}, description="Exit on the first encountered error, or continue with the next file")
    boolean exit = false;
    @Parameter(names={"--verbose"}, description="Be more verbose")
    boolean verbose = false;
    @Parameter(description="Golo source files (*.golo and directories))")
    List<String> files = new LinkedList<String>();

    @Override
    public void execute() throws Throwable {
        GoloCompiler compiler = new GoloCompiler();
        for (String file : this.files) {
            this.check(new File(file), compiler);
        }
    }

    private void check(File file, GoloCompiler compiler) {
        block6: {
            block5: {
                if (!file.isDirectory()) break block5;
                File[] directoryFiles = file.listFiles();
                if (directoryFiles == null) break block6;
                for (File directoryFile : directoryFiles) {
                    this.check(directoryFile, compiler);
                }
                break block6;
            }
            if (!file.getName().endsWith(".golo")) break block6;
            try {
                if (this.verbose) {
                    System.out.println(">>> Checking file `" + file.getAbsolutePath() + "`");
                }
                compiler.resetExceptionBuilder();
                compiler.check(compiler.parse(file.getAbsolutePath()));
            }
            catch (IOException e) {
                System.out.println("[error] " + file + " does not exist or could not be opened.");
            }
            catch (GoloCompilationException e) {
                this.handleCompilationException(e, this.exit);
            }
        }
    }
}

