/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler.ir;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.golo.compiler.ir.ExpressionStatement;
import org.eclipse.golo.compiler.ir.FunctionInvocation;
import org.eclipse.golo.compiler.ir.GoloElement;
import org.eclipse.golo.compiler.ir.GoloIrVisitor;

public abstract class AbstractInvocation
extends ExpressionStatement {
    private final String name;
    private final List<ExpressionStatement> arguments = new LinkedList<ExpressionStatement>();
    private final List<FunctionInvocation> anonymousFunctionInvocations = new LinkedList<FunctionInvocation>();
    protected boolean usesNamedArguments = false;

    AbstractInvocation(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    private void addArgument(ExpressionStatement argument) {
        this.arguments.add(argument);
        this.makeParentOf(argument);
    }

    public AbstractInvocation withArgs(Object ... arguments) {
        for (Object argument : arguments) {
            this.addArgument(ExpressionStatement.of(argument));
        }
        return this;
    }

    public List<ExpressionStatement> getArguments() {
        return Collections.unmodifiableList(this.arguments);
    }

    public int getArity() {
        return this.arguments.size();
    }

    public AbstractInvocation followedBy(Object invocation) {
        FunctionInvocation inv = (FunctionInvocation)invocation;
        this.anonymousFunctionInvocations.add(inv);
        this.makeParentOf(inv);
        return this;
    }

    public List<FunctionInvocation> getAnonymousFunctionInvocations() {
        return Collections.unmodifiableList(this.anonymousFunctionInvocations);
    }

    public boolean usesNamedArguments() {
        return this.usesNamedArguments;
    }

    public boolean namedArgumentsComplete() {
        return this.arguments.isEmpty() || this.usesNamedArguments;
    }

    public AbstractInvocation withNamedArguments() {
        this.setUsesNamedArguments(true);
        return this;
    }

    private void setUsesNamedArguments(boolean usesNamedArguments) {
        this.usesNamedArguments = usesNamedArguments;
    }

    @Override
    public void walk(GoloIrVisitor visitor) {
        for (ExpressionStatement arg : this.arguments) {
            arg.accept(visitor);
        }
        for (FunctionInvocation inv : this.anonymousFunctionInvocations) {
            inv.accept(visitor);
        }
    }

    @Override
    protected void replaceElement(GoloElement original, GoloElement newElement) {
        if (!(newElement instanceof ExpressionStatement) || !this.arguments.contains(original)) {
            throw this.cantReplace(original, newElement);
        }
        this.arguments.set(this.arguments.indexOf((ExpressionStatement)original), (ExpressionStatement)newElement);
    }
}

