/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler.ir;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.golo.compiler.PackageAndClass;
import org.eclipse.golo.compiler.ir.GoloElement;
import org.eclipse.golo.compiler.ir.GoloIrVisitor;
import org.eclipse.golo.compiler.ir.UnionValue;

public final class Union
extends GoloElement {
    private PackageAndClass moduleName;
    private final String name;
    private final Set<UnionValue> values = new LinkedHashSet<UnionValue>();

    Union(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public PackageAndClass getPackageAndClass() {
        return new PackageAndClass(this.moduleName.toString() + ".types", this.name);
    }

    public void setModuleName(PackageAndClass module) {
        this.moduleName = module;
    }

    public boolean addValue(String name, Collection<String> members) {
        for (UnionValue v : this.values) {
            if (!v.getName().equals(name)) continue;
            return false;
        }
        UnionValue value = new UnionValue(this, name);
        value.addMembers(members);
        this.values.add(value);
        this.makeParentOf(value);
        return true;
    }

    public boolean addValue(UnionValue value) {
        this.makeParentOf(value);
        return this.values.add(value);
    }

    public Collection<UnionValue> getValues() {
        return Collections.unmodifiableSet(this.values);
    }

    public Union value(String name, String ... members) {
        this.addValue(name, Arrays.asList(members));
        return this;
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitUnion(this);
    }

    @Override
    public void walk(GoloIrVisitor visitor) {
        for (UnionValue value : this.getValues()) {
            value.accept(visitor);
        }
    }

    @Override
    protected void replaceElement(GoloElement original, GoloElement newElement) {
        if (!this.values.contains(original) || !(newElement instanceof UnionValue)) {
            throw this.cantReplace(original, newElement);
        }
        this.values.remove(original);
        this.addValue((UnionValue)newElement);
    }
}

