/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler.ir;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.golo.compiler.ir.Alternatives;
import org.eclipse.golo.compiler.ir.Block;
import org.eclipse.golo.compiler.ir.ExpressionStatement;
import org.eclipse.golo.compiler.ir.GoloElement;
import org.eclipse.golo.compiler.ir.GoloIrVisitor;
import org.eclipse.golo.compiler.ir.GoloStatement;
import org.eclipse.golo.compiler.ir.ReferenceTable;
import org.eclipse.golo.compiler.ir.Scope;
import org.eclipse.golo.compiler.ir.WhenClause;
import org.eclipse.golo.compiler.parser.GoloASTNode;

public final class CaseStatement
extends GoloStatement
implements Scope,
Alternatives<Block> {
    private Block otherwise;
    private final LinkedList<WhenClause<Block>> clauses = new LinkedList();

    CaseStatement() {
    }

    public CaseStatement when(Object cond) {
        WhenClause<Object> clause = new WhenClause<Object>((ExpressionStatement)cond, null);
        this.clauses.add(clause);
        this.makeParentOf(clause);
        return this;
    }

    public CaseStatement then(Object action) {
        this.clauses.getLast().setAction((Block)action);
        return this;
    }

    public CaseStatement otherwise(Object action) {
        this.otherwise = (Block)action;
        this.makeParentOf(this.otherwise);
        return this;
    }

    @Override
    public List<WhenClause<Block>> getClauses() {
        return Collections.unmodifiableList(this.clauses);
    }

    @Override
    public Block getOtherwise() {
        return this.otherwise;
    }

    @Override
    public CaseStatement ofAST(GoloASTNode n) {
        super.ofAST(n);
        return this;
    }

    @Override
    public void relink(ReferenceTable table) {
        this.getOtherwise().relink(table);
        for (WhenClause<Block> c : this.getClauses()) {
            c.action().relink(table);
        }
    }

    @Override
    public void relinkTopLevel(ReferenceTable table) {
        this.getOtherwise().relinkTopLevel(table);
        for (WhenClause<Block> c : this.getClauses()) {
            c.action().relinkTopLevel(table);
        }
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitCaseStatement(this);
    }

    @Override
    public void walk(GoloIrVisitor visitor) {
        for (WhenClause whenClause : this.clauses) {
            whenClause.accept(visitor);
        }
        this.otherwise.accept(visitor);
    }

    @Override
    public void replaceElement(GoloElement original, GoloElement newElement) {
        if (!(newElement instanceof Block) && !(newElement instanceof WhenClause)) {
            throw CaseStatement.cantConvert("Block or WhenClause", newElement);
        }
        if (this.otherwise.equals(original)) {
            this.otherwise(newElement);
            return;
        }
        if (this.clauses.contains(original)) {
            WhenClause when = (WhenClause)newElement;
            this.clauses.set(this.clauses.indexOf(original), when);
            this.makeParentOf(when);
            return;
        }
        throw this.doesNotContain(original);
    }
}

