/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.xml;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ValidationException;
import org.hibernate.validator.internal.metadata.aggregated.CascadingMetaDataBuilder;
import org.hibernate.validator.internal.metadata.core.AnnotationProcessingOptionsImpl;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.descriptor.ConstraintDescriptorImpl;
import org.hibernate.validator.internal.metadata.location.ConstraintLocation;
import org.hibernate.validator.internal.metadata.raw.ConfigurationSource;
import org.hibernate.validator.internal.metadata.raw.ConstrainedExecutable;
import org.hibernate.validator.internal.metadata.raw.ConstrainedParameter;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.ExecutableHelper;
import org.hibernate.validator.internal.util.ReflectionHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.util.privilegedactions.GetDeclaredConstructor;
import org.hibernate.validator.internal.util.privilegedactions.GetDeclaredMethod;
import org.hibernate.validator.internal.xml.ClassLoadingHelper;
import org.hibernate.validator.internal.xml.ConstrainedParameterBuilder;
import org.hibernate.validator.internal.xml.ContainerElementTypeConfigurationBuilder;
import org.hibernate.validator.internal.xml.GroupConversionBuilder;
import org.hibernate.validator.internal.xml.MetaConstraintBuilder;
import org.hibernate.validator.internal.xml.binding.ConstraintType;
import org.hibernate.validator.internal.xml.binding.ConstructorType;
import org.hibernate.validator.internal.xml.binding.CrossParameterType;
import org.hibernate.validator.internal.xml.binding.MethodType;
import org.hibernate.validator.internal.xml.binding.ParameterType;
import org.hibernate.validator.internal.xml.binding.ReturnValueType;

class ConstrainedExecutableBuilder {
    private static final Log LOG = LoggerFactory.make(MethodHandles.lookup());
    private final ClassLoadingHelper classLoadingHelper;
    private final MetaConstraintBuilder metaConstraintBuilder;
    private final GroupConversionBuilder groupConversionBuilder;
    private final ConstrainedParameterBuilder constrainedParameterBuilder;
    private final AnnotationProcessingOptionsImpl annotationProcessingOptions;

    ConstrainedExecutableBuilder(ClassLoadingHelper classLoadingHelper, MetaConstraintBuilder metaConstraintBuilder, GroupConversionBuilder groupConversionBuilder, AnnotationProcessingOptionsImpl annotationProcessingOptions) {
        this.classLoadingHelper = classLoadingHelper;
        this.metaConstraintBuilder = metaConstraintBuilder;
        this.groupConversionBuilder = groupConversionBuilder;
        this.constrainedParameterBuilder = new ConstrainedParameterBuilder(metaConstraintBuilder, groupConversionBuilder, annotationProcessingOptions);
        this.annotationProcessingOptions = annotationProcessingOptions;
    }

    Set<ConstrainedExecutable> buildMethodConstrainedExecutable(List<MethodType> methods, Class<?> beanClass, String defaultPackage) {
        HashSet<ConstrainedExecutable> constrainedExecutables = CollectionHelper.newHashSet();
        ArrayList alreadyProcessedMethods = CollectionHelper.newArrayList();
        for (MethodType methodType : methods) {
            List<Class<?>> parameterTypes = this.createParameterTypes(methodType.getParameter(), beanClass, defaultPackage);
            String methodName = methodType.getName();
            Method method = ConstrainedExecutableBuilder.run(GetDeclaredMethod.action(beanClass, methodName, parameterTypes.toArray(new Class[parameterTypes.size()])));
            if (method == null) {
                throw LOG.getBeanDoesNotContainMethodException(beanClass, methodName, parameterTypes);
            }
            if (alreadyProcessedMethods.contains(method)) {
                throw LOG.getMethodIsDefinedTwiceInMappingXmlForBeanException(method, beanClass);
            }
            alreadyProcessedMethods.add(method);
            if (methodType.getIgnoreAnnotations() != null) {
                this.annotationProcessingOptions.ignoreConstraintAnnotationsOnMember(method, methodType.getIgnoreAnnotations());
            }
            ConstrainedExecutable constrainedExecutable = this.parseExecutableType(defaultPackage, methodType.getParameter(), methodType.getCrossParameter(), methodType.getReturnValue(), method);
            constrainedExecutables.add(constrainedExecutable);
        }
        return constrainedExecutables;
    }

    Set<ConstrainedExecutable> buildConstructorConstrainedExecutable(List<ConstructorType> constructors, Class<?> beanClass, String defaultPackage) {
        HashSet<ConstrainedExecutable> constrainedExecutables = CollectionHelper.newHashSet();
        ArrayList alreadyProcessedConstructors = CollectionHelper.newArrayList();
        for (ConstructorType constructorType : constructors) {
            List<Class<?>> constructorParameterTypes = this.createParameterTypes(constructorType.getParameter(), beanClass, defaultPackage);
            Constructor constructor = (Constructor)ConstrainedExecutableBuilder.run(GetDeclaredConstructor.action(beanClass, constructorParameterTypes.toArray(new Class[constructorParameterTypes.size()])));
            if (constructor == null) {
                throw LOG.getBeanDoesNotContainConstructorException(beanClass, constructorParameterTypes);
            }
            if (alreadyProcessedConstructors.contains(constructor)) {
                throw LOG.getConstructorIsDefinedTwiceInMappingXmlForBeanException(constructor, beanClass);
            }
            alreadyProcessedConstructors.add(constructor);
            if (constructorType.getIgnoreAnnotations() != null) {
                this.annotationProcessingOptions.ignoreConstraintAnnotationsOnMember(constructor, constructorType.getIgnoreAnnotations());
            }
            ConstrainedExecutable constrainedExecutable = this.parseExecutableType(defaultPackage, constructorType.getParameter(), constructorType.getCrossParameter(), constructorType.getReturnValue(), constructor);
            constrainedExecutables.add(constrainedExecutable);
        }
        return constrainedExecutables;
    }

    private ConstrainedExecutable parseExecutableType(String defaultPackage, List<ParameterType> parameterTypeList, CrossParameterType crossParameterType, ReturnValueType returnValueType, Executable executable) {
        List<ConstrainedParameter> parameterMetaData = this.constrainedParameterBuilder.buildConstrainedParameters(parameterTypeList, executable, defaultPackage);
        Set<MetaConstraint<?>> crossParameterConstraints = this.parseCrossParameterConstraints(defaultPackage, crossParameterType, executable);
        HashSet returnValueConstraints = new HashSet();
        HashSet returnValueTypeArgumentConstraints = new HashSet();
        CascadingMetaDataBuilder cascadingMetaDataBuilder = this.parseReturnValueType(returnValueType, executable, returnValueConstraints, returnValueTypeArgumentConstraints, defaultPackage);
        return new ConstrainedExecutable(ConfigurationSource.XML, executable, parameterMetaData, crossParameterConstraints, returnValueConstraints, returnValueTypeArgumentConstraints, cascadingMetaDataBuilder);
    }

    private Set<MetaConstraint<?>> parseCrossParameterConstraints(String defaultPackage, CrossParameterType crossParameterType, Executable executable) {
        HashSet<MetaConstraint<?>> crossParameterConstraints = CollectionHelper.newHashSet();
        if (crossParameterType == null) {
            return crossParameterConstraints;
        }
        ConstraintLocation constraintLocation = ConstraintLocation.forCrossParameter(executable);
        for (ConstraintType constraintType : crossParameterType.getConstraint()) {
            MetaConstraint metaConstraint = this.metaConstraintBuilder.buildMetaConstraint(constraintLocation, constraintType, ExecutableHelper.getElementType(executable), defaultPackage, ConstraintDescriptorImpl.ConstraintType.CROSS_PARAMETER);
            crossParameterConstraints.add(metaConstraint);
        }
        if (crossParameterType.getIgnoreAnnotations() != null) {
            this.annotationProcessingOptions.ignoreConstraintAnnotationsForCrossParameterConstraint(executable, crossParameterType.getIgnoreAnnotations());
        }
        return crossParameterConstraints;
    }

    private CascadingMetaDataBuilder parseReturnValueType(ReturnValueType returnValueType, Executable executable, Set<MetaConstraint<?>> returnValueConstraints, Set<MetaConstraint<?>> returnValueTypeArgumentConstraints, String defaultPackage) {
        if (returnValueType == null) {
            return CascadingMetaDataBuilder.nonCascading();
        }
        ConstraintLocation constraintLocation = ConstraintLocation.forReturnValue(executable);
        for (ConstraintType constraint : returnValueType.getConstraint()) {
            MetaConstraint metaConstraint = this.metaConstraintBuilder.buildMetaConstraint(constraintLocation, constraint, ExecutableHelper.getElementType(executable), defaultPackage, ConstraintDescriptorImpl.ConstraintType.GENERIC);
            returnValueConstraints.add(metaConstraint);
        }
        ContainerElementTypeConfigurationBuilder containerElementTypeConfigurationBuilder = new ContainerElementTypeConfigurationBuilder(this.metaConstraintBuilder, this.groupConversionBuilder, constraintLocation, defaultPackage);
        ContainerElementTypeConfigurationBuilder.ContainerElementTypeConfiguration containerElementTypeConfiguration = containerElementTypeConfigurationBuilder.build(returnValueType.getContainerElementType(), ReflectionHelper.typeOf(executable));
        returnValueTypeArgumentConstraints.addAll(containerElementTypeConfiguration.getMetaConstraints());
        if (returnValueType.getIgnoreAnnotations() != null) {
            this.annotationProcessingOptions.ignoreConstraintAnnotationsForReturnValue(executable, returnValueType.getIgnoreAnnotations());
        }
        return this.getCascadingMetaDataForReturnValue(containerElementTypeConfiguration.getTypeParametersCascadingMetaData(), executable, returnValueType, defaultPackage);
    }

    private List<Class<?>> createParameterTypes(List<ParameterType> parameterList, Class<?> beanClass, String defaultPackage) {
        ArrayList<Class<?>> parameterTypes = CollectionHelper.newArrayList();
        for (ParameterType parameterType : parameterList) {
            String type = null;
            try {
                type = parameterType.getType();
                Class<?> parameterClass = this.classLoadingHelper.loadClass(type, defaultPackage);
                parameterTypes.add(parameterClass);
            }
            catch (ValidationException e) {
                throw LOG.getInvalidParameterTypeException(type, beanClass);
            }
        }
        return parameterTypes;
    }

    private CascadingMetaDataBuilder getCascadingMetaDataForReturnValue(Map<TypeVariable<?>, CascadingMetaDataBuilder> containerElementTypesCascadingMetaData, Executable executable, ReturnValueType returnValueType, String defaultPackage) {
        Type type = ReflectionHelper.typeOf(executable);
        boolean isCascaded = returnValueType.getValid() != null;
        Map<Class<?>, Class<?>> groupConversions = this.groupConversionBuilder.buildGroupConversionMap(returnValueType.getConvertGroup(), defaultPackage);
        return CascadingMetaDataBuilder.annotatedObject(type, isCascaded, containerElementTypesCascadingMetaData, groupConversions);
    }

    private static <T> T run(PrivilegedAction<T> action) {
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
    }
}

