/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.accesslog;

import com.sun.enterprise.web.accesslog.AccessLogFormatter;
import java.nio.CharBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.Request;
import org.apache.catalina.Response;

public class CommonAccessLogFormatterImpl
extends AccessLogFormatter {
    protected static final String NULL_VALUE = "-";

    public CommonAccessLogFormatterImpl() {
        final TimeZone timeZone = this.tz;
        this.dayFormatter = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                SimpleDateFormat f = new SimpleDateFormat("dd");
                f.setTimeZone(timeZone);
                return f;
            }
        };
        this.monthFormatter = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                SimpleDateFormat f = new SimpleDateFormat("MM");
                f.setTimeZone(timeZone);
                return f;
            }
        };
        this.yearFormatter = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                SimpleDateFormat f = new SimpleDateFormat("yyyy");
                f.setTimeZone(timeZone);
                return f;
            }
        };
        this.timeFormatter = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                SimpleDateFormat f = new SimpleDateFormat("HH:mm:ss");
                f.setTimeZone(timeZone);
                return f;
            }
        };
    }

    @Override
    public void appendLogEntry(Request request, Response response, CharBuffer charBuffer) {
        ServletRequest req = request.getRequest();
        HttpServletRequest hreq = (HttpServletRequest)req;
        this.appendClientName(charBuffer, req);
        charBuffer.put(" ");
        this.appendClientId(charBuffer, req);
        charBuffer.put(" ");
        this.appendAuthUserName(charBuffer, hreq);
        charBuffer.put(" ");
        this.appendCurrentDate(charBuffer);
        charBuffer.put(" ");
        this.appendRequestInfo(charBuffer, hreq);
        charBuffer.put(" ");
        this.appendResponseStatus(charBuffer, response);
        charBuffer.put(" ");
        this.appendResponseLength(charBuffer, response);
        charBuffer.put(" ");
    }

    private void appendClientName(CharBuffer cb, ServletRequest req) {
        String value = req.getRemoteHost();
        if (value == null) {
            value = NULL_VALUE;
        }
        cb.put(value);
    }

    private void appendClientId(CharBuffer cb, ServletRequest req) {
        cb.put(NULL_VALUE);
    }

    private void appendAuthUserName(CharBuffer cb, HttpServletRequest hreq) {
        String user = hreq.getRemoteUser();
        if (user == null) {
            user = NULL_VALUE;
        }
        cb.put(user);
    }

    private void appendCurrentDate(CharBuffer cb) {
        Date date = this.getDate();
        cb.put("[");
        cb.put(((SimpleDateFormat)this.dayFormatter.get()).format(date));
        cb.put('/');
        cb.put(this.lookup(((SimpleDateFormat)this.monthFormatter.get()).format(date)));
        cb.put('/');
        cb.put(((SimpleDateFormat)this.yearFormatter.get()).format(date));
        cb.put(':');
        cb.put(((SimpleDateFormat)this.timeFormatter.get()).format(date));
        cb.put(" ");
        cb.put(this.timeZone);
        cb.put("]");
    }

    private void appendRequestInfo(CharBuffer cb, HttpServletRequest hreq) {
        cb.put("\"");
        cb.put(hreq.getMethod());
        cb.put(" ");
        String uri = hreq.getRequestURI();
        if (uri == null) {
            uri = "NULL-HTTP-URI";
        }
        cb.put(uri);
        if (hreq.getQueryString() != null) {
            cb.put('?');
            cb.put(hreq.getQueryString());
        }
        cb.put(" ");
        cb.put(hreq.getProtocol());
        cb.put("\"");
    }

    private void appendResponseStatus(CharBuffer cb, Response response) {
        cb.put(String.valueOf(((HttpResponse)response).getStatus()));
    }

    private void appendResponseLength(CharBuffer cb, Response response) {
        cb.put("" + response.getContentCount());
    }
}

