/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli.internal;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.enterprise.config.serverbeans.Resources;
import java.util.Arrays;
import java.util.Properties;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="_get-system-rars-allowing-pool-creation")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@RestEndpoints(value={@RestEndpoint(configBean=Resources.class, opType=RestEndpoint.OpType.GET, path="get-system-rars-allowing-pool-creation", description="Get System RARs Allowing Pool Creation")})
public class GetSystemRarsAllowingPoolCreation
implements AdminCommand {
    @Inject
    private ConnectorRuntime connectorRuntime;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            String[] rarList = this.connectorRuntime.getSystemConnectorsAllowingPoolCreation();
            Properties extraProperties = new Properties();
            if (rarList != null) {
                extraProperties.put("rarList", Arrays.asList(rarList));
            }
            report.setExtraProperties(extraProperties);
        }
        catch (Exception e) {
            report.setMessage("_get-system-rars-allowing-pool-creation failed : " + e.getMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        ActionReport.ExitCode ec = ActionReport.ExitCode.SUCCESS;
        report.setActionExitCode(ec);
    }
}

