/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.sequential.javaengine.ui.commands;

import fr.inria.diverse.melange.resource.MelangeResource;
import java.util.Iterator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gemoc.dsl.debug.ide.DSLBreakpoint;
import org.eclipse.gemoc.dsl.debug.ide.sirius.ui.DSLToggleBreakpointsUtils;
import org.eclipse.gemoc.executionframework.debugger.GemocBreakpoint;
import org.eclipse.gemoc.trace.commons.model.trace.MSE;
import org.eclipse.gemoc.trace.commons.model.trace.MSEOccurrence;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.IGotoMarker;

public class GemocToggleBreakpointHandler
extends AbstractHandler {
    protected final DSLToggleBreakpointsUtils breakpointUtils = new DSLToggleBreakpointsUtils("org.eclipse.gemoc.executionframework.extensions.sirius.debugModel"){

        protected EObject getInstruction(Object selected) {
            Object res = selected instanceof MSE ? (MSE)selected : (selected instanceof MSEOccurrence ? ((MSEOccurrence)selected).getMse() : super.getInstruction(selected));
            return res;
        }

        protected DSLBreakpoint createBreakpoint(Object selected, EObject instruction) throws CoreException {
            Resource res = instruction.eResource();
            ResourceSet resSet = res.getResourceSet();
            MelangeResource mr = resSet.getResources().stream().filter(r -> r instanceof MelangeResource).map(r -> (MelangeResource)r).findFirst().orElse(null);
            if (mr != null) {
                String fragmentURI = res.getURIFragment(instruction);
                instruction = mr.getWrappedResource().getEObject(fragmentURI);
            }
            return new GemocBreakpoint(this.identifier, instruction, true);
        }
    };
    IGotoMarker f;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        try {
            this.breakpointUtils.toggleBreakpoints(selection);
        }
        catch (CoreException e) {
            throw new ExecutionException("Error while toggling breakpoint.", (Throwable)e);
        }
        return null;
    }

    public boolean isEnabled() {
        boolean res;
        ISelectionService service = (ISelectionService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(ISelectionService.class);
        if (service != null) {
            ISelection selection = service.getSelection();
            if (selection instanceof IStructuredSelection) {
                boolean allValidMSE = true;
                Iterator it = ((IStructuredSelection)selection).iterator();
                while (allValidMSE && it.hasNext()) {
                    Object current = it.next();
                    allValidMSE = current instanceof MSE;
                }
                res = allValidMSE;
            } else {
                res = false;
            }
        } else {
            res = false;
        }
        return res;
    }
}

