/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.views.stimulimanager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gemoc.commons.eclipse.ui.ViewHelper;
import org.eclipse.gemoc.dsl.debug.ide.DSLBreakpoint;
import org.eclipse.gemoc.dsl.debug.ide.ui.provider.DSLLabelDecorator;
import org.eclipse.gemoc.dsl.debug.ide.ui.provider.DecoratingColumLabelProvider;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.SharedIcons;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.views.step.LogicalStepsView;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.views.stimulimanager.ClockStatus;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.views.stimulimanager.ModelSpecificEventContext;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.views.stimulimanager.ModelSpecificEventWrapper;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.views.stimulimanager.ViewContentProvider;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.views.stimulimanager.actions.PlayScenarioAction;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.views.stimulimanager.actions.RecordScenarioAction;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.views.stimulimanager.actions.StopAction;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.views.stimulimanager.filters.Filter;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.views.stimulimanager.filters.Filters;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.views.stimulimanager.filters.NoFilter;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.views.stimulimanager.scenario.ScenarioException;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.views.stimulimanager.scenario.ScenarioManager;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.views.stimulimanager.scenario.ScenarioManagerState;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.core.IConcurrentExecutionContext;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.core.IConcurrentExecutionEngine;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.core.IConcurrentExecutionPlatform;
import org.eclipse.gemoc.executionframework.ui.Activator;
import org.eclipse.gemoc.executionframework.ui.IMSEPresenter;
import org.eclipse.gemoc.executionframework.ui.views.engine.EngineSelectionDependentViewPart;
import org.eclipse.gemoc.moccml.mapping.feedback.feedback.ModelSpecificEvent;
import org.eclipse.gemoc.trace.commons.model.trace.Step;
import org.eclipse.gemoc.xdsmlframework.api.core.EngineStatus;
import org.eclipse.gemoc.xdsmlframework.api.core.ExecutionMode;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionEngine;
import org.eclipse.gemoc.xdsmlframework.api.engine_addon.IEngineAddon;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;

public class StimuliManagerView
extends EngineSelectionDependentViewPart
implements IEngineAddon,
IMSEPresenter {
    public static final String ID = "org.eclipse.gemoc.gemoc_modeling_workbench.concurrent.ui.views.stimulimanager.StimuliManagerView";
    private Color notForcedSetColor;
    private Color forcedSetColor;
    private Color forcedNotSetColor;
    private Color representedEventColor;
    private TableViewer _viewer;
    private ViewContentProvider _contentProvider;
    private IConcurrentExecutionEngine _currentSelectedEngine;
    private Map<IConcurrentExecutionEngine, ModelSpecificEventContext> _mseContextMap = new HashMap<IConcurrentExecutionEngine, ModelSpecificEventContext>();
    private Filter _strategyFilterSelected;
    private ISelectionListener _decisionViewListener = new ISelectionListener(){
        IStructuredSelection previousSelection = null;

        public void selectionChanged(IWorkbenchPart sourcepart, ISelection selection) {
            LogicalStepsView decisionView = (LogicalStepsView)((Object)ViewHelper.retrieveView((String)"org.eclipse.gemoc.executionframework.engine.io.views.steps.LogicalStepsView"));
            if (sourcepart == decisionView && selection instanceof IStructuredSelection && selection != this.previousSelection && !selection.isEmpty()) {
                this.previousSelection = (IStructuredSelection)selection;
                StimuliManagerView.this.updateView();
            }
        }
    };
    private SelectionListener _menuAndButtonListener;
    private Composite _bottomComposite;
    private Composite _informationBar;
    private MenuManager _menuManager;
    private ColumnLabelProvider _column1LabelProvider;
    private GemocLabelDecorator _decorator;
    private List<URI> _eventsToPresent = new ArrayList<URI>();
    private List<Button> _mseControlButtons;
    private Label _viewStateLabel;
    private PlayScenarioAction _playAction = new PlayScenarioAction();
    private RecordScenarioAction _recordAction = new RecordScenarioAction();
    private StopAction _stopAction = new StopAction();

    public StimuliManagerView() {
        this._strategyFilterSelected = new NoFilter();
    }

    private ModelSpecificEventContext getMSEContext() {
        if (this._currentSelectedEngine == null) {
            return null;
        }
        return this._mseContextMap.get(this._currentSelectedEngine);
    }

    public void createPartControl(Composite parent) {
        this.notForcedSetColor = new Color((Device)parent.getDisplay(), 212, 255, 141);
        this.forcedSetColor = new Color((Device)parent.getDisplay(), 212, 255, 141);
        this.forcedNotSetColor = new Color((Device)parent.getDisplay(), 212, 255, 141);
        this.representedEventColor = new Color((Device)parent.getDisplay(), 255, 235, 174);
        GridLayout layout = new GridLayout();
        parent.setLayout((Layout)layout);
        this.createFilterSelectionBar(parent);
        this.createViewer(parent);
        this._menuAndButtonListener = this.createSelectionListener();
        this._bottomComposite = new Composite(parent, 0);
        this._bottomComposite.setLayout((Layout)new StackLayout());
        this._bottomComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createInformationAndButtons(parent);
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener("org.eclipse.gemoc.executionframework.engine.io.views.steps.LogicalStepsView", this._decisionViewListener);
        this.updateView();
        this.createMenuManager();
        Activator.getDefault().getEventPresenters().add(this);
    }

    private void createFilterSelectionBar(Composite parent) {
        Composite filterSelectionBar = new Composite(parent, 2048);
        this.buildMenu();
        filterSelectionBar.setLayout((Layout)new GridLayout(2, false));
        filterSelectionBar.setLayoutData((Object)new GridData(4, 4, true, false));
        new Label(filterSelectionBar, 0).setText("Select an event filter: ");
        final Combo combo = new Combo(filterSelectionBar, 12);
        combo.setLayoutData((Object)new GridData(4, 4, true, false));
        Filters[] strategyFilters = Filters.values();
        Arrays.sort((Object[])strategyFilters);
        Filters[] filtersArray = strategyFilters;
        int n = strategyFilters.length;
        int n2 = 0;
        while (n2 < n) {
            Filters myFilters = filtersArray[n2];
            combo.add(myFilters.getName());
            combo.setData(myFilters.getName(), (Object)myFilters.getFilter());
            ++n2;
        }
        combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String filterName = combo.getItem(combo.getSelectionIndex());
                StimuliManagerView.this._strategyFilterSelected = (Filter)combo.getData(filterName);
                StimuliManagerView.this.updateView();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                String text = combo.getText();
                if (combo.indexOf(text) < 0) {
                    combo.add(text);
                    Object[] items = combo.getItems();
                    Arrays.sort(items);
                    combo.setItems((String[])items);
                }
            }
        });
    }

    private void buildMenu() {
        this.updateActionsVisibility();
        this.addActionToToolbar(this._playAction);
        this.addActionToToolbar(this._recordAction);
        this.addActionToToolbar(this._stopAction);
    }

    private void updateActionsVisibility() {
        if (this._currentSelectedEngine != null && !this.isEngineStopped() && this.getScenarioManager() != null) {
            ScenarioManager sm = this.getScenarioManager();
            if (sm.getState().equals((Object)ScenarioManagerState.Recording)) {
                this._stopAction.setEnabled(true);
                this._recordAction.setEnabled(false);
                this._playAction.setEnabled(false);
            } else if (sm.getState().equals((Object)ScenarioManagerState.Playing)) {
                this._stopAction.setEnabled(true);
                this._recordAction.setEnabled(false);
                this._playAction.setEnabled(false);
            } else {
                this._stopAction.setEnabled(false);
                this._recordAction.setEnabled(true);
                this._playAction.setEnabled(true);
            }
        } else {
            this._stopAction.setEnabled(false);
            this._recordAction.setEnabled(false);
            this._playAction.setEnabled(false);
        }
    }

    private void addActionToToolbar(Action action) {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolBar = actionBars.getToolBarManager();
        toolBar.add((IAction)action);
    }

    private void createViewer(Composite parent) {
        this._contentProvider = new ViewContentProvider();
        this._viewer = new TableViewer(parent, 2050);
        this._viewer.setContentProvider((IContentProvider)this._contentProvider);
        this._decorator = new GemocLabelDecorator();
        this.createColumn(parent);
        Table table = this._viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData grid = new GridData(4, 4, true, true);
        this._viewer.getControl().setLayoutData((Object)grid);
    }

    private void createMenuManager() {
        MenuManager menuManager;
        this._menuManager = menuManager = new MenuManager();
        this._menuManager.setRemoveAllWhenShown(true);
        this._menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                StimuliManagerView.this.fillContextMenu(mgr);
            }
        });
        Menu menu = this._menuManager.createContextMenu(this._viewer.getControl());
        this._viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(this._menuManager, (ISelectionProvider)this._viewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this._viewer);
    }

    private void fillContextMenu(IMenuManager mgr) {
        mgr.add((IContributionItem)new GroupMarker("additions"));
    }

    private void createColumn(Composite parent) {
        TableViewerColumn viewerColumn1 = new TableViewerColumn(this._viewer, 16384);
        TableColumn column1 = viewerColumn1.getColumn();
        column1.setText("Clock");
        column1.setWidth(100);
        column1.setResizable(true);
        column1.setMoveable(true);
        this._column1LabelProvider = new DecoratingColumLabelProvider((ILabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String result = new String();
                if (element instanceof ModelSpecificEventWrapper) {
                    ModelSpecificEvent mse = ((ModelSpecificEventWrapper)element).getMSE();
                    result = mse.getName();
                }
                return result;
            }

            public Image getImage(Object element) {
                if (element instanceof ModelSpecificEventWrapper) {
                    ClockStatus state = ((ModelSpecificEventWrapper)element).getState();
                    switch (state) {
                        case NOTFORCED_SET: {
                            return SharedIcons.getSharedImage(SharedIcons.NOTFORCED_CLOCK_SET);
                        }
                        case FORCED_SET: {
                            return SharedIcons.getSharedImage(SharedIcons.FORCED_CLOCK_SET);
                        }
                        case NOTFORCED_NOTSET: {
                            return SharedIcons.getSharedImage(SharedIcons.NOTFORCED_CLOCK_NOTSET);
                        }
                        case FORCED_NOTSET: {
                            return SharedIcons.getSharedImage(SharedIcons.FORCED_CLOCK_NOTSET);
                        }
                    }
                }
                return null;
            }

            public Color getBackground(Object element) {
                if (element instanceof ModelSpecificEventWrapper) {
                    ModelSpecificEvent solverEvent = ((ModelSpecificEventWrapper)element).getMSE();
                    boolean isRepresented = StimuliManagerView.this._eventsToPresent.contains(EcoreUtil.getURI((EObject)solverEvent));
                    if (isRepresented) {
                        return StimuliManagerView.this.representedEventColor;
                    }
                    ClockStatus state = ((ModelSpecificEventWrapper)element).getState();
                    switch (state) {
                        case NOTFORCED_SET: {
                            return StimuliManagerView.this.notForcedSetColor;
                        }
                        case FORCED_SET: {
                            return StimuliManagerView.this.forcedSetColor;
                        }
                        case FORCED_NOTSET: {
                            return StimuliManagerView.this.forcedNotSetColor;
                        }
                    }
                }
                return super.getBackground(element);
            }
        }, (ILabelDecorator)this._decorator);
        viewerColumn1.setLabelProvider((CellLabelProvider)this._column1LabelProvider);
    }

    private void createInformationAndButtons(Composite parent) {
        this._informationBar = new Composite(this._bottomComposite, 2048);
        this._informationBar.setLayout((Layout)new GridLayout(3, false));
        this._informationBar.setLayoutData((Object)new GridData(4, 4, true, false));
        this._informationBar.setBackground(new Color((Device)parent.getDisplay(), 255, 255, 255));
        Label icon = new Label(this._informationBar, 5);
        icon.setImage(SharedIcons.getSharedImage(SharedIcons.ENGINE_ICON));
        this._viewStateLabel = new Label(this._informationBar, 0);
        Composite buttonBar = new Composite(this._informationBar, 0);
        buttonBar.setLayout((Layout)new GridLayout(3, false));
        buttonBar.setLayoutData((Object)new GridData(4, 4, true, false));
        Button _freeButton = new Button(buttonBar, 8);
        _freeButton.setImage(SharedIcons.getSharedImage(SharedIcons.NOTFORCED_CLOCK_NOTSET));
        _freeButton.setToolTipText("Free");
        _freeButton.setData((Object)ClockStatus.NOTFORCED_NOTSET);
        _freeButton.setLayoutData((Object)new GridData(0x1000008, 0, true, false));
        Button _forceFalseButton = new Button(buttonBar, 8);
        _forceFalseButton.setImage(SharedIcons.getSharedImage(SharedIcons.FORCED_CLOCK_NOTSET));
        _forceFalseButton.setToolTipText("Force to not tick");
        _forceFalseButton.setData((Object)ClockStatus.FORCED_NOTSET);
        _forceFalseButton.setLayoutData((Object)new GridData(0x1000008, 0, false, false));
        Button _forceTrueButton = new Button(buttonBar, 8);
        _forceTrueButton.setImage(SharedIcons.getSharedImage(SharedIcons.FORCED_CLOCK_SET));
        _forceTrueButton.setToolTipText("Force to tick");
        _forceTrueButton.setData((Object)ClockStatus.FORCED_SET);
        _forceTrueButton.setLayoutData((Object)new GridData(0x1000008, 0, false, false));
        this._mseControlButtons = new ArrayList<Button>();
        this._mseControlButtons.add(_freeButton);
        this._mseControlButtons.add(_forceFalseButton);
        this._mseControlButtons.add(_forceTrueButton);
        for (Button b : this._mseControlButtons) {
            b.addSelectionListener(this._menuAndButtonListener);
        }
        this.updateInformationAndButtons();
    }

    private SelectionListener createSelectionListener() {
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection selection = (StructuredSelection)StimuliManagerView.this._viewer.getSelection();
                ArrayList<ModelSpecificEventWrapper> mses = new ArrayList<ModelSpecificEventWrapper>();
                for (Object o : selection.toList()) {
                    mses.add((ModelSpecificEventWrapper)o);
                }
                ClockStatus state = ClockStatus.NOTFORCED_NOTSET;
                if (e.getSource() instanceof MenuItem) {
                    state = (ClockStatus)((Object)((MenuItem)e.getSource()).getData());
                }
                if (e.getSource() instanceof Button) {
                    state = (ClockStatus)((Object)((Button)e.getSource()).getData());
                }
                StimuliManagerView.this.forceClocks(mses, state);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        return listener;
    }

    private void forceClocks(Collection<ModelSpecificEventWrapper> mses, ClockStatus state) {
        this.getMSEContext().forceClocks(mses, state);
        this.updateView();
    }

    public void updateView() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                StimuliManagerView.this.updateActionsVisibility();
                if (!StimuliManagerView.this.isEngineStopped() && StimuliManagerView.this.getMSEContext() != null) {
                    StimuliManagerView.this.getMSEContext().refreshFutureTickingFreeClocks();
                    StimuliManagerView.this._contentProvider.setFilterStrategy(StimuliManagerView.this._strategyFilterSelected);
                    StimuliManagerView.this._decorator.setResourceSet(((IConcurrentExecutionContext)StimuliManagerView.this.getMSEContext().getEngine().getExecutionContext()).getResourceModel().getResourceSet());
                    StimuliManagerView.this._decorator.mapping.clear();
                    StimuliManagerView.this._viewer.setInput((Object)StimuliManagerView.this.getMSEContext().getMSESet());
                } else {
                    StimuliManagerView.this._viewer.setInput(null);
                }
                StimuliManagerView.this.updateComposites();
                TableColumn[] tableColumnArray = StimuliManagerView.this._viewer.getTable().getColumns();
                int n = tableColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableColumn c = tableColumnArray[n2];
                    c.pack();
                    ++n2;
                }
            }
        });
    }

    private boolean isEngineStopped() {
        if (this._currentSelectedEngine != null) {
            return this._currentSelectedEngine.getRunningStatus().equals((Object)EngineStatus.RunStatus.Stopped);
        }
        return false;
    }

    private void update(IExecutionEngine<?> engine) {
        if (engine == this._currentSelectedEngine) {
            int engineStep = (int)this._currentSelectedEngine.getEngineStatus().getNbLogicalStepRun();
            if (!this.isEngineStopped() && engineStep > this.getMSEContext().getCacheStep()) {
                ScenarioManager sm = this.getScenarioManager();
                if (sm.getState().equals((Object)ScenarioManagerState.Recording)) {
                    sm.record();
                }
                this.getMSEContext().setCacheStep(engineStep);
                if (sm.getState().equals((Object)ScenarioManagerState.Playing)) {
                    sm.play();
                }
            }
            this.updateView();
        }
    }

    public void engineSelectionChanged(IExecutionEngine<?> engine) {
        if (engine != null && engine instanceof IConcurrentExecutionEngine) {
            this._currentSelectedEngine = (IConcurrentExecutionEngine)engine;
            if (this.isEngineStopped()) {
                if (this._mseContextMap.get(engine) != null) {
                    ScenarioManager sm = this.getScenarioManager();
                    if (sm.getState().equals((Object)ScenarioManagerState.Recording)) {
                        sm.stopRecord();
                    }
                    if (sm.getState().equals((Object)ScenarioManagerState.Playing)) {
                        sm.stopPlaying();
                    }
                    engine.getExecutionContext().getExecutionPlatform().removeEngineAddon((IEngineAddon)this);
                    this._mseContextMap.remove(engine);
                }
            } else {
                engine.getExecutionContext().getExecutionPlatform().removeEngineAddon((IEngineAddon)this);
                engine.getExecutionContext().getExecutionPlatform().addEngineAddon((IEngineAddon)this);
                if (this._mseContextMap.get(engine) == null) {
                    this.createMSEContext();
                    if (engine.getExecutionContext().getExecutionMode().equals((Object)ExecutionMode.Animation)) {
                        this.bring2Top();
                    }
                }
                this._recordAction.setEnabled(true);
                this._playAction.setEnabled(true);
            }
            this.updateView();
        } else {
            this._viewer.setInput(null);
        }
    }

    private void createMSEContext() {
        ModelSpecificEventContext context = new ModelSpecificEventContext(this._currentSelectedEngine);
        this._mseContextMap.put(this._currentSelectedEngine, context);
    }

    public void dispose() {
        Activator.getDefault().getEventPresenters().remove((Object)this);
        super.dispose();
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener("org.eclipse.gemoc.executionframework.engine.io.views.steps.LogicalStepsView", this._decisionViewListener);
        this._contentProvider.dispose();
        if (this._currentSelectedEngine != null) {
            ((IConcurrentExecutionPlatform)((IConcurrentExecutionContext)this._currentSelectedEngine.getExecutionContext()).getExecutionPlatform()).removeEngineAddon((IEngineAddon)this);
        }
        this._currentSelectedEngine = null;
        this._column1LabelProvider.dispose();
        this.notForcedSetColor.dispose();
        this.forcedSetColor.dispose();
        this.forcedNotSetColor.dispose();
        this.representedEventColor.dispose();
        this._eventsToPresent.clear();
    }

    public void setFocus() {
        this._viewer.getTable().setFocus();
    }

    public IExecutionEngine<?> getEngine() {
        return this._currentSelectedEngine;
    }

    private ScenarioManager getCurrentScenarioManager() {
        if (this.getMSEContext() != null) {
            return this.getMSEContext().getScenarioManager();
        }
        return null;
    }

    public void startRecordScenario() {
        this.getCurrentScenarioManager().startRecord();
        this.updateView();
    }

    private ScenarioManager getScenarioManager() {
        if (this.getMSEContext() == null) {
            return null;
        }
        return this.getMSEContext().getScenarioManager();
    }

    public void stopRecordScenario() {
        this.getScenarioManager().stopRecord();
        this.updateView();
    }

    public void playScenario(IPath path) throws ScenarioException {
        if (path == null) {
            throw new ScenarioException("Cannot start playing because the scenario path is null.");
        }
        ScenarioManager sm = this.getScenarioManager();
        if (sm == null || !sm.getState().equals((Object)ScenarioManagerState.Idle)) {
            throw new ScenarioException("Cannot start playing because a scenario is already being played.");
        }
        this.getScenarioManager().startPlaying(path);
    }

    public void stopPlayScenario() {
        this.getScenarioManager().stopPlaying();
    }

    public void informationMsg(final String title, final String msg) {
        final StimuliManagerView eventView = this;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openInformation((Shell)eventView.getSite().getShell(), (String)title, (String)msg);
            }
        });
    }

    private void updateComposites() {
        StackLayout layout = (StackLayout)this._bottomComposite.getLayout();
        layout.topControl = this._informationBar;
        this._bottomComposite.layout();
        this.updateInformationAndButtons();
    }

    private void updateInformationAndButtons() {
        if (this._viewStateLabel != null) {
            this.enableOrDisableButtons(this._mseControlButtons);
            ScenarioManager sm = this.getScenarioManager();
            if (sm == null || sm.getState() == ScenarioManagerState.Idle) {
                this._viewStateLabel.setText("");
            } else {
                this._viewStateLabel.setText(String.valueOf(sm.getState().toString()) + " ...");
            }
        }
    }

    private void enableOrDisableButtons(List<Button> controlButtons) {
        if (controlButtons != null) {
            for (Button b : controlButtons) {
                b.setEnabled(this.getMSEContext() != null);
            }
        }
    }

    private void bring2Top() {
        this.getSite().getPage().bringToTop((IWorkbenchPart)this);
    }

    public void present(List<URI> events) {
        this._eventsToPresent = events;
        if (this._currentSelectedEngine != null) {
            ResourceSet rs = ((IConcurrentExecutionContext)this._currentSelectedEngine.getExecutionContext()).getResourceModel().getResourceSet();
            for (URI uri : this._eventsToPresent) {
                EObject event = rs.getEObject(uri, false);
                ModelSpecificEventWrapper toRefresh = (ModelSpecificEventWrapper)this._decorator.mapping.get(event);
                if (toRefresh == null) continue;
                this._viewer.refresh((Object)toRefresh);
            }
        }
    }

    public void engineAboutToStart(IExecutionEngine<?> engine) {
    }

    public void engineStarted(IExecutionEngine<?> executionEngine) {
    }

    public void engineAboutToStop(IExecutionEngine<?> engine) {
    }

    public void engineStopped(IExecutionEngine<?> engine) {
    }

    public void aboutToSelectStep(IExecutionEngine<?> engine, Collection<Step<?>> logicalSteps) {
        this.update(engine);
    }

    public void stepSelected(IExecutionEngine<?> engine, Step<?> selectedLogicalStep) {
    }

    public void engineStatusChanged(IExecutionEngine<?> engine, EngineStatus.RunStatus newStatus) {
    }

    public void engineAboutToDispose(IExecutionEngine<?> engine) {
    }

    public List<String> validate(List<IEngineAddon> otherAddons) {
        return new ArrayList<String>();
    }

    public void proposedStepsChanged(IExecutionEngine<?> engine, Collection<Step<?>> steps) {
        this.update(engine);
    }

    public void aboutToExecuteStep(IExecutionEngine<?> engine, Step<?> stepToExecute) {
    }

    public void stepExecuted(IExecutionEngine<?> engine, Step<?> stepExecuted) {
    }

    private static final class GemocLabelDecorator
    extends DSLLabelDecorator {
        private static final String MODEL_ID = "org.eclipse.gemoc.gemoc_modeling_workbench.ui.debugModel";
        private Map<ModelSpecificEvent, ModelSpecificEventWrapper> mapping = new HashMap<ModelSpecificEvent, ModelSpecificEventWrapper>();

        public GemocLabelDecorator() {
            super(MODEL_ID);
        }

        public Image decorateImage(Image image, Object element) {
            Image res;
            if (element instanceof ModelSpecificEventWrapper) {
                ModelSpecificEvent solverEvent = ((ModelSpecificEventWrapper)element).getMSE();
                this.mapping.put(solverEvent, (ModelSpecificEventWrapper)element);
                res = super.decorateImage(image, (Object)solverEvent);
            } else {
                res = super.decorateImage(image, element);
            }
            return res;
        }

        public String decorateText(String text, Object element) {
            String res;
            if (element instanceof ModelSpecificEventWrapper) {
                ModelSpecificEvent solverEvent = ((ModelSpecificEventWrapper)element).getMSE();
                this.mapping.put(solverEvent, (ModelSpecificEventWrapper)element);
                res = super.decorateText(text, (Object)solverEvent);
            } else {
                res = super.decorateText(text, element);
            }
            return res;
        }

        protected Object getElement(ResourceSet rs, DSLBreakpoint breakpoint) {
            EObject instruction = rs.getEObject(breakpoint.getURI(), false);
            Object res = instruction instanceof ModelSpecificEvent ? this.mapping.get(instruction) : super.getElement(rs, breakpoint);
            return res;
        }

        public void dispose() {
            this.mapping.clear();
            super.dispose();
        }
    }
}

