/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.deciders.actions;

import java.util.ArrayList;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.deciders.actions.DeciderAction;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.deciders.actions.DeciderManager;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.core.IConcurrentExecutionEngine;
import org.eclipse.gemoc.executionframework.ui.views.engine.actions.AbstractEngineAction;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionEngine;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class SwitchDeciderAction
extends AbstractEngineAction {
    private ArrayList<DeciderAction> _subActions;
    private DeciderAction _mainAction;
    private Menu _menu;

    public SwitchDeciderAction() {
        super(4);
    }

    protected void init() {
        this._mainAction = DeciderManager.getStepByStepDeciderAction();
        this._subActions = new ArrayList();
        for (DeciderAction action : DeciderManager.getAllDeciderActions()) {
            this._subActions.add(action);
        }
    }

    protected void updateButton() {
        if (this._mainAction != null) {
            this.setText(this._mainAction.getText());
            this.setToolTipText(this._mainAction.getToolTipText());
            this.setImageDescriptor(this._mainAction.getImageDescriptor());
        }
    }

    public void run() {
        if (this.getCurrentSelectedEngine() != null && this._mainAction != null) {
            this._mainAction.run();
        }
    }

    public Menu getMenu(Control parent) {
        if (this._menu == null) {
            this._menu = new Menu(parent);
            for (Action action : this._subActions) {
                ActionContributionItem item = new ActionContributionItem((IAction)action);
                item.fill(this._menu, -1);
            }
        }
        return this._menu;
    }

    public void dispose() {
        super.dispose();
        if (this._menu != null) {
            this._menu.dispose();
        }
    }

    public void engineSelectionChanged(IExecutionEngine engine) {
        super.engineSelectionChanged(engine);
        if (engine instanceof IConcurrentExecutionEngine) {
            for (DeciderAction action : DeciderManager.getAllDeciderActions()) {
                action.setEngine((IConcurrentExecutionEngine)this.getCurrentSelectedEngine());
            }
        }
    }
}

