/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.dsl.debug.ide;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gemoc.dsl.debug.ide.Activator;
import org.eclipse.gemoc.dsl.debug.ide.IDSLDebugger;

public class ThreadController {
    private final IDSLDebugger debugger;
    private final String threadName;
    private EObject nextIntructionToSuspend;
    private boolean suspended;
    private boolean terminated;
    private IDSLDebugger.Stepping stepping = IDSLDebugger.Stepping.NONE;
    private boolean wasSignalled;

    public ThreadController(IDSLDebugger debugger, String threadName) {
        this.debugger = debugger;
        this.threadName = threadName;
    }

    public void suspend() {
        this.suspended = true;
        this.stepping = IDSLDebugger.Stepping.NONE;
    }

    public synchronized void resume() {
        this.suspended = false;
        this.stepping = IDSLDebugger.Stepping.NONE;
        this.wakeUp();
    }

    public synchronized void terminate() {
        this.terminated = true;
        this.suspended = false;
        this.stepping = IDSLDebugger.Stepping.NONE;
        this.wakeUp();
    }

    public synchronized void stepInto() {
        this.suspended = false;
        this.stepping = IDSLDebugger.Stepping.STEP_INTO;
        this.wakeUp();
    }

    public synchronized void stepOver() {
        this.suspended = false;
        this.stepping = IDSLDebugger.Stepping.STEP_OVER;
        this.wakeUp();
    }

    public synchronized void stepReturn() {
        this.suspended = false;
        this.stepping = IDSLDebugger.Stepping.STEP_RETURN;
        this.wakeUp();
    }

    public synchronized void wakeUp() {
        this.wasSignalled = true;
        this.notify();
    }

    public synchronized void putAsleep() {
        while (!this.wasSignalled) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Activator.getDefault().error(e);
            }
        }
        this.wasSignalled = false;
    }

    public synchronized boolean control(EObject instruction) {
        boolean res;
        boolean bl = res = !this.debugger.isTerminated() && !this.terminated;
        if (res) {
            if (this.suspended) {
                this.debugger.suspended(this.threadName);
                this.debugger.updateData(this.threadName, instruction);
                this.putAsleep();
                this.resuming(instruction);
            } else if (this.debugger.shouldBreak(instruction)) {
                this.debugger.breaked(this.threadName);
                this.debugger.updateData(this.threadName, instruction);
                this.putAsleep();
                this.resuming(instruction);
            } else if (this.stepping != IDSLDebugger.Stepping.NONE && (this.nextIntructionToSuspend == null || this.nextIntructionToSuspend == instruction)) {
                this.debugger.stepped(this.threadName);
                this.debugger.updateData(this.threadName, instruction);
                this.putAsleep();
                this.resuming(instruction);
            }
        }
        return res;
    }

    private void resuming(EObject instruction) {
        switch (this.stepping) {
            case STEP_INTO: {
                this.debugger.steppingInto(this.threadName);
                this.nextIntructionToSuspend = this.debugger.getNextInstruction(this.threadName, instruction, this.stepping);
                break;
            }
            case STEP_OVER: {
                this.debugger.steppingOver(this.threadName);
                this.nextIntructionToSuspend = this.debugger.getNextInstruction(this.threadName, instruction, this.stepping);
                break;
            }
            case STEP_RETURN: {
                this.debugger.steppingReturn(this.threadName);
                this.nextIntructionToSuspend = this.debugger.getNextInstruction(this.threadName, instruction, this.stepping);
                break;
            }
            default: {
                if (!this.terminated) {
                    this.debugger.resuming(this.threadName);
                    break;
                }
                this.debugger.terminated(this.threadName);
            }
        }
    }
}

