/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.transaction.txn;

public interface TransactionalSystemControl {
    public void startReadOnlyDatabase();

    public void finishReadOnlyDatabase();

    default public void execReadOnlyDatabase(Runnable action) {
        this.startReadOnlyDatabase();
        try {
            action.run();
        }
        finally {
            this.finishReadOnlyDatabase();
        }
    }

    public void startNonExclusiveMode();

    default public boolean tryNonExclusiveMode() {
        return this.tryNonExclusiveMode(false);
    }

    public boolean tryNonExclusiveMode(boolean var1);

    public void finishNonExclusiveMode();

    public void startExclusiveMode();

    default public boolean tryExclusiveMode() {
        return this.tryExclusiveMode(false);
    }

    public boolean tryExclusiveMode(boolean var1);

    public void finishExclusiveMode();

    default public void execExclusive(Runnable action) {
        this.startExclusiveMode();
        try {
            action.run();
        }
        finally {
            this.finishExclusiveMode();
        }
    }
}

