/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.ui.views.emfstorebrowser.dialogs.admin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.emfstore.client.model.AdminBroker;
import org.eclipse.emf.emfstore.client.ui.Activator;
import org.eclipse.emf.emfstore.client.ui.util.EMFStoreMessageDialog;
import org.eclipse.emf.emfstore.client.ui.views.emfstorebrowser.dialogs.admin.PropertiesForm;
import org.eclipse.emf.emfstore.client.ui.views.emfstorebrowser.dialogs.admin.TabContent;
import org.eclipse.emf.emfstore.client.ui.views.emfstorebrowser.dialogs.admin.acimport.wizard.AcUserImportAction;
import org.eclipse.emf.emfstore.server.ServerConfiguration;
import org.eclipse.emf.emfstore.server.exceptions.EmfStoreException;
import org.eclipse.emf.emfstore.server.model.accesscontrol.ACOrgUnit;
import org.eclipse.emf.emfstore.server.model.accesscontrol.ACUser;
import org.eclipse.emf.emfstore.server.model.accesscontrol.roles.Role;
import org.eclipse.emf.emfstore.server.model.accesscontrol.roles.ServerAdmin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserTabContent
extends TabContent
implements IPropertyChangeListener {
    public UserTabContent(String string, AdminBroker adminBroker, PropertiesForm frm) {
        super(string, adminBroker, frm);
        this.setTab(this);
    }

    @Override
    protected List<Action> initActions() {
        Action createNewUser = new Action("Create new user"){

            public void run() {
                try {
                    UserTabContent.this.getAdminBroker().createUser("New User");
                }
                catch (EmfStoreException e) {
                    EMFStoreMessageDialog.showExceptionDialog((Exception)((Object)e));
                }
                UserTabContent.this.getTableViewer().refresh();
                UserTabContent.this.getForm().getTableViewer().refresh();
            }
        };
        createNewUser.setImageDescriptor(Activator.getImageDescriptor("icons/user.png"));
        createNewUser.setToolTipText("Create new user");
        DeleteUserAction deleteUser = new DeleteUserAction("Delete user");
        deleteUser.setImageDescriptor(Activator.getImageDescriptor("icons/delete.gif"));
        deleteUser.setToolTipText("Delete user");
        AcUserImportAction importOrgUnit = new AcUserImportAction(this.getAdminBroker());
        importOrgUnit.addPropertyChangeListener(this);
        return Arrays.asList(new Action[]{createNewUser, deleteUser, importOrgUnit});
    }

    @Override
    public ITableLabelProvider getLabelProvider() {
        return new ITableLabelProvider(){

            public void addListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return Activator.getImageDescriptor("icons/user.png").createImage();
            }

            public String getColumnText(Object element, int columnIndex) {
                return ((ACUser)element).getName();
            }
        };
    }

    @Override
    public IStructuredContentProvider getContentProvider() {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                ArrayList users = new ArrayList();
                try {
                    users.addAll(UserTabContent.this.getAdminBroker().getUsers());
                }
                catch (EmfStoreException e) {
                    EMFStoreMessageDialog.showExceptionDialog((Exception)((Object)e));
                }
                return users.toArray(new ACUser[users.size()]);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.getTableViewer().refresh();
    }

    private final class DeleteUserAction
    extends Action {
        private DeleteUserAction(String text) {
            super(text);
        }

        public void run() {
            IStructuredSelection selection = (IStructuredSelection)UserTabContent.this.getTableViewer().getSelection();
            for (ACUser ou : selection) {
                if (ou == null) {
                    return;
                }
                try {
                    String superUser = ServerConfiguration.getProperties().getProperty("emfstore.accesscontrol.authentication.superuser", "super");
                    boolean isAdmin = false;
                    for (Role userRole : ou.getRoles()) {
                        if (ou.getName().compareTo(superUser) != 0 || !(userRole instanceof ServerAdmin)) continue;
                        isAdmin = true;
                        break;
                    }
                    if (isAdmin) {
                        Display display = Display.getCurrent();
                        MessageDialog.openInformation((Shell)display.getActiveShell(), (String)"Illegal deletion attempt", (String)"It is not allowed to delete the super user!");
                    } else {
                        UserTabContent.this.getAdminBroker().deleteUser(ou.getId());
                    }
                }
                catch (EmfStoreException e) {
                    EMFStoreMessageDialog.showExceptionDialog((Exception)((Object)e));
                }
                if (!(UserTabContent.this.getForm().getCurrentInput() instanceof ACOrgUnit) || !UserTabContent.this.getForm().getCurrentInput().equals(ou)) continue;
                UserTabContent.this.getForm().setInput(null);
            }
            UserTabContent.this.getTableViewer().refresh();
        }
    }
}

