/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.common.utilities;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.common.Activator;
import org.eclipse.emf.ecp.common.model.ECPWorkspaceManager;
import org.eclipse.emf.ecp.common.observer.ModelElementOpenObserver;
import org.eclipse.emf.ecp.common.util.ModelElementOpener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public final class ActionHelper {
    public static final String MEEDITOR_ID = "org.eclipse.emf.ecp.editor";
    public static final String MEEDITOR_OPENMODELELEMENT_COMMAND_ID = "org.eclipse.emf.ecp.editor.openModelElement";
    public static final String MECONTEXT_EVALUATIONCONTEXT_VARIABLE = "meContext";
    public static final String ME_TO_OPEN_EVALUATIONCONTEXT_VARIABLE = "meToOpen";

    private ActionHelper() {
    }

    public static void openModelElement(EObject me, String sourceView) {
        if (me == null) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"The element was deleted", (String)"The model element you are trying to open was deleted!");
            return;
        }
        IConfigurationElement[] modelelementopener = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.emf.ecp.common.modelelementopener");
        ModelElementOpener bestCandidate = null;
        int bestValue = -1;
        String name = "";
        IConfigurationElement[] iConfigurationElementArray = modelelementopener;
        int n = modelelementopener.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            modelelementopener = null;
            try {
                ModelElementOpener modelelementOpener = (ModelElementOpener)element.createExecutableExtension("class");
                int value = modelelementOpener.canOpen(me);
                if (value > bestValue) {
                    bestCandidate = modelelementOpener;
                    bestValue = value;
                    name = element.getAttribute("name");
                }
            }
            catch (CoreException e) {
                Activator.getDefault().logException(e.getMessage(), (Exception)((Object)e));
            }
            ++n2;
        }
        ((ModelElementOpenObserver)ECPWorkspaceManager.getObserverBus().notify(ModelElementOpenObserver.class)).onOpen(me, sourceView, name);
        try {
            bestCandidate.openModelElement(me);
        }
        catch (RuntimeException e) {
            Activator.getDefault().logException(e);
        }
    }
}

