/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfatic.ui.preferences;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.emfatic.ui.editor.HighlightingManager;
import org.eclipse.emf.emfatic.ui.editor.ThemeChangeListener;
import org.eclipse.emf.emfatic.ui.preferences.EmfaticColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class EmfaticSyntaxColoringPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    protected HighlightingManager highlightingManager;
    protected IPreferenceStore preferenceStore;
    protected List<String> colorPreferences;
    protected Map<String, String> preferenceLabels;
    protected List<EmfaticColorFieldEditor> colorFieldEditors;
    protected ThemeChangeListener themeChangeListener = new ThemeChangeListener(){

        @Override
        public void themeChange() {
            EmfaticSyntaxColoringPreferencePage.this.highlightingManager.initialiseDefaultColors();
            for (EmfaticColorFieldEditor fieldEditor : EmfaticSyntaxColoringPreferencePage.this.colorFieldEditors) {
                if (EmfaticSyntaxColoringPreferencePage.this.preferenceStore.contains(fieldEditor.getPreferenceName())) {
                    fieldEditor.load();
                    continue;
                }
                fieldEditor.loadDefault();
            }
        }
    };

    public void init(IWorkbench workbench) {
        this.highlightingManager = new HighlightingManager();
        this.colorPreferences = HighlightingManager.COLOR_PREFERENCES;
        this.preferenceStore = this.highlightingManager.getPreferenceStore();
        this.preferenceLabels = new HashMap<String, String>();
        this.preferenceLabels.put(HighlightingManager.COMMENT_COLOR_PREF, "Comments: ");
        this.preferenceLabels.put(HighlightingManager.LITERAL_COLOR_PREF, "Literals: ");
        this.preferenceLabels.put(HighlightingManager.ID_COLOR_PREF, "Ids: ");
        this.preferenceLabels.put(HighlightingManager.NORMAL_KEYWORDS_COLOR_PREF, "Normal keywords: ");
        this.preferenceLabels.put(HighlightingManager.SPECIAL_KEYWORDS_COLOR_PREF, "Special keywords: ");
        this.preferenceLabels.put(HighlightingManager.BASIC_TYPES_COLOR_PREF, "Basic types: ");
        workbench.getThemeManager().addPropertyChangeListener((IPropertyChangeListener)this.themeChangeListener);
    }

    protected void createFieldEditors() {
        ArrayList<String> sortedPreferences = new ArrayList<String>(this.colorPreferences);
        sortedPreferences.sort(new Comparator<String>(){

            @Override
            public int compare(String pref1, String pref2) {
                return EmfaticSyntaxColoringPreferencePage.this.preferenceLabels.get(pref1).compareTo(EmfaticSyntaxColoringPreferencePage.this.preferenceLabels.get(pref2));
            }
        });
        this.colorFieldEditors = new ArrayList<EmfaticColorFieldEditor>();
        for (String preference : sortedPreferences) {
            EmfaticColorFieldEditor fieldEditor = new EmfaticColorFieldEditor(preference, this.preferenceLabels.get(preference), this.getFieldEditorParent());
            this.colorFieldEditors.add(fieldEditor);
            this.addField((FieldEditor)fieldEditor);
        }
    }

    public IPreferenceStore getPreferenceStore() {
        return this.preferenceStore;
    }
}

