/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gymnast.runtime.ui.views.console;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.gymnast.runtime.core.util.IReporter;
import org.eclipse.gymnast.runtime.ui.util.LDTColorProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class ReporterConsole
implements IReporter {
    private RGB BLACK = new RGB(0, 0, 0);
    private RGB BLUE = new RGB(0, 0, 255);
    private RGB RED = new RGB(255, 0, 0);
    private RGB ORANGE = new RGB(255, 128, 0);
    private final LDTColorProvider _colorProvider = new LDTColorProvider();
    private final MessageConsole _console;
    private final MessageConsoleStream _outStream;
    private final MessageConsoleStream _subStream;
    private final MessageConsoleStream _wrnStream;
    private final MessageConsoleStream _errStream;

    public ReporterConsole(String name) {
        this._console = new MessageConsole(name, null);
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{this._console});
        this._outStream = this._console.newMessageStream();
        this._outStream.setColor(this.getColor(this.BLUE));
        this._subStream = this._console.newMessageStream();
        this._subStream.setColor(this.getColor(this.BLACK));
        this._wrnStream = this._console.newMessageStream();
        this._wrnStream.setColor(this.getColor(this.ORANGE));
        this._errStream = this._console.newMessageStream();
        this._errStream.setColor(this.getColor(this.RED));
    }

    public void report(String message) {
        this.report(message, 0);
    }

    public void report(String message, int level) {
        if (level == 0) {
            this._outStream.println(message);
        } else {
            this._subStream.println(this.indentMessage(message, level));
        }
    }

    private String indentMessage(String message, int level) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < level) {
            sb.append("  ");
            ++i;
        }
        sb.append(message);
        return sb.toString();
    }

    public void reportWarning(String message) {
        this._wrnStream.println(message);
    }

    public void reportError(String message) {
        this._errStream.println(message);
    }

    public void reportError(Exception ex) {
        StringWriter sw = new StringWriter();
        ex.printStackTrace(new PrintWriter(sw));
        this._errStream.println(sw.toString());
    }

    private Color getColor(RGB rgb) {
        return this._colorProvider.getColor(rgb);
    }
}

