/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.UserConfig;
import org.eclipse.jgit.util.SystemReader;
import org.eclipse.jgit.util.time.ProposedTimestamp;

public class PersonIdent
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final DateTimeFormatter OFFSET_FORMATTER = DateTimeFormatter.ofPattern("Z", Locale.US);
    private final String name;
    private final String emailAddress;
    private final Instant when;
    private final ZoneId tzOffset;

    public static TimeZone getTimeZone(int tzOffset) {
        StringBuilder tzId = new StringBuilder(8);
        tzId.append("GMT");
        PersonIdent.appendTimezone(tzId, tzOffset);
        return TimeZone.getTimeZone(tzId.toString());
    }

    public static ZoneId getZoneId(int tzOffset) {
        return ZoneOffset.ofHoursMinutes(tzOffset / 60, tzOffset % 60);
    }

    public static void appendTimezone(StringBuilder r, int offset) {
        char sign;
        if (offset < 0) {
            sign = '-';
            offset = -offset;
        } else {
            sign = '+';
        }
        int offsetHours = offset / 60;
        int offsetMins = offset % 60;
        r.append(sign);
        if (offsetHours < 10) {
            r.append('0');
        }
        r.append(offsetHours);
        if (offsetMins < 10) {
            r.append('0');
        }
        r.append(offsetMins);
    }

    public static void appendSanitized(StringBuilder r, String str) {
        int i = 0;
        while (i < str.length() && str.charAt(i) <= ' ') {
            ++i;
        }
        int end = str.length();
        while (end > i && str.charAt(end - 1) <= ' ') {
            --end;
        }
        while (i < end) {
            char c = str.charAt(i);
            switch (c) {
                case '\n': 
                case '<': 
                case '>': {
                    break;
                }
                default: {
                    r.append(c);
                }
            }
            ++i;
        }
    }

    public PersonIdent(Repository repo) {
        this(repo.getConfig().get(UserConfig.KEY));
    }

    public PersonIdent(PersonIdent pi) {
        this(pi.getName(), pi.getEmailAddress());
    }

    public PersonIdent(String aName, String aEmailAddress) {
        this(aName, aEmailAddress, SystemReader.getInstance().now());
    }

    public PersonIdent(String aName, String aEmailAddress, ProposedTimestamp when) {
        this(aName, aEmailAddress, when.instant());
    }

    @Deprecated(since="7.1")
    public PersonIdent(PersonIdent pi, Date when, TimeZone tz) {
        this(pi.getName(), pi.getEmailAddress(), when.toInstant(), tz.toZoneId());
    }

    public PersonIdent(PersonIdent pi, Instant when, ZoneId tz) {
        this(pi.getName(), pi.getEmailAddress(), when, tz);
    }

    @Deprecated(since="7.1")
    public PersonIdent(PersonIdent pi, Date aWhen) {
        this(pi.getName(), pi.getEmailAddress(), aWhen.toInstant(), pi.tzOffset);
    }

    public PersonIdent(PersonIdent pi, Instant aWhen) {
        this(pi.getName(), pi.getEmailAddress(), aWhen, pi.tzOffset);
    }

    @Deprecated(since="7.1")
    public PersonIdent(String aName, String aEmailAddress, Date aWhen, TimeZone aTZ) {
        this(aName, aEmailAddress, aWhen.toInstant(), aTZ.toZoneId());
    }

    public PersonIdent(String aName, String aEmailAddress, Instant aWhen, ZoneId zoneId) {
        if (aName == null) {
            throw new IllegalArgumentException(JGitText.get().personIdentNameNonNull);
        }
        if (aEmailAddress == null) {
            throw new IllegalArgumentException(JGitText.get().personIdentEmailNonNull);
        }
        this.name = aName;
        this.emailAddress = aEmailAddress;
        this.when = aWhen;
        this.tzOffset = zoneId;
    }

    @Deprecated(since="7.1")
    public PersonIdent(PersonIdent pi, long aWhen, int aTZ) {
        this(pi.getName(), pi.getEmailAddress(), Instant.ofEpochMilli(aWhen), PersonIdent.getZoneId(aTZ));
    }

    private PersonIdent(String aName, String aEmailAddress, Instant when) {
        this(aName, aEmailAddress, when, SystemReader.getInstance().getTimeZoneAt(when));
    }

    private PersonIdent(UserConfig config) {
        this(config.getCommitterName(), config.getCommitterEmail());
    }

    @Deprecated(since="7.1")
    public PersonIdent(String aName, String aEmailAddress, long aWhen, int aTZ) {
        this(aName, aEmailAddress, Instant.ofEpochMilli(aWhen), PersonIdent.getZoneId(aTZ));
    }

    public String getName() {
        return this.name;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    @Deprecated(since="7.1")
    public Date getWhen() {
        return Date.from(this.when);
    }

    public Instant getWhenAsInstant() {
        return this.when;
    }

    @Deprecated(since="7.1")
    public TimeZone getTimeZone() {
        return TimeZone.getTimeZone(this.tzOffset);
    }

    public ZoneId getZoneId() {
        return this.tzOffset;
    }

    public ZoneOffset getZoneOffset() {
        return this.tzOffset.getRules().getOffset(this.when);
    }

    @Deprecated(since="7.1")
    public int getTimeZoneOffset() {
        return this.getZoneOffset().getTotalSeconds() / 60;
    }

    public int hashCode() {
        int hc = this.getEmailAddress().hashCode();
        hc *= 31;
        return hc += this.when.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof PersonIdent) {
            PersonIdent p = (PersonIdent)o;
            return this.getName().equals(p.getName()) && this.getEmailAddress().equals(p.getEmailAddress()) && this.when.truncatedTo(ChronoUnit.SECONDS).equals(p.when.truncatedTo(ChronoUnit.SECONDS));
        }
        return false;
    }

    public String toExternalString() {
        StringBuilder r = new StringBuilder();
        PersonIdent.appendSanitized(r, this.getName());
        r.append(" <");
        PersonIdent.appendSanitized(r, this.getEmailAddress());
        r.append("> ");
        r.append(this.when.toEpochMilli() / 1000L);
        r.append(' ');
        r.append(OFFSET_FORMATTER.format(this.getZoneOffset()));
        return r.toString();
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        DateTimeFormatter dtfmt = DateTimeFormatter.ofPattern("EEE MMM d HH:mm:ss yyyy Z", Locale.US).withZone(this.tzOffset);
        r.append("PersonIdent[");
        r.append(this.getName());
        r.append(", ");
        r.append(this.getEmailAddress());
        r.append(", ");
        r.append(dtfmt.format(this.when));
        r.append("]");
        return r.toString();
    }
}

