/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.producer;

import java.util.Map;
import org.eclipse.egf.common.activator.EGFAbstractPlugin;
import org.eclipse.egf.common.helper.EMFHelper;
import org.eclipse.egf.core.producer.MissingExtensionException;
import org.eclipse.egf.model.fcore.Activity;
import org.eclipse.egf.model.fcore.Orchestration;
import org.eclipse.egf.producer.context.ActivityProductionContextProducer;
import org.eclipse.egf.producer.internal.registry.ProducerRegistry;
import org.eclipse.egf.producer.l10n.ProducerMessages;
import org.eclipse.egf.producer.manager.ActivityManagerProducer;
import org.eclipse.egf.producer.manager.OrchestrationManagerProducer;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EGFProducerPlugin
extends EGFAbstractPlugin {
    private static EGFProducerPlugin __plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        __plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        __plugin = null;
        super.stop(context);
    }

    public static EGFProducerPlugin getDefault() {
        return __plugin;
    }

    public static <P extends Activity> ActivityManagerProducer<P> getActivityManagerProducer(P activity) throws MissingExtensionException {
        Map<EClass, ActivityManagerProducer<?>> producers = ProducerRegistry.getActivityManagerProducers();
        ActivityManagerProducer<?> producer = producers.get(EMFHelper.solveAgainstStaticPackage((EClassifier)activity.eClass()));
        if (producer == null) {
            throw new MissingExtensionException(NLS.bind((String)ProducerMessages.ActivityManagerProducer_extension_error, (Object)ProducerRegistry.getName(activity)));
        }
        return producer;
    }

    public static <P extends Activity> ActivityProductionContextProducer<P> getActivityProductionContextProducer(P activity) throws MissingExtensionException {
        Map<EClass, ActivityProductionContextProducer<?>> producers = ProducerRegistry.getActivityProductionContextProducers();
        ActivityProductionContextProducer<?> producer = producers.get(EMFHelper.solveAgainstStaticPackage((EClassifier)activity.eClass()));
        if (producer == null) {
            throw new MissingExtensionException(NLS.bind((String)ProducerMessages.ActivityProductionContextProducer_extension_error, (Object)ProducerRegistry.getName(activity)));
        }
        return producer;
    }

    public static <P extends Orchestration> OrchestrationManagerProducer<P> getOrchestrationProducer(P orchestration) throws MissingExtensionException {
        Map<EClass, OrchestrationManagerProducer<?>> producers = ProducerRegistry.getOrchestrationManagerProducers();
        OrchestrationManagerProducer<?> producer = producers.get(EMFHelper.solveAgainstStaticPackage((EClassifier)orchestration.eClass()));
        if (producer == null) {
            throw new MissingExtensionException(NLS.bind((String)ProducerMessages.OrchestrationManagerProducer_extension_error, (Object)ProducerRegistry.getName(orchestration)));
        }
        return producer;
    }
}

