/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.fcore.helper;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.egf.model.fcore.ContractMode;
import org.eclipse.egf.model.fcore.InvocationContract;
import org.eclipse.egf.model.fcore.OrchestrationParameter;
import org.eclipse.emf.common.util.UniqueEList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrchestrationParameterHelper {
    private OrchestrationParameterHelper() {
    }

    public static Collection<InvocationContract> getAvailableInvocationContracts(OrchestrationParameter orchestrationParameter) {
        UniqueEList result = new UniqueEList();
        if (orchestrationParameter.getType() != null) {
            result.addAll(orchestrationParameter.getOrchestration().getInvocationContracts(orchestrationParameter.getType()));
            if (result.size() > 0) {
                Iterator it = result.iterator();
                while (it.hasNext()) {
                    InvocationContract invocationContract = (InvocationContract)it.next();
                    if (invocationContract.getInvokedMode() == ContractMode.OUT) {
                        it.remove();
                        continue;
                    }
                    if (invocationContract.getFactoryComponentContract() != null) {
                        if (invocationContract.getInvokedMode() == ContractMode.IN) {
                            it.remove();
                        } else if (invocationContract.getFactoryComponentContract().getMode() != ContractMode.OUT) {
                            it.remove();
                        }
                    }
                    if (invocationContract.getSourceInvocationContract() == null || invocationContract.getInvokedMode() != ContractMode.IN) continue;
                    it.remove();
                }
                for (OrchestrationParameter innerOrchestrationParameter : orchestrationParameter.getOrchestrationParameterContainer().getOrchestrationParameters()) {
                    if (orchestrationParameter == innerOrchestrationParameter) continue;
                    for (InvocationContract invocationContract : innerOrchestrationParameter.getInvocationContracts()) {
                        result.remove(invocationContract);
                    }
                }
            }
        }
        return result;
    }
}

