/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.jdt.ui.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.NamingConventions;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposalComputer;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class FXBeanJavaCompletionProposalComputer
implements IJavaCompletionProposalComputer {
    public List<ICompletionProposal> computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        if (context instanceof JavaContentAssistInvocationContext && Boolean.FALSE.booleanValue()) {
            JavaContentAssistInvocationContext javaContext = (JavaContentAssistInvocationContext)context;
            CompletionContext completionContext = javaContext.getCoreContext();
            IJavaElement enclosingElement = null;
            if (completionContext.isExtended()) {
                enclosingElement = completionContext.getEnclosingElement();
            } else {
                try {
                    enclosingElement = javaContext.getCompilationUnit().getElementAt(context.getInvocationOffset() + 1);
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
            }
            ArrayList<ICompletionProposal> l = new ArrayList<ICompletionProposal>();
            if (enclosingElement != null) {
                IType type = (IType)enclosingElement.getAncestor(7);
                if (type == null) {
                    return l;
                }
                try {
                    IField[] fields = type.getFields();
                    IMethod[] methods = type.getMethods();
                    int offset = context.getInvocationOffset() - 3;
                    if (offset > 0) {
                        String prefix = context.getDocument().get(offset, 3);
                        IType propType = type.getJavaProject().findType("javafx.beans.property.Property");
                        IType writableType = type.getJavaProject().findType("javafx.beans.value.WritableValue");
                        IType booleanType = type.getJavaProject().findType("javafx.beans.property.ReadOnlyBooleanProperty");
                        IType doubleType = type.getJavaProject().findType("javafx.beans.property.ReadOnlyDoubleProperty");
                        IType floatType = type.getJavaProject().findType("javafx.beans.property.ReadOnlyFloatProperty");
                        IType intType = type.getJavaProject().findType("javafx.beans.property.ReadOnlyIntegerProperty");
                        IType longType = type.getJavaProject().findType("javafx.beans.property.ReadOnlyLongProperty");
                        IType stringType = type.getJavaProject().findType("javafx.beans.property.ReadOnlyStringProperty");
                        int i = 0;
                        while (i < fields.length) {
                            IType fieldType;
                            IField curr = fields[i];
                            if (!Flags.isEnum((int)curr.getFlags()) && (fieldType = this.toType(type, curr.getTypeSignature())) != null && FXBeanJavaCompletionProposalComputer.assignable(fieldType, propType)) {
                                String propertyName;
                                String getterName;
                                StyledString s;
                                if ("set".equals(prefix)) {
                                    String setterName;
                                    if (FXBeanJavaCompletionProposalComputer.assignable(fieldType, writableType) && !FXBeanJavaCompletionProposalComputer.hasMethod(methods, setterName = NamingConventions.suggestSetterName((IJavaProject)type.getJavaProject(), (String)curr.getElementName(), (int)curr.getFlags(), (boolean)false, null))) {
                                        s = new StyledString(String.valueOf(setterName) + "(" + FXBeanJavaCompletionProposalComputer.toValue(fieldType, booleanType, doubleType, floatType, intType, longType, stringType) + ")" + " : void");
                                        s.append(" - Setter for '" + curr.getElementName() + "'", StyledString.QUALIFIER_STYLER);
                                        l.add(new CompletionProposalImpl(setterName, s, String.valueOf(setterName) + "(" + FXBeanJavaCompletionProposalComputer.toValue(fieldType, booleanType, doubleType, floatType, intType, longType, stringType) + " " + curr.getElementName() + ")", curr, Type.SETTER, offset));
                                    }
                                } else if (Character.isWhitespace(prefix.charAt(0)) && prefix.endsWith("is")) {
                                    if (FXBeanJavaCompletionProposalComputer.assignable(fieldType, booleanType)) {
                                        getterName = NamingConventions.suggestGetterName((IJavaProject)type.getJavaProject(), (String)curr.getElementName(), (int)curr.getFlags(), (boolean)false, null);
                                        if (!FXBeanJavaCompletionProposalComputer.hasMethod(methods, getterName = "is" + getterName.substring(3))) {
                                            s = new StyledString(String.valueOf(getterName) + "() : boolean");
                                            s.append(" - Getter for '" + curr.getElementName() + "'", StyledString.QUALIFIER_STYLER);
                                            l.add(new CompletionProposalImpl(getterName, s, String.valueOf(getterName) + "()", curr, Type.GETTER, offset));
                                        }
                                    }
                                } else if ("get".equals(prefix)) {
                                    if (!FXBeanJavaCompletionProposalComputer.assignable(fieldType, booleanType) && !FXBeanJavaCompletionProposalComputer.hasMethod(methods, getterName = NamingConventions.suggestGetterName((IJavaProject)type.getJavaProject(), (String)curr.getElementName(), (int)curr.getFlags(), (boolean)false, null))) {
                                        s = new StyledString(String.valueOf(getterName) + "() : " + FXBeanJavaCompletionProposalComputer.toValue(fieldType, booleanType, doubleType, floatType, intType, longType, stringType));
                                        s.append(" - Getter for '" + curr.getElementName() + "'", StyledString.QUALIFIER_STYLER);
                                        l.add(new CompletionProposalImpl(getterName, s, String.valueOf(FXBeanJavaCompletionProposalComputer.toValue(fieldType, booleanType, doubleType, floatType, intType, longType, stringType)) + " " + getterName + "()", curr, Type.GETTER, offset));
                                    }
                                } else if (Character.isWhitespace(prefix.charAt(2)) && !FXBeanJavaCompletionProposalComputer.hasMethod(methods, propertyName = String.valueOf(curr.getElementName()) + "Property() : " + fieldType.getElementName())) {
                                    s = new StyledString(propertyName);
                                    l.add(new CompletionProposalImpl(propertyName, s, String.valueOf(fieldType.getElementName()) + " " + curr.getElementName() + "Property()", curr, Type.ACCESSOR, offset));
                                }
                            }
                            ++i;
                        }
                    }
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
            return l;
        }
        return Collections.emptyList();
    }

    private static String toValue(IType fieldType, IType booleanType, IType doubleType, IType floatType, IType intType, IType longType, IType stringType) {
        if (FXBeanJavaCompletionProposalComputer.assignable(fieldType, booleanType)) {
            return "boolean";
        }
        if (FXBeanJavaCompletionProposalComputer.assignable(fieldType, doubleType)) {
            return "double";
        }
        if (FXBeanJavaCompletionProposalComputer.assignable(fieldType, floatType)) {
            return "float";
        }
        if (FXBeanJavaCompletionProposalComputer.assignable(fieldType, intType)) {
            return "int";
        }
        if (FXBeanJavaCompletionProposalComputer.assignable(fieldType, longType)) {
            return "long";
        }
        if (FXBeanJavaCompletionProposalComputer.assignable(fieldType, stringType)) {
            return "String";
        }
        return null;
    }

    private IType toType(IType t, String typeSig) throws JavaModelException {
        String erasedType = Signature.getTypeErasure((String)Signature.toString((String)typeSig));
        String[][] types = t.resolveType(erasedType);
        if (types != null && types.length == 1) {
            StringBuilder b = new StringBuilder();
            String[] stringArray = types[0];
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String p = stringArray[n2];
                if (b.length() > 0) {
                    b.append(".");
                }
                b.append(p);
                ++n2;
            }
            return t.getJavaProject().findType(b.toString());
        }
        return null;
    }

    private static boolean hasMethod(IMethod[] methods, String name) {
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getElementName().equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean assignable(IType fromType, IType toType) {
        if (fromType.equals(toType)) {
            return true;
        }
        try {
            return fromType.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor()).contains(toType);
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void sessionStarted() {
    }

    public List<IContextInformation> computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        return Collections.emptyList();
    }

    public String getErrorMessage() {
        return null;
    }

    public void sessionEnded() {
    }

    static class CompletionProposalImpl
    implements ICompletionProposal,
    ICompletionProposalExtension6 {
        private final String label;
        private final StyledString styledString;
        private final IField field;
        private final Type type;
        private final int offset;
        private final String method;

        public CompletionProposalImpl(String label, StyledString styledString, String method, IField field, Type type, int offset) {
            this.label = label;
            this.styledString = styledString;
            this.field = field;
            this.type = type;
            this.offset = offset;
            this.method = method;
        }

        public void apply(IDocument document) {
            switch (this.type) {
                case SETTER: {
                    StringBuilder b = new StringBuilder("public void " + this.method);
                    b.append(" {\n");
                    b.append("\t\tthis." + this.field.getElementName() + ".set(" + this.field.getElementName() + ");\n");
                    b.append("\t}");
                    try {
                        document.replace(this.offset, 3, b.toString());
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case GETTER: {
                    StringBuilder b = new StringBuilder("public " + this.method);
                    b.append(" {\n");
                    b.append("\t\treturn this." + this.field.getElementName() + ".get();\n");
                    b.append("\t}");
                    try {
                        document.replace(this.offset, 3, b.toString());
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                default: {
                    StringBuilder b = new StringBuilder("public " + this.method);
                    b.append(" {\n");
                    b.append("\t\treturn this." + this.field.getElementName() + ";\n");
                    b.append("\t}");
                    try {
                        document.replace(this.offset + 3, 0, b.toString());
                        break;
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        public Point getSelection(IDocument document) {
            return null;
        }

        public String getAdditionalProposalInfo() {
            return null;
        }

        public String getDisplayString() {
            return this.styledString.getString();
        }

        public Image getImage() {
            return JavaPluginImages.get((String)"org.eclipse.jdt.ui.methpub_obj.gif");
        }

        public IContextInformation getContextInformation() {
            return null;
        }

        public StyledString getStyledDisplayString() {
            return this.styledString;
        }
    }

    public static enum Type {
        GETTER,
        SETTER,
        ACCESSOR;

    }
}

