/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.ui.wizards;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.fx.ide.ui.wizards.template.HtmlElement;
import org.eclipse.fx.ide.ui.wizards.template.JDTElement;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.jdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.jdt.ui.JavaElementComparator;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.databinding.swt.IWidgetValueProperty;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public abstract class AbstractHtmlElementPage<O extends HtmlElement>
extends WizardPage {
    private O clazz;
    private IPackageFragmentRoot froot;
    private IPackageFragment fragment;
    private IWorkspaceRoot fWorkspaceRoot;
    private Text nameField;

    protected AbstractHtmlElementPage(String pageName, String title, String description, IPackageFragmentRoot froot, IPackageFragment fragment, IWorkspaceRoot fWorkspaceRoot) {
        super(pageName);
        this.froot = froot;
        this.fragment = fragment;
        this.fWorkspaceRoot = fWorkspaceRoot;
        this.setTitle(title);
        this.setDescription(description);
        this.setImageDescriptor(this.getTitleAreaImage(Display.getCurrent()));
    }

    public void createControl(Composite parent) {
        parent = new Composite(parent, 0);
        parent.setLayoutData((Object)new GridData(1808));
        parent.setLayout((Layout)new GridLayout(3, false));
        this.clazz = this.createInstance();
        ((JDTElement)this.clazz).setFragmentRoot(this.froot);
        ((JDTElement)this.clazz).setPackageFragment(this.fragment);
        DataBindingContext dbc = new DataBindingContext();
        Label l = new Label(parent, 0);
        l.setText("Source folder");
        Text t = new Text(parent, 2048);
        t.setLayoutData((Object)new GridData(768));
        t.setEditable(false);
        final Binding bd = dbc.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)t), BeanProperties.value((String)"fragmentRoot").observe(this.clazz), new UpdateValueStrategy(), new UpdateValueStrategy().setConverter((IConverter)new PackageFragmentRootToStringConverter()));
        Button b = new Button(parent, 8);
        b.setText("Browse ...");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPackageFragmentRoot root = AbstractHtmlElementPage.this.choosePackageRoot();
                if (root != null) {
                    AbstractHtmlElementPage.this.froot = root;
                    AbstractHtmlElementPage.this.clazz.setFragmentRoot(root);
                }
                bd.updateModelToTarget();
            }
        });
        l = new Label(parent, 0);
        l.setText("Package");
        t = new Text(parent, 2048);
        t.setEditable(false);
        t.setLayoutData((Object)new GridData(768));
        bd = dbc.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)t), BeanProperties.value((String)"packageFragment").observe(this.clazz), new UpdateValueStrategy(), new UpdateValueStrategy().setConverter((IConverter)new PackageFragmentToStringConverter()));
        b = new Button(parent, 8);
        b.setText("Browse ...");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPackageFragment fragment = AbstractHtmlElementPage.this.choosePackage();
                if (fragment != null) {
                    AbstractHtmlElementPage.this.clazz.setPackageFragment(fragment);
                }
                bd.updateModelToTarget();
            }
        });
        IWidgetValueProperty textProp = WidgetProperties.text((int)24);
        Label l2 = new Label(parent, 0);
        l2.setText("Name");
        this.nameField = new Text(parent, 2048);
        this.nameField.setLayoutData((Object)new GridData(768));
        dbc.bindValue((IObservableValue)textProp.observe((Widget)this.nameField), BeanProperties.value((String)"name", String.class).observe(this.clazz));
        new Label(parent, 0);
        l = new Label(parent, 258);
        l.setLayoutData((Object)new GridData(4, 2, false, false, 3, 1));
        this.createFields(parent, dbc);
        this.setControl((Control)parent);
        ((JDTElement)this.clazz).addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AbstractHtmlElementPage.this.revalidate();
            }
        });
        this.setPageComplete(false);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.nameField.setFocus();
        }
    }

    protected void revalidate() {
        if (((JDTElement)this.getClazz()).getName() == null || ((JDTElement)this.getClazz()).getName().trim().length() == 0) {
            this.setPageComplete(false);
            this.setMessage("Enter a name", 3);
        } else {
            this.setPageComplete(true);
            this.setMessage(null);
        }
    }

    private IPackageFragmentRoot choosePackageRoot() {
        IPackageFragmentRoot initElement = ((JDTElement)this.clazz).getFragmentRoot();
        Class[] acceptedClasses = new Class[]{IPackageFragmentRoot.class, IJavaProject.class};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, false){

            public boolean isSelectedValid(Object element) {
                try {
                    if (element instanceof IJavaProject) {
                        IJavaProject jproject = (IJavaProject)element;
                        IPath path = jproject.getProject().getFullPath();
                        return jproject.findPackageFragmentRoot(path) != null;
                    }
                    if (element instanceof IPackageFragmentRoot) {
                        return ((IPackageFragmentRoot)element).getKind() == 1;
                    }
                    return true;
                }
                catch (JavaModelException e) {
                    JavaPlugin.log((IStatus)e.getStatus());
                    return false;
                }
            }
        };
        acceptedClasses = new Class[]{IJavaModel.class, IPackageFragmentRoot.class, IJavaProject.class};
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses){

            public boolean select(Viewer viewer, Object parent, Object element) {
                if (element instanceof IPackageFragmentRoot) {
                    try {
                        return ((IPackageFragmentRoot)element).getKind() == 1;
                    }
                    catch (JavaModelException e) {
                        JavaPlugin.log((IStatus)e.getStatus());
                        return false;
                    }
                }
                return super.select(viewer, parent, element);
            }
        };
        StandardJavaElementContentProvider provider = new StandardJavaElementContentProvider();
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(18);
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)provider);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setComparator((ViewerComparator)new JavaElementComparator());
        dialog.setTitle(NewWizardMessages.NewContainerWizardPage_ChooseSourceContainerDialog_title);
        dialog.setMessage(NewWizardMessages.NewContainerWizardPage_ChooseSourceContainerDialog_description);
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)JavaCore.create((IWorkspaceRoot)this.fWorkspaceRoot));
        dialog.setInitialSelection((Object)initElement);
        dialog.setHelpAvailable(false);
        if (dialog.open() == 0) {
            Object element = dialog.getFirstResult();
            if (element instanceof IJavaProject) {
                IJavaProject jproject = (IJavaProject)element;
                return jproject.getPackageFragmentRoot((IResource)jproject.getProject());
            }
            if (element instanceof IPackageFragmentRoot) {
                return (IPackageFragmentRoot)element;
            }
            return null;
        }
        return null;
    }

    private IPackageFragment choosePackage() {
        Object[] packages = null;
        try {
            if (this.froot != null && this.froot.exists()) {
                packages = this.froot.getChildren();
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        if (packages == null) {
            packages = new IJavaElement[]{};
        }
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new JavaElementLabelProvider(18));
        dialog.setIgnoreCase(false);
        dialog.setTitle("Choose Package");
        dialog.setMessage("Choose a Package");
        dialog.setEmptyListMessage("You need to select a package");
        dialog.setElements(packages);
        dialog.setHelpAvailable(false);
        IPackageFragment pack = ((JDTElement)this.clazz).getPackageFragment();
        if (pack != null) {
            dialog.setInitialSelections(new Object[]{pack});
        }
        if (dialog.open() == 0) {
            return (IPackageFragment)dialog.getFirstResult();
        }
        return null;
    }

    protected IPackageFragmentRoot getFragmentRoot() {
        return this.froot;
    }

    protected abstract void createFields(Composite var1, DataBindingContext var2);

    protected abstract O createInstance();

    protected abstract ImageDescriptor getTitleAreaImage(Display var1);

    public O getClazz() {
        return this.clazz;
    }

    static class ClassnameValidator
    implements IValidator {
        ClassnameValidator() {
        }

        public IStatus validate(Object value) {
            char[] ar;
            String name = value.toString();
            char[] cArray = ar = name.toCharArray();
            int n = ar.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (!Character.isJavaIdentifierPart(c)) {
                    return new Status(4, "", "'" + c + "' is not allowed in a Class-Name");
                }
                ++n2;
            }
            if (!Character.isJavaIdentifierStart(ar[0])) {
                return new Status(4, "", "'" + ar[0] + "' is not allowed as the first character of a Class-Name");
            }
            return Status.OK_STATUS;
        }
    }

    static class PackageFragmentRootToStringConverter
    extends Converter {
        public PackageFragmentRootToStringConverter() {
            super(IPackageFragmentRoot.class, String.class);
        }

        public Object convert(Object fromObject) {
            IPackageFragmentRoot f = (IPackageFragmentRoot)fromObject;
            if (f == null) {
                return "";
            }
            return f.getPath().makeRelative().toString();
        }
    }

    static class PackageFragmentToStringConverter
    extends Converter {
        public PackageFragmentToStringConverter() {
            super(IPackageFragment.class, String.class);
        }

        public Object convert(Object fromObject) {
            if (fromObject == null) {
                return "";
            }
            IPackageFragment f = (IPackageFragment)fromObject;
            return f.getElementName();
        }
    }
}

