/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.text;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.BreakIterator;
import java.text.CharacterIterator;
import java.text.MessageFormat;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.text.StrLookup;
import org.apache.commons.lang.text.StrSubstitutor;
import org.eclipse.fx.core.IntTuple;
import org.eclipse.fx.core.Triple;
import org.eclipse.fx.core.function.BiIntPredicate;
import org.eclipse.fx.core.function.BiIntUnaryOperator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class TextUtil {
    private static String[] BASIC_STRING_CACHE = new String[256];

    public static int findWordEndOffset(IterableCharSequence content, int offset, boolean pointAsBoundary) {
        BreakIterator wordInstance = BreakIterator.getWordInstance();
        wordInstance.setText(content.getIterator());
        int rv = wordInstance.following(offset);
        if (rv != -1 && pointAsBoundary) {
            String s = content.subSequence(offset, rv).toString();
            int idx = s.indexOf(46);
            if (idx >= 0) {
                rv = offset + idx;
            }
            if (rv == offset) {
                rv = offset + 1;
            }
        }
        return rv;
    }

    public static int findWordStartOffset(IterableCharSequence content, int offset, boolean pointAsBoundary) {
        BreakIterator wordInstance = BreakIterator.getWordInstance();
        wordInstance.setText(content.getIterator());
        int rv = wordInstance.preceding(offset);
        if (rv != -1 && pointAsBoundary) {
            String s = content.subSequence(rv, offset).toString();
            int idx = s.lastIndexOf(46);
            if (idx > 0) {
                rv += idx + 1;
            }
            if (rv == offset) {
                --rv;
            }
        }
        return rv;
    }

    public static IntTuple findWordBounds(IterableCharSequence content, int offset, boolean pointAsBoundary) {
        BreakIterator wordInstance = BreakIterator.getWordInstance();
        wordInstance.setText(content.getIterator());
        int previous = wordInstance.preceding(offset);
        int next = wordInstance.following(offset);
        if (pointAsBoundary && previous != -1 && next != -1) {
            String preMatch = content.subSequence(previous, offset).toString();
            String postMatch = content.subSequence(offset, next).toString();
            int idx = preMatch.lastIndexOf(46);
            if (idx > 0) {
                previous += idx + 1;
            }
            if ((idx = postMatch.indexOf(46)) > 0) {
                next = offset + idx;
            }
        }
        return new IntTuple(previous, next);
    }

    public static String templateValuSubstitutor(String template, Map<String, Object> data) {
        return new StrSubstitutor((StrLookup)new StrLookupImpl(data)).replace(template);
    }

    public static String toFirstUpper(String value) {
        char[] cs = value.toCharArray();
        cs[0] = Character.toUpperCase(cs[0]);
        return String.valueOf(cs);
    }

    public static void foreachCharPosition(String content, char c, IntConsumer consumer) {
        char[] cs = content.toCharArray();
        int i = 0;
        while (i < cs.length) {
            if (cs[i] == c) {
                consumer.accept(i);
            }
            ++i;
        }
    }

    public static <R> Stream<R> foreachCharPosition(String content, char c, IntFunction<R> consumer) {
        ArrayList<R> list = new ArrayList<R>();
        char[] cs = content.toCharArray();
        int i = 0;
        while (i < cs.length) {
            if (cs[i] == c) {
                list.add(consumer.apply(i));
            }
            ++i;
        }
        return list.stream();
    }

    public static String stripOff(String content, IntPredicate filter) {
        char[] cs = content.toCharArray();
        char[] target = new char[cs.length];
        int j = 0;
        int i = 0;
        while (i < cs.length) {
            if (!filter.test(cs[i])) {
                target[j++] = cs[i];
            }
            ++i;
        }
        if (j < cs.length) {
            return new String(target, 0, j);
        }
        return content;
    }

    public static @NonNull String notNull(@Nullable String value, @NonNull String defaultValue) {
        return value == null ? defaultValue : value;
    }

    public static String createRepeatedString(char c, int length) {
        char[] vals = new char[length];
        Arrays.fill(vals, c);
        return String.valueOf(vals);
    }

    public static Triple<char[], int[], int[]> replaceTabBySpace(char[] source, int tabAdvance) {
        if (tabAdvance <= 0) {
            throw new IllegalArgumentException("tabAdvance must be greater 0");
        }
        int tabCount = 0;
        int i = 0;
        while (i < source.length) {
            if (source[i] == '\t') {
                ++tabCount;
            }
            ++i;
        }
        if (tabCount == 0) {
            char[] rv = new char[source.length];
            System.arraycopy(source, 0, rv, 0, rv.length);
            return new Triple<char[], int[], int[]>(rv, new int[0], new int[0]);
        }
        int[] tabPositions = new int[tabCount];
        int[] newTabPositions = new int[tabCount];
        char[] rv = new char[source.length + tabCount * (tabAdvance - 1)];
        int count = 0;
        int tabIdx = 0;
        int i2 = 0;
        while (i2 < source.length) {
            if (source[i2] == '\t') {
                tabPositions[tabIdx] = i2;
                newTabPositions[tabIdx] = count;
                ++tabIdx;
                int j = 0;
                while (j < tabAdvance) {
                    rv[count++] = 32;
                    ++j;
                }
            } else {
                rv[count++] = source[i2];
            }
            ++i2;
        }
        return new Triple<char[], int[], int[]>(rv, tabPositions, newTabPositions);
    }

    public static char[] replaceAll(char[] source, char c, char[] newChar) {
        StringBuilder b = new StringBuilder(source.length);
        int i = 0;
        while (i < source.length) {
            if (source[i] == c) {
                b.append(newChar);
            } else {
                b.append(source[i]);
            }
            ++i;
        }
        char[] rv = new char[b.length()];
        b.getChars(0, b.length(), rv, 0);
        return rv;
    }

    public static char[] transform(char[] source, BiIntUnaryOperator transformer) {
        char[] rv = new char[source.length];
        int i = 0;
        while (i < source.length) {
            rv[i] = (char)transformer.applyAsInt(i, source[i]);
            ++i;
        }
        return rv;
    }

    public static char[] replace(char[] source, char c, BiIntPredicate predicate) {
        char[] rv = new char[source.length];
        int i = 0;
        while (i < source.length) {
            rv[i] = predicate.test(i, source[i]) ? c : source[i];
            ++i;
        }
        return rv;
    }

    public static String toString(char c) {
        String rv = null;
        if (c < BASIC_STRING_CACHE.length && (rv = BASIC_STRING_CACHE[c]) == null) {
            TextUtil.BASIC_STRING_CACHE[c] = String.valueOf(c);
        }
        if (rv == null) {
            rv = String.valueOf(c);
        }
        return rv;
    }

    public static interface IterableCharSequence
    extends CharSequence {
        default public CharacterIterator getIterator() {
            return new StringCharacterIterator(this.subSequence(0, this.length()).toString());
        }
    }

    static class StrLookupImpl
    extends StrLookup {
        private final Map<String, Object> data;

        public StrLookupImpl(Map<String, Object> data) {
            this.data = data;
        }

        public String lookup(String key) {
            String[] pathAndFormat = key.split(",");
            String[] path = pathAndFormat[0].split("\\.");
            Object object = this.data.get(path[0]);
            if (object != null && path.length > 1) {
                int i = 1;
                while (object != null && i < path.length) {
                    Method m = null;
                    try {
                        m = object.getClass().getDeclaredMethod("get" + TextUtil.toFirstUpper(path[i]), new Class[0]);
                    }
                    catch (NoSuchMethodException | SecurityException e) {
                        try {
                            m = object.getClass().getDeclaredMethod("is" + TextUtil.toFirstUpper(path[i]), new Class[0]);
                        }
                        catch (NoSuchMethodException | SecurityException exception) {
                            // empty catch block
                        }
                    }
                    if (m == null) {
                        throw new IllegalStateException("Unable to locate accessor property for property '" + path[i] + "' on object " + object + ".");
                    }
                    m.setAccessible(true);
                    try {
                        object = m.invoke(object, new Object[0]);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                        throw new IllegalStateException(e);
                    }
                    ++i;
                }
            }
            if (pathAndFormat.length > 1) {
                String msg = "{0," + Stream.of(pathAndFormat).skip(1L).collect(Collectors.joining(",")) + "}";
                return MessageFormat.format(msg, object);
            }
            return object == null ? null : object.toString();
        }
    }
}

