/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.project.registry;

import java.io.File;
import java.util.Collection;
import org.apache.maven.execution.MavenExecutionRequest;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.embedder.ICallable;
import org.eclipse.m2e.core.embedder.IMavenExecutionContext;
import org.eclipse.m2e.core.internal.embedder.MavenExecutionContext;
import org.eclipse.m2e.core.internal.project.registry.ProjectRegistryManager;
import org.eclipse.m2e.core.internal.project.registry.ProjectRegistryRefreshJob;
import org.eclipse.m2e.core.project.IMavenProjectChangedListener;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.project.MavenUpdateRequest;
import org.eclipse.m2e.core.project.ResolverConfiguration;

public class MavenProjectManager
implements IMavenProjectRegistry {
    public static final String STATE_FILENAME = "workspacestate.properties";
    private final ProjectRegistryManager manager;
    private final ProjectRegistryRefreshJob mavenBackgroundJob;
    private final File workspaceStateFile;

    public MavenProjectManager(ProjectRegistryManager manager, ProjectRegistryRefreshJob mavenBackgroundJob, File stateLocation) {
        this.manager = manager;
        this.mavenBackgroundJob = mavenBackgroundJob;
        this.workspaceStateFile = new File(stateLocation, STATE_FILENAME);
    }

    @Override
    public void refresh(MavenUpdateRequest request) {
        this.mavenBackgroundJob.refresh(request);
    }

    @Override
    @Deprecated
    public void refresh(MavenUpdateRequest request, IProgressMonitor monitor) throws CoreException {
        this.manager.refresh(request, monitor);
    }

    @Override
    public void refresh(Collection<IFile> pomFiles, IProgressMonitor monitor) throws CoreException {
        this.manager.refresh(pomFiles, monitor);
    }

    @Override
    public void addMavenProjectChangedListener(IMavenProjectChangedListener listener) {
        this.manager.addMavenProjectChangedListener(listener);
    }

    @Override
    public void removeMavenProjectChangedListener(IMavenProjectChangedListener listener) {
        this.manager.removeMavenProjectChangedListener(listener);
    }

    @Override
    public IMavenProjectFacade create(IFile pom, boolean load, IProgressMonitor monitor) {
        return this.manager.create(pom, load, monitor);
    }

    @Override
    public IMavenProjectFacade create(IProject project, IProgressMonitor monitor) {
        return this.manager.create(project, monitor);
    }

    @Override
    public IMavenProjectFacade[] getProjects() {
        return this.manager.getProjects();
    }

    @Override
    public IMavenProjectFacade getProject(IProject project) {
        return this.manager.getProject(project);
    }

    @Override
    public IMavenProjectFacade getMavenProject(String groupId, String artifactId, String version) {
        return this.manager.getMavenProject(groupId, artifactId, version);
    }

    public File getWorkspaceStateFile() {
        return this.workspaceStateFile;
    }

    @Override
    @Deprecated
    public MavenExecutionRequest createExecutionRequest(IFile pom, ResolverConfiguration resolverConfiguration, IProgressMonitor monitor) throws CoreException {
        return this.manager.createExecutionRequest(pom, resolverConfiguration, monitor);
    }

    @Override
    @Deprecated
    public MavenExecutionRequest createExecutionRequest(IMavenProjectFacade project, IProgressMonitor monitor) throws CoreException {
        return this.createExecutionRequest(project.getPom(), project.getResolverConfiguration(), monitor);
    }

    @Override
    public <V> V execute(final IMavenProjectFacade facade, final ICallable<V> callable, IProgressMonitor monitor) throws CoreException {
        MavenExecutionContext context = this.manager.createExecutionContext(facade.getPom(), facade.getResolverConfiguration());
        return context.execute(new ICallable<V>(){

            @Override
            public V call(IMavenExecutionContext context, IProgressMonitor monitor) throws CoreException {
                return context.execute(facade.getMavenProject(monitor), callable, monitor);
            }
        }, monitor);
    }
}

