/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j;

import java.io.PrintWriter;
import org.sat4j.ExitCode;
import org.sat4j.core.Vec;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ILogAble;
import org.sat4j.specs.IOptimizationProblem;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.Backbone;
import org.sat4j.tools.LexicoDecorator;
import org.sat4j.tools.SolutionFoundListener;

public interface ILauncherMode
extends SolutionFoundListener {
    public static final String SOLUTION_PREFIX = "v ";
    public static final String ANSWER_PREFIX = "s ";
    public static final String CURRENT_OPTIMUM_VALUE_PREFIX = "o ";
    public static final ILauncherMode DECISION = new ILauncherMode(){
        private ExitCode exitCode = ExitCode.UNKNOWN;
        private int nbSolutionFound;
        private PrintWriter out;
        private long beginTime;

        public void displayResult(ISolver solver, IProblem problem, ILogAble logger, PrintWriter out, Reader reader, long beginTime, boolean displaySolutionLine) {
            if (solver != null) {
                out.flush();
                double wallclocktime = (double)(System.currentTimeMillis() - beginTime) / 1000.0;
                solver.printStat(out);
                solver.printInfos(out);
                out.println(ILauncherMode.ANSWER_PREFIX + this.exitCode);
                if (this.exitCode != ExitCode.UNKNOWN && this.exitCode != ExitCode.UNSATISFIABLE) {
                    long endpi;
                    int[] model = solver.model();
                    if (System.getProperty("prime") != null) {
                        int initiallength = model.length;
                        logger.log("returning a prime implicant ...");
                        long beginpi = System.currentTimeMillis();
                        model = solver.primeImplicant();
                        endpi = System.currentTimeMillis();
                        logger.log("removed " + (initiallength - model.length) + " literals");
                        logger.log("pi computation time: " + (endpi - beginpi) + " ms");
                    }
                    if (System.getProperty("backbone") != null) {
                        logger.log("computing the backbone of the formula ...");
                        long beginpi = System.currentTimeMillis();
                        model = solver.primeImplicant();
                        try {
                            IVecInt backbone = Backbone.compute(solver, model);
                            endpi = System.currentTimeMillis();
                            out.print(solver.getLogPrefix());
                            reader.decode(backbone.toArray(), out);
                            out.println();
                            logger.log("backbone computation time: " + (endpi - beginpi) + " ms");
                        }
                        catch (TimeoutException timeoutException) {
                            logger.log("timeout, cannot compute the backbone.");
                        }
                    }
                    if (this.nbSolutionFound >= 1) {
                        logger.log("Found " + this.nbSolutionFound + " solution(s)");
                    }
                    out.print(ILauncherMode.SOLUTION_PREFIX);
                    reader.decode(model, out);
                    out.println();
                }
                logger.log("Total wall clock time (in seconds) : " + wallclocktime);
            }
        }

        public void solve(IProblem problem, Reader reader, ILogAble logger, PrintWriter out, long beginTime) {
            this.exitCode = ExitCode.UNKNOWN;
            this.out = out;
            this.nbSolutionFound = 0;
            this.beginTime = beginTime;
            try {
                if (problem.isSatisfiable()) {
                    if (this.exitCode == ExitCode.UNKNOWN) {
                        this.exitCode = ExitCode.SATISFIABLE;
                    }
                } else if (this.exitCode == ExitCode.UNKNOWN) {
                    this.exitCode = ExitCode.UNSATISFIABLE;
                }
            }
            catch (TimeoutException timeoutException) {
                logger.log("timeout");
            }
        }

        public void setIncomplete(boolean isIncomplete) {
        }

        public ExitCode getCurrentExitCode() {
            return this.exitCode;
        }

        public void onSolutionFound(int[] solution) {
            ++this.nbSolutionFound;
            this.exitCode = ExitCode.SATISFIABLE;
            this.out.printf("c Found solution #%d  (%.2f)s%n", this.nbSolutionFound, (double)(System.currentTimeMillis() - this.beginTime) / 1000.0);
        }

        public void onSolutionFound(IVecInt solution) {
            throw new UnsupportedOperationException("Not implemented yet!");
        }

        public void onUnsatTermination() {
            if (this.exitCode == ExitCode.SATISFIABLE) {
                this.exitCode = ExitCode.OPTIMUM_FOUND;
            }
        }

        public void setExitCode(ExitCode exitCode) {
            this.exitCode = exitCode;
        }
    };
    public static final ILauncherMode OPTIMIZATION = new ILauncherMode(){
        private int nbSolutions;
        private ExitCode exitCode = ExitCode.UNKNOWN;
        private boolean isIncomplete = false;
        static final /* synthetic */ boolean $assertionsDisabled;

        public void setIncomplete(boolean isIncomplete) {
            this.isIncomplete = isIncomplete;
        }

        public void displayResult(ISolver solver, IProblem problem, ILogAble logger, PrintWriter out, Reader reader, long beginTime, boolean displaySolutionLine) {
            if (solver == null) {
                return;
            }
            System.out.flush();
            out.flush();
            solver.printStat(out);
            solver.printInfos(out);
            out.println(ILauncherMode.ANSWER_PREFIX + this.exitCode);
            if (this.exitCode == ExitCode.SATISFIABLE || this.exitCode == ExitCode.OPTIMUM_FOUND || this.isIncomplete && this.exitCode == ExitCode.UPPER_BOUND) {
                IOptimizationProblem optproblem;
                if (!$assertionsDisabled && this.nbSolutions <= 0) {
                    throw new AssertionError();
                }
                logger.log("Found " + this.nbSolutions + " solution(s)");
                if (displaySolutionLine) {
                    out.print(ILauncherMode.SOLUTION_PREFIX);
                    reader.decode(problem.model(), out);
                    out.println();
                }
                if (!(optproblem = (IOptimizationProblem)problem).hasNoObjectiveFunction()) {
                    String objvalue;
                    if (optproblem instanceof LexicoDecorator) {
                        Vec<Number> values = new Vec<Number>();
                        LexicoDecorator lexico = (LexicoDecorator)optproblem;
                        int i = 0;
                        while (i < lexico.numberOfCriteria()) {
                            values.push(lexico.getObjectiveValue(i));
                            ++i;
                        }
                        objvalue = ((Object)values).toString();
                    } else {
                        objvalue = optproblem.getObjectiveValue().toString();
                    }
                    logger.log("objective function=" + objvalue);
                }
            }
            logger.log("Total wall clock time (in seconds): " + (double)(System.currentTimeMillis() - beginTime) / 1000.0);
        }

        public void solve(IProblem problem, Reader reader, ILogAble logger, PrintWriter out, long beginTime) {
            boolean isSatisfiable = false;
            this.nbSolutions = 0;
            IOptimizationProblem optproblem = (IOptimizationProblem)problem;
            this.exitCode = ExitCode.UNKNOWN;
            try {
                while (optproblem.admitABetterSolution()) {
                    ++this.nbSolutions;
                    if (!isSatisfiable) {
                        if (optproblem.nonOptimalMeansSatisfiable()) {
                            logger.log("SATISFIABLE");
                            this.exitCode = ExitCode.SATISFIABLE;
                            if (optproblem.hasNoObjectiveFunction()) {
                                return;
                            }
                        } else if (this.isIncomplete) {
                            this.exitCode = ExitCode.UPPER_BOUND;
                        }
                        isSatisfiable = true;
                        logger.log("OPTIMIZING...");
                    }
                    logger.log("Got one! Elapsed wall clock time (in seconds):" + (double)(System.currentTimeMillis() - beginTime) / 1000.0);
                    out.println(ILauncherMode.CURRENT_OPTIMUM_VALUE_PREFIX + optproblem.getObjectiveValue());
                    optproblem.discardCurrentSolution();
                }
                this.exitCode = isSatisfiable ? ExitCode.OPTIMUM_FOUND : ExitCode.UNSATISFIABLE;
            }
            catch (ContradictionException contradictionException) {
                if (!$assertionsDisabled && !isSatisfiable) {
                    throw new AssertionError();
                }
                this.exitCode = ExitCode.OPTIMUM_FOUND;
            }
            catch (TimeoutException timeoutException) {
                logger.log("timeout");
            }
        }

        public ExitCode getCurrentExitCode() {
            return this.exitCode;
        }

        public void onSolutionFound(int[] solution) {
            throw new UnsupportedOperationException("Not implemented yet!");
        }

        public void onSolutionFound(IVecInt solution) {
            throw new UnsupportedOperationException("Not implemented yet!");
        }

        public void onUnsatTermination() {
        }

        public void setExitCode(ExitCode exitCode) {
            this.exitCode = exitCode;
        }
    };

    public void displayResult(ISolver var1, IProblem var2, ILogAble var3, PrintWriter var4, Reader var5, long var6, boolean var8);

    public void solve(IProblem var1, Reader var2, ILogAble var3, PrintWriter var4, long var5);

    public void setIncomplete(boolean var1);

    public ExitCode getCurrentExitCode();

    public void setExitCode(ExitCode var1);
}

