/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.emf.databinding.internal;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.FloatProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleFloatProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.fx.emf.databinding.EFXObject;
import org.eclipse.fx.emf.databinding.EProperty;
import org.eclipse.jdt.annotation.NonNull;

public class AdaptedEObject<@NonNull O extends EObject>
implements EFXObject<O> {
    final Map<EStructuralFeature, Property<?>> map = new HashMap();
    final O eo;
    private final EditingDomain ed;
    private Adapter adapter;

    public AdaptedEObject(EditingDomain ed, O eo) {
        this.eo = eo;
        this.ed = ed;
        this.adapter = new MyInnerAdapter(this);
        this.eo.eAdapters().add((Object)this.adapter);
    }

    @Override
    public BooleanProperty getBooleanProperty(EStructuralFeature feature) {
        if (feature.isMany()) {
            throw new IllegalArgumentException("Feature is multi valued");
        }
        if (feature.getEType().getInstanceClass() == Boolean.TYPE) {
            return (BooleanProperty)this.map.computeIfAbsent(feature, f -> new BooleanPropertyImpl(this, (EStructuralFeature)f, this.ed));
        }
        throw new IllegalAccessError("The feature type is not boolean.class");
    }

    @Override
    public DoubleProperty getDoubleProperty(EStructuralFeature feature) {
        if (feature.isMany()) {
            throw new IllegalArgumentException("Feature is multi valued");
        }
        if (feature.getEType().getInstanceClass() == Double.TYPE) {
            return (DoubleProperty)this.map.computeIfAbsent(feature, f -> new DoublePropertyImpl(this, (EStructuralFeature)f, this.ed));
        }
        throw new IllegalAccessError("The feature type is not double.class");
    }

    @Override
    public FloatProperty getFloatProperty(EStructuralFeature feature) {
        if (feature.isMany()) {
            throw new IllegalArgumentException("Feature is multi valued");
        }
        if (feature.getEType().getInstanceClass() == Float.TYPE) {
            return (FloatProperty)this.map.computeIfAbsent(feature, f -> new FloatPropertyImpl(this, (EStructuralFeature)f, this.ed));
        }
        throw new IllegalAccessError("The feature type is not float.class");
    }

    @Override
    public IntegerProperty getIntegerProperty(EStructuralFeature feature) {
        if (feature.isMany()) {
            throw new IllegalArgumentException("Feature is multi valued");
        }
        if (feature.getEType().getInstanceClass() == Integer.TYPE) {
            return (IntegerProperty)this.map.computeIfAbsent(feature, f -> new IntegerPropertyImpl(this, (EStructuralFeature)f, this.ed));
        }
        throw new IllegalAccessError("The feature type is not float.class");
    }

    @Override
    public LongProperty getLongProperty(EStructuralFeature feature) {
        if (feature.isMany()) {
            throw new IllegalArgumentException("Feature is multi valued");
        }
        if (feature.getEType().getInstanceClass() == Long.TYPE) {
            return (LongProperty)this.map.computeIfAbsent(feature, f -> new LongPropertyImpl(this, (EStructuralFeature)f, this.ed));
        }
        throw new IllegalAccessError("The feature type is not float.class");
    }

    @Override
    public <T> ObjectProperty<T> getObjectProperty(Class<T> type, EStructuralFeature feature) {
        if (feature.isMany()) {
            throw new IllegalArgumentException("Feature is multi valued");
        }
        if (feature instanceof EReference) {
            return (ObjectProperty)this.map.computeIfAbsent(feature, f -> new ObjectPropertyImpl(this, (EStructuralFeature)f, this.ed));
        }
        Class t = feature.getEType().getInstanceClass();
        if (t == String.class || t == Integer.TYPE || t == Long.TYPE || t == Double.TYPE || t == Float.TYPE || t == Boolean.TYPE) {
            throw new IllegalArgumentException("Feature holds a primitive value");
        }
        return new ObjectPropertyImpl(this, feature, this.ed);
    }

    @Override
    public StringProperty getStringProperty(EStructuralFeature feature) {
        if (feature.isMany()) {
            throw new IllegalArgumentException("Feature is multi valued");
        }
        if (feature.getEType().getInstanceClass() == String.class) {
            return (StringProperty)this.map.computeIfAbsent(feature, f -> new StringPropertyImpl(this, (EStructuralFeature)f, this.ed));
        }
        throw new IllegalAccessError("The feature type is not String.class");
    }

    static class BooleanPropertyImpl<@NonNull O extends EObject>
    extends SimpleBooleanProperty
    implements EProperty<O, Boolean> {
        private final AdaptedEObject<O> adapter;
        private final EStructuralFeature f;
        private final EditingDomain ed;

        public BooleanPropertyImpl(AdaptedEObject<O> adapter, EStructuralFeature f, EditingDomain ed) {
            this.adapter = adapter;
            this.f = f;
            this.ed = ed;
            this.set((Boolean)this.adapter.eo.eGet(this.f));
        }

        @Override
        public O getBean() {
            return this.adapter.eo;
        }

        @Override
        public EStructuralFeature getFeature() {
            return this.f;
        }

        public String getName() {
            return this.f.getName();
        }

        public void unbind() {
            super.unbind();
            this.set((Boolean)this.adapter.eo.eGet(this.f));
        }

        protected void invalidated() {
            super.invalidated();
            boolean value = this.get();
            if ((Boolean)this.adapter.eo.eGet(this.f) != value) {
                if (this.ed == null) {
                    this.adapter.eo.eSet(this.f, (Object)value);
                } else {
                    Command command = SetCommand.create((EditingDomain)this.ed, this.adapter.eo, (Object)this.f, (Object)value);
                    if (command.canExecute()) {
                        this.ed.getCommandStack().execute(command);
                    }
                }
            }
        }
    }

    static class DoublePropertyImpl<@NonNull O extends EObject>
    extends SimpleDoubleProperty
    implements EProperty<O, Number> {
        private final AdaptedEObject<O> adapter;
        private final EStructuralFeature f;
        private final EditingDomain ed;

        public DoublePropertyImpl(AdaptedEObject<O> adapter, EStructuralFeature f, EditingDomain ed) {
            this.adapter = adapter;
            this.f = f;
            this.ed = ed;
            this.set((Double)this.adapter.eo.eGet(this.f));
        }

        @Override
        public O getBean() {
            return this.adapter.eo;
        }

        @Override
        public EStructuralFeature getFeature() {
            return this.f;
        }

        public String getName() {
            return this.f.getName();
        }

        public void unbind() {
            super.unbind();
            this.set((Double)this.adapter.eo.eGet(this.f));
        }

        protected void invalidated() {
            super.invalidated();
            double value = this.get();
            if ((Double)this.adapter.eo.eGet(this.f) != value) {
                if (this.ed == null) {
                    this.adapter.eo.eSet(this.f, (Object)value);
                } else {
                    Command command = SetCommand.create((EditingDomain)this.ed, this.adapter.eo, (Object)this.f, (Object)value);
                    if (command.canExecute()) {
                        this.ed.getCommandStack().execute(command);
                    }
                }
            }
        }
    }

    static class FloatPropertyImpl<@NonNull O extends EObject>
    extends SimpleFloatProperty
    implements EProperty<O, Number> {
        private final AdaptedEObject<O> adapter;
        private final EStructuralFeature f;
        private final EditingDomain ed;

        public FloatPropertyImpl(AdaptedEObject<O> adapter, EStructuralFeature f, EditingDomain ed) {
            this.adapter = adapter;
            this.f = f;
            this.ed = ed;
            this.set(((Float)this.adapter.eo.eGet(this.f)).floatValue());
        }

        @Override
        public O getBean() {
            return this.adapter.eo;
        }

        @Override
        public EStructuralFeature getFeature() {
            return this.f;
        }

        public String getName() {
            return this.f.getName();
        }

        public void unbind() {
            super.unbind();
            this.set(((Float)this.adapter.eo.eGet(this.f)).floatValue());
        }

        protected void invalidated() {
            super.invalidated();
            float value = this.get();
            if (((Float)this.adapter.eo.eGet(this.f)).floatValue() != value) {
                if (this.ed == null) {
                    this.adapter.eo.eSet(this.f, (Object)Float.valueOf(value));
                } else {
                    Command command = SetCommand.create((EditingDomain)this.ed, this.adapter.eo, (Object)this.f, (Object)Float.valueOf(value));
                    if (command.canExecute()) {
                        this.ed.getCommandStack().execute(command);
                    }
                }
            }
        }
    }

    static class IntegerPropertyImpl<@NonNull O extends EObject>
    extends SimpleIntegerProperty
    implements EProperty<O, Number> {
        private final AdaptedEObject<O> adapter;
        private final EStructuralFeature f;
        private final EditingDomain ed;

        public IntegerPropertyImpl(AdaptedEObject<O> adapter, EStructuralFeature f, EditingDomain ed) {
            this.adapter = adapter;
            this.f = f;
            this.ed = ed;
            this.set((Integer)this.adapter.eo.eGet(this.f));
        }

        @Override
        public O getBean() {
            return this.adapter.eo;
        }

        @Override
        public EStructuralFeature getFeature() {
            return this.f;
        }

        public String getName() {
            return this.f.getName();
        }

        public void unbind() {
            super.unbind();
            this.set((Integer)this.adapter.eo.eGet(this.f));
        }

        protected void invalidated() {
            super.invalidated();
            int value = this.get();
            if ((Integer)this.adapter.eo.eGet(this.f) != value) {
                if (this.ed == null) {
                    this.adapter.eo.eSet(this.f, (Object)value);
                } else {
                    Command command = SetCommand.create((EditingDomain)this.ed, this.adapter.eo, (Object)this.f, (Object)value);
                    if (command.canExecute()) {
                        this.ed.getCommandStack().execute(command);
                    }
                }
            }
        }
    }

    static class LongPropertyImpl<@NonNull O extends EObject>
    extends SimpleLongProperty
    implements EProperty<O, Number> {
        private final AdaptedEObject<O> adapter;
        private final EStructuralFeature f;
        private final EditingDomain ed;

        public LongPropertyImpl(AdaptedEObject<O> adapter, EStructuralFeature f, EditingDomain ed) {
            this.adapter = adapter;
            this.f = f;
            this.ed = ed;
            this.set((Long)this.adapter.eo.eGet(this.f));
        }

        @Override
        public O getBean() {
            return this.adapter.eo;
        }

        @Override
        public EStructuralFeature getFeature() {
            return this.f;
        }

        public String getName() {
            return this.f.getName();
        }

        public void unbind() {
            super.unbind();
            this.set((Long)this.adapter.eo.eGet(this.f));
        }

        protected void invalidated() {
            super.invalidated();
            long value = this.get();
            if ((Long)this.adapter.eo.eGet(this.f) != value) {
                if (this.ed == null) {
                    this.adapter.eo.eSet(this.f, (Object)value);
                } else {
                    Command command = SetCommand.create((EditingDomain)this.ed, this.adapter.eo, (Object)this.f, (Object)value);
                    if (command.canExecute()) {
                        this.ed.getCommandStack().execute(command);
                    }
                }
            }
        }
    }

    static class MyInnerAdapter
    extends AdapterImpl {
        private WeakReference<AdaptedEObject<?>> eo;

        public MyInnerAdapter(AdaptedEObject<?> eo) {
            this.eo = new WeakReference(eo);
        }

        public void notifyChanged(Notification msg) {
            super.notifyChanged(msg);
            AdaptedEObject eo = (AdaptedEObject)this.eo.get();
            if (eo == null) {
                if (msg.getEventType() != 8) {
                    ((EObject)msg.getNotifier()).eAdapters().remove((Object)this);
                }
            } else {
                Property<?> property = eo.map.get(msg.getFeature());
                if (property != null && !property.isBound()) {
                    property.setValue(msg.getNewValue());
                }
            }
        }

        public void setTarget(Notifier newTarget) {
            super.setTarget(newTarget);
        }
    }

    static class ObjectPropertyImpl<@NonNull O extends EObject, V>
    extends SimpleObjectProperty<V>
    implements EProperty<O, V> {
        private final AdaptedEObject<O> adapter;
        private final EStructuralFeature f;
        private final EditingDomain ed;

        public ObjectPropertyImpl(AdaptedEObject<O> adapter, EStructuralFeature f, EditingDomain ed) {
            this.adapter = adapter;
            this.f = f;
            this.ed = ed;
            this.set(this.adapter.eo.eGet(this.f));
        }

        @Override
        public O getBean() {
            return this.adapter.eo;
        }

        @Override
        public EStructuralFeature getFeature() {
            return this.f;
        }

        public String getName() {
            return this.f.getName();
        }

        public void unbind() {
            super.unbind();
            this.set(this.adapter.eo.eGet(this.f));
        }

        protected void invalidated() {
            super.invalidated();
            Object value = this.get();
            if (this.adapter.eo.eGet(this.f) != value) {
                if (this.ed == null) {
                    this.adapter.eo.eSet(this.f, value);
                } else {
                    Command command = SetCommand.create((EditingDomain)this.ed, this.adapter.eo, (Object)this.f, (Object)value);
                    if (command.canExecute()) {
                        this.ed.getCommandStack().execute(command);
                    }
                }
            }
        }
    }

    static class StringPropertyImpl<@NonNull O extends EObject>
    extends SimpleStringProperty
    implements EProperty<O, String> {
        private final AdaptedEObject<O> adapter;
        private final EStructuralFeature f;
        private final EditingDomain ed;

        public StringPropertyImpl(AdaptedEObject<O> adapter, EStructuralFeature f, EditingDomain ed) {
            this.adapter = adapter;
            this.f = f;
            this.ed = ed;
            this.set((String)adapter.eo.eGet(f));
        }

        @Override
        public O getBean() {
            return this.adapter.eo;
        }

        @Override
        public EStructuralFeature getFeature() {
            return this.f;
        }

        public String getName() {
            return this.f.getName();
        }

        public void unbind() {
            super.unbind();
            this.set((String)this.adapter.eo.eGet(this.f));
        }

        protected void invalidated() {
            super.invalidated();
            String value = this.get();
            if (this.adapter.eo.eGet(this.f) != value) {
                if (this.ed == null) {
                    this.adapter.eo.eSet(this.f, (Object)value);
                } else {
                    Command command = SetCommand.create((EditingDomain)this.ed, this.adapter.eo, (Object)this.f, (Object)value);
                    if (command.canExecute()) {
                        this.ed.getCommandStack().execute(command);
                    }
                }
            }
        }
    }
}

