/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.parsetree.reconstr.impl;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.xtext.parsetree.reconstr.IEObjectConsumer;
import org.eclipse.xtext.parsetree.reconstr.ITransientValueService;

public class EObjectConsumer
implements IEObjectConsumer {
    private final ITransientValueService transientValueService;
    private final EObject described;
    private BitSet multiFeatures;
    private final int[] nextFeatureId;

    public EObjectConsumer(ITransientValueService transientValueService, EObject described) {
        this.described = described;
        this.transientValueService = transientValueService;
        EList features = described.eClass().getEAllStructuralFeatures();
        this.nextFeatureId = new int[features.size()];
        int featureId = 0;
        while (featureId < features.size()) {
            EStructuralFeature feature = (EStructuralFeature)features.get(featureId);
            if (feature.isMany() && transientValueService.isCheckElementsIndividually(described, feature)) {
                if (this.multiFeatures == null) {
                    this.multiFeatures = new BitSet();
                }
                this.multiFeatures.set(featureId);
                this.nextFeatureId[featureId] = this.firstID(feature);
            } else {
                this.nextFeatureId[featureId] = !transientValueService.isTransient(described, feature, -1) ? this.firstID(feature) : -1;
            }
            ++featureId;
        }
    }

    private EObjectConsumer(ITransientValueService tv, EObject described, int[] next, BitSet multi) {
        this.transientValueService = tv;
        this.described = described;
        this.nextFeatureId = next;
        this.multiFeatures = multi;
    }

    @Override
    public IEObjectConsumer cloneAndConsume(String featureName) {
        EStructuralFeature feature = this.getFeature(featureName);
        int[] consumedFeatureId = new int[this.nextFeatureId.length];
        System.arraycopy(this.nextFeatureId, 0, consumedFeatureId, 0, this.nextFeatureId.length);
        int featureId = this.described.eClass().getFeatureID(feature);
        consumedFeatureId[featureId] = this.nextID(feature, consumedFeatureId[featureId]);
        return new EObjectConsumer(this.transientValueService, this.described, consumedFeatureId, this.multiFeatures);
    }

    private int firstID(EStructuralFeature feature) {
        return this.nextID(feature, feature.isMany() ? ((List)this.described.eGet(feature)).size() : 1);
    }

    @Override
    public Object getConsumable(String featureName, boolean allowDefault) {
        EStructuralFeature feature = this.getFeature(featureName);
        if (feature != null && this.isConsumable(feature, allowDefault)) {
            Object get = this.described.eGet(feature);
            if (feature.isMany()) {
                List list = (List)get;
                get = list.get(this.nextFeatureId[this.described.eClass().getFeatureID(feature)]);
            }
            return get;
        }
        return null;
    }

    @Override
    public EObject getEObject() {
        return this.described;
    }

    private EStructuralFeature getFeature(String feature) {
        return this.described.eClass().getEStructuralFeature(feature);
    }

    @Override
    public Map<EStructuralFeature, Integer> getUnconsumed() {
        LinkedHashMap<EStructuralFeature, Integer> feature2FeatureId = new LinkedHashMap<EStructuralFeature, Integer>();
        EList features = this.described.eClass().getEAllStructuralFeatures();
        int id = 0;
        while (id < features.size()) {
            if (this.nextFeatureId[id] > -1) {
                feature2FeatureId.put((EStructuralFeature)features.get(id), this.nextFeatureId[id] + 1);
            }
            ++id;
        }
        return feature2FeatureId;
    }

    public boolean isConsumable(EStructuralFeature feature, boolean allowDefault) {
        return this.nextFeatureId[this.described.eClass().getFeatureID(feature)] > (allowDefault && !feature.isMany() ? -2 : -1);
    }

    @Override
    public boolean isConsumed() {
        int i = 0;
        while (i < this.nextFeatureId.length) {
            if (this.nextFeatureId[i] > -1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean isConsumedWithLastConsumtion(String featureName) {
        EStructuralFeature feature = this.getFeature(featureName);
        int featureId = this.described.eClass().getFeatureID(feature);
        int i = 0;
        while (i < this.nextFeatureId.length) {
            if ((i == featureId ? this.nextID(feature, this.nextFeatureId[i]) : this.nextFeatureId[i]) > -1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean isInstanceOf(EClassifier classifier) {
        if (!(classifier instanceof EClass)) {
            return false;
        }
        if (classifier == EcorePackage.Literals.EOBJECT) {
            return true;
        }
        return ((EClass)classifier).isSuperTypeOf(this.getEObject().eClass());
    }

    private int nextID(EStructuralFeature feature, int lastId) {
        int myLastId = lastId;
        if (feature.isMany()) {
            if (this.multiFeatures != null && this.multiFeatures.get(this.described.eClass().getFeatureID(feature))) {
                --myLastId;
                while (myLastId >= 0 && this.transientValueService.isTransient(this.described, feature, myLastId)) {
                    --myLastId;
                }
                return myLastId;
            }
        } else if (lastId == 0) {
            return -2;
        }
        return myLastId - 1;
    }

    public String toString() {
        ArrayList<String> featureNameAndValues = new ArrayList<String>();
        for (Map.Entry<EStructuralFeature, Integer> feature2IdEntry : this.getUnconsumed().entrySet()) {
            featureNameAndValues.add(String.valueOf(feature2IdEntry.getKey().getName()) + ":" + feature2IdEntry.getValue());
        }
        return String.valueOf(this.described.eClass().getName()) + ":" + this.described.hashCode() + (featureNameAndValues.size() > 0 ? ":" + featureNameAndValues : "");
    }
}

