/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.validation;

import com.google.common.annotations.Beta;
import com.google.inject.Inject;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.validation.CancelableDiagnostician;
import org.eclipse.xtext.xbase.XClosure;

@Beta
public class XbaseDiagnostician
extends CancelableDiagnostician {
    @Inject
    public XbaseDiagnostician(EValidator.Registry registry) {
        super(registry);
    }

    protected boolean doValidateContents(EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (this.isCanceled(context)) {
            return true;
        }
        if (eObject instanceof XClosure) {
            return this.doValidateLambdaContents((XClosure)eObject, diagnostics, context);
        }
        return super.doValidateContents(eObject, diagnostics, context);
    }

    protected boolean doValidateLambdaContents(XClosure closure, DiagnosticChain diagnostics, Map<Object, Object> context) {
        EList<JvmFormalParameter> implicitParameters = closure.getImplicitFormalParameters();
        boolean parameterVisited = implicitParameters.isEmpty();
        EList eContents = closure.eContents();
        if (!eContents.isEmpty()) {
            Iterator i = eContents.iterator();
            EObject child = (EObject)i.next();
            if (child != null && child.eClass() == TypesPackage.Literals.JVM_FORMAL_PARAMETER && implicitParameters.contains(child)) {
                parameterVisited = true;
            }
            boolean result = this.validate(child, diagnostics, context);
            while (i.hasNext() && (result || diagnostics != null)) {
                child = (EObject)i.next();
                if (child != null && child.eClass() == TypesPackage.Literals.JVM_FORMAL_PARAMETER && implicitParameters.contains(child)) {
                    parameterVisited = true;
                }
                result &= this.validate(child, diagnostics, context);
            }
            if (!parameterVisited) {
                int idx = 0;
                while (idx < implicitParameters.size()) {
                    result &= this.validate((EObject)implicitParameters.get(idx), diagnostics, context);
                    ++idx;
                }
            }
            return result;
        }
        if (!parameterVisited) {
            boolean result = true;
            int idx = 0;
            while (idx < implicitParameters.size()) {
                result &= this.validate((EObject)implicitParameters.get(idx), diagnostics, context);
                ++idx;
            }
            return result;
        }
        return true;
    }
}

