/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.filesystem.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.BehaviorSkinBase;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.control.Control;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import org.eclipse.fx.ui.controls.filesystem.DirItem;
import org.eclipse.fx.ui.controls.filesystem.DirectoryTreeView;
import org.eclipse.fx.ui.controls.filesystem.ResourceItem;
import org.eclipse.fx.ui.controls.filesystem.behavior.DirectoryTreeViewBehavior;
import org.eclipse.fx.ui.controls.tree.LazyTreeItem;
import org.eclipse.fx.ui.controls.tree.SimpleTreeCell;
import org.eclipse.jdt.annotation.NonNull;

public class DirectoryTreeViewSkin
extends BehaviorSkinBase<DirectoryTreeView, DirectoryTreeViewBehavior> {
    private final TreeView<@NonNull DirItem> tree;
    private final ObservableList<DirItem> selectedItems;
    static Function<TreeItem<DirItem>, List<TreeItem<DirItem>>> FACTORY = p -> FXCollections.observableArrayList((Collection)((DirItem)p.getValue()).getChildren().stream().filter(c -> c instanceof DirItem).map(c -> new DirTreeItem((DirItem)c)).collect(Collectors.toList()));

    public DirectoryTreeViewSkin(DirectoryTreeView control, ObservableList<DirItem> selectedItems) {
        super((Control)control, (BehaviorBase)new DirectoryTreeViewBehavior(control));
        this.selectedItems = selectedItems;
        this.tree = new TreeView();
        this.tree.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.tree.setCellFactory(v -> new SimpleTreeCell<DirItem>(DirectoryTreeViewSkin::handleDirLabel, this::handleStyleclass));
        this.tree.setShowRoot(false);
        this.tree.getSelectionModel().getSelectedItems().addListener(this::handleSelectionChange);
        this.getChildren().add(this.tree);
        control.rootDirectoriesProperty().addListener(this::rebuildTable);
        control.iconSizeProperty().addListener(this::rebuildTable);
        this.rebuildTable((Observable)control.rootDirectoriesProperty());
    }

    private static String handleDirLabel(DirItem e) {
        return e.getName();
    }

    private void handleSelectionChange(Observable o) {
        this.selectedItems.setAll((Collection)this.tree.getSelectionModel().getSelectedItems().stream().map(t -> (DirItem)t.getValue()).collect(Collectors.toList()));
    }

    private @NonNull List<@NonNull String> handleStyleclass(DirItem e) {
        switch (((DirectoryTreeView)this.getSkinnable()).getIconSize()) {
            case SMALL: {
                return Collections.singletonList("folderSmall");
            }
            case MEDIUM: {
                return Collections.singletonList("folderMedium");
            }
        }
        return Collections.singletonList("folderBig");
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void rebuildTable(Observable o) {
        if (((DirectoryTreeView)this.getSkinnable()).getRootDirectories() == null) {
            this.tree.setRoot(new TreeItem());
        } else {
            @NonNull TreeItem root = new TreeItem();
            root.getChildren().setAll((Collection)((DirectoryTreeView)this.getSkinnable()).getRootDirectories().stream().map(d -> new DirTreeItem((DirItem)d)).collect(Collectors.toList()));
            this.tree.setRoot(root);
        }
    }

    static class DirTreeItem
    extends LazyTreeItem<DirItem> {
        public DirTreeItem(DirItem item) {
            super(item, FACTORY);
            item.getChildren().addListener(this::handleListModification);
        }

        private void handleListModification(ListChangeListener.Change<? extends ResourceItem> change) {
            if (!Platform.isFxApplicationThread()) {
                Platform.runLater(() -> this._handleListModification(change));
            } else {
                this._handleListModification(change);
            }
        }

        private void _handleListModification(ListChangeListener.Change<? extends ResourceItem> change) {
            while (change.next()) {
                if (change.wasRemoved()) {
                    Map<DirItem, TreeItem> map = this.getChildren().stream().collect(Collectors.toMap(c -> (DirItem)c.getValue(), c -> c));
                    List itemsToRemove = change.getRemoved().stream().filter(c -> map.containsKey(c)).map(c -> map.get(c)).collect(Collectors.toList());
                    this.getChildren().removeAll(itemsToRemove);
                }
                if (!change.wasAdded()) continue;
                this.getChildren().addAll((Collection)change.getAddedSubList().stream().filter(c -> c instanceof DirItem).map(c -> new DirTreeItem((DirItem)c)).collect(Collectors.toList()));
            }
        }
    }
}

