/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.fx;

import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.fx.ui.workbench.renderers.base.BasePerspectiveStackRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.services.PerspectiveTransitionService;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WCallback;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WPerspectiveStack;
import org.eclipse.fx.ui.workbench.renderers.fx.widget.PerspectiveStackItem;
import org.eclipse.fx.ui.workbench.renderers.fx.widget.WLayoutedWidgetImpl;
import org.eclipse.jdt.annotation.NonNull;

public class DefPerspectiveStackRenderer
extends BasePerspectiveStackRenderer<BorderPane, PerspectiveStackItem, Node> {
    protected Class<? extends WPerspectiveStack<BorderPane, PerspectiveStackItem, Node>> getWidgetClass(MPerspectiveStack stack) {
        return PerspectiveStackImpl.class;
    }

    static class PerspectiveStackImpl
    extends WLayoutedWidgetImpl<BorderPane, BorderPane, MPerspectiveStack>
    implements WPerspectiveStack<BorderPane, PerspectiveStackItem, Node> {
        private @NonNull List<// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull WPerspectiveStack.WStackItem<PerspectiveStackItem, Node>> items = new ArrayList<WPerspectiveStack.WStackItem<PerspectiveStackItem, Node>>();
        private int currentIndex;
        @Inject
        @Optional
        private PerspectiveTransitionService<BorderPane, Node> perspectiveSwitch;
        @Inject
        IEventBroker eventBroker;

        PerspectiveStackImpl() {
        }

        public Class<? extends WPerspectiveStack.WStackItem<PerspectiveStackItem, Node>> getStackItemClass() {
            return PerspectiveStackItemImpl.class;
        }

        public void addItem(WPerspectiveStack.WStackItem<PerspectiveStackItem, Node> item) {
            this.items.add(item);
        }

        public void addItems(List<// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull WPerspectiveStack.WStackItem<PerspectiveStackItem, Node>> items) {
            this.items.addAll(items);
        }

        public void addItems(int index, List<// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull WPerspectiveStack.WStackItem<PerspectiveStackItem, Node>> items) {
            this.items.addAll(index, items);
        }

        public void selectItem(int idx) {
            WPerspectiveStack.WStackItem<PerspectiveStackItem, Node> item = this.items.get(idx);
            PerspectiveStackItem nativeItem = (PerspectiveStackItem)item.getNativeItem();
            if (nativeItem != null) {
                Node node = nativeItem.getContent();
                if (node == null) {
                    return;
                }
                MPerspective curDomElement = this.items.get(this.currentIndex).getDomElement();
                MPerspective nexDomElement = item.getDomElement();
                if (((BorderPane)this.getWidget()).getCenter() != null && this.perspectiveSwitch != null) {
                    if (curDomElement != null && nexDomElement != null) {
                        PerspectiveTransitionService.AnimationDelegate a = this.perspectiveSwitch.getDelegate(curDomElement, nexDomElement);
                        if (a == null) {
                            ((BorderPane)this.getWidget()).setCenter(node);
                        } else {
                            a.animate((Object)((BorderPane)this.getWidget()), (Object)node, () -> {
                                this.eventBroker.send("org/eclipse/fx/MPerspective/Hidden", (Object)curDomElement);
                                this.eventBroker.send("org/eclipse/fx/MPerspective/Shown", (Object)nexDomElement);
                            });
                        }
                    } else {
                        ((BorderPane)this.getWidget()).setCenter(node);
                        this.eventBroker.send("org/eclipse/fx/MPerspective/Hidden", (Object)curDomElement);
                        this.eventBroker.send("org/eclipse/fx/MPerspective/Shown", (Object)nexDomElement);
                    }
                } else {
                    ((BorderPane)this.getWidget()).setCenter(node);
                    this.eventBroker.send("org/eclipse/fx/MPerspective/Hidden", (Object)curDomElement);
                    this.eventBroker.send("org/eclipse/fx/MPerspective/Shown", (Object)nexDomElement);
                }
                this.currentIndex = idx;
            }
        }

        public int indexOf(WPerspectiveStack.WStackItem<PerspectiveStackItem, Node> item) {
            return this.items.indexOf(item);
        }

        public List<WPerspectiveStack.WStackItem<PerspectiveStackItem, Node>> getItems() {
            return this.items;
        }

        public void removeItems(List<WPerspectiveStack.WStackItem<PerspectiveStackItem, Node>> items) {
            this.items.removeAll(items);
        }

        public void setMouseSelectedItemCallback(WCallback<WPerspectiveStack.WStackItem<PerspectiveStackItem, Node>, Void> selectedItemCallback) {
        }

        public void setKeySelectedItemCallback(WCallback<WPerspectiveStack.WStackItem<PerspectiveStackItem, Node>, Void> selectedItemCallback) {
        }

        public int getItemCount() {
            return this.items.size();
        }

        @Override
        protected BorderPane getWidgetNode() {
            return (BorderPane)this.getWidget();
        }

        @Override
        protected BorderPane createWidget() {
            return new BorderPane();
        }
    }

    static class PerspectiveStackItemImpl
    implements WPerspectiveStack.WStackItem<PerspectiveStackItem, Node> {
        private PerspectiveStackItem item;
        private MPerspective domElement;
        WCallback<WPerspectiveStack.WStackItem<PerspectiveStackItem, Node>, Node> initCallback;

        PerspectiveStackItemImpl() {
        }

        @PostConstruct
        void init() {
            this.getWidget();
        }

        protected PerspectiveStackItem getWidget() {
            if (this.item == null) {
                this.item = this.createWidget();
            }
            return this.item;
        }

        protected PerspectiveStackItem createWidget() {
            final PerspectiveStackItem t = new PerspectiveStackItem();
            t.setInitRunnable(new Runnable(){

                @Override
                public void run() {
                    if (initCallback != null) {
                        t.setContent((Node)initCallback.call((Object)this));
                    }
                }
            });
            return t;
        }

        public PerspectiveStackItem getNativeItem() {
            return this.item;
        }

        public void setDomElement(MPerspective domElement) {
            this.domElement = domElement;
        }

        public MPerspective getDomElement() {
            return this.domElement;
        }

        public void setInitCallback(WCallback<WPerspectiveStack.WStackItem<PerspectiveStackItem, Node>, Node> callback) {
            this.initCallback = callback;
        }

        public void setOnCloseCallback(WCallback<WPerspectiveStack.WStackItem<PerspectiveStackItem, Node>, Boolean> callback) {
        }
    }
}

