/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.security.linux;

import java.security.SecureRandom;
import javax.crypto.spec.PBEKeySpec;
import org.eclipse.equinox.internal.security.auth.AuthPlugin;
import org.eclipse.equinox.internal.security.linux.nls.LinuxPasswordProviderMessages;
import org.eclipse.equinox.internal.security.storage.Base64;
import org.eclipse.equinox.security.storage.provider.IPreferencesContainer;
import org.eclipse.equinox.security.storage.provider.PasswordProvider;

public class LinuxPasswordProvider
extends PasswordProvider {
    private static final int PASSWORD_LENGTH = 64;

    static {
        System.loadLibrary("keystorelinuxnative");
    }

    private native String getMasterPassword() throws SecurityException;

    private native void saveMasterPassword(String var1) throws SecurityException;

    public PBEKeySpec getPassword(IPreferencesContainer container, int passwordType) {
        boolean passwordChange;
        boolean newPassword = (passwordType & 1) != 0;
        boolean bl = passwordChange = (passwordType & 2) != 0;
        if (!newPassword && !passwordChange) {
            try {
                return new PBEKeySpec(this.getMasterPassword().toCharArray());
            }
            catch (SecurityException e) {
                AuthPlugin.getDefault().logError(LinuxPasswordProviderMessages.getMasterPasswordError, (Throwable)e);
                return null;
            }
        }
        byte[] rawPassword = new byte[64];
        SecureRandom random = new SecureRandom();
        random.setSeed(System.currentTimeMillis());
        random.nextBytes(rawPassword);
        String newPasswordString = Base64.encode((byte[])rawPassword);
        AuthPlugin.getDefault().logMessage(LinuxPasswordProviderMessages.newMasterPasswordGenerated);
        try {
            this.saveMasterPassword(newPasswordString);
            return new PBEKeySpec(newPasswordString.toCharArray());
        }
        catch (SecurityException e) {
            AuthPlugin.getDefault().logError(LinuxPasswordProviderMessages.saveMasterPasswordError, (Throwable)e);
            return null;
        }
    }
}

