/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.AboutToHide;
import org.eclipse.e4.ui.di.AboutToShow;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.menu.MDynamicMenuContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.ui.workbench.renderers.base.BaseItemContainerRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.BaseItemRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WMenu;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WMenuElement;
import org.eclipse.fx.ui.workbench.services.ELifecycleService;
import org.eclipse.fx.ui.workbench.services.lifecycle.annotation.PreClose;
import org.eclipse.fx.ui.workbench.services.lifecycle.annotation.PreShow;
import org.eclipse.jdt.annotation.NonNull;

public abstract class BaseMenuRenderer<N>
extends BaseItemContainerRenderer<MMenu, MMenuElement, WMenu<N>> {
    @Inject
    ELifecycleService lifecycleService;
    @Inject
    private IContributionFactory contributionFactory;
    @Log
    @Inject
    private Logger logger;
    private static final String DYNAMIC_MENU_CONTRIBUTION = "DYNAMIC_MENU_CONTRIBUTION";
    private Set<MMenu> currentVisibleMenus = new HashSet<MMenu>();

    @Override
    protected void do_init(@NonNull IEventBroker broker) {
        this.registerEventListener(broker, "org/eclipse/e4/ui/model/ui/UILabel/iconURI/*");
        this.registerEventListener(broker, "org/eclipse/e4/ui/model/ui/UILabel/label/*");
        this.registerEventListener(broker, "org/eclipse/e4/ui/model/ui/UILabel/localizedLabel/*");
        this.registerEventListener(broker, "org/eclipse/e4/ui/model/ui/UILabel/tooltip/*");
        this.registerEventListener(broker, "org/eclipse/e4/ui/model/ui/UILabel/localizedTooltip/*");
    }

    @Override
    protected void initWidget(MMenu element, WMenu<N> widget) {
        super.initWidget(element, widget);
        widget.setShowingCallback(() -> this.handleShowing(element));
        widget.setHidingCallback(() -> this.handleHiding(element));
    }

    void handleHiding(@NonNull MMenu element) {
        this.currentVisibleMenus.remove(element);
        IEclipseContext modelContext = this.getModelContext((MUIElement)element);
        if (modelContext == null) {
            this.getLogger().info("Model context is null, probably already disposed");
            return;
        }
        IEclipseContext context = modelContext.createChild("lifecycle");
        context.set(MMenu.class, (Object)element);
        this.lifecycleService.validateAnnotation(PreClose.class, (MUIElement)element, context);
        MMenuElement[] mMenuElementArray = element.getChildren().toArray(new MMenuElement[0]);
        int n = mMenuElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            MDynamicMenuContribution dc;
            Object contrib;
            MMenuElement e = mMenuElementArray[n2];
            if (e instanceof MDynamicMenuContribution && (contrib = (dc = (MDynamicMenuContribution)e).getObject()) != null) {
                List previous = (List)dc.getTransientData().remove(DYNAMIC_MENU_CONTRIBUTION);
                context.set(List.class, (Object)previous);
                try {
                    ContextInjectionFactory.invoke((Object)contrib, AboutToHide.class, (IEclipseContext)context, null);
                    if (previous != null && !previous.isEmpty()) {
                        element.getChildren().removeAll(previous);
                    }
                }
                catch (Throwable t) {
                    this.getLogger().debug("Unable to process the AboutToHide", t);
                }
            }
            ++n2;
        }
        context.dispose();
    }

    void handleShowing(@NonNull MMenu element) {
        this.currentVisibleMenus.add(element);
        IEclipseContext modelContext = this.getModelContext((MUIElement)element);
        if (modelContext == null) {
            this.getLogger().error("The model context is null");
            return;
        }
        IEclipseContext context = modelContext.createChild("lifecycle");
        context.set(MMenu.class, (Object)element);
        this.lifecycleService.validateAnnotation(PreShow.class, (MUIElement)element, context);
        MMenuElement[] mMenuElementArray = element.getChildren().toArray(new MMenuElement[0]);
        int n = mMenuElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            MMenuElement e = mMenuElementArray[n2];
            if (e instanceof MDynamicMenuContribution) {
                Object contrib;
                MDynamicMenuContribution dc = (MDynamicMenuContribution)e;
                if (dc.getObject() == null && dc.getContributionURI() != null) {
                    try {
                        dc.setObject(this.contributionFactory.create(dc.getContributionURI(), context));
                    }
                    catch (Throwable t) {
                        this.getLogger().debug("Unable to create contribution", t);
                    }
                }
                if ((contrib = dc.getObject()) != null) {
                    ArrayList list = new ArrayList();
                    context.set(List.class, list);
                    try {
                        ContextInjectionFactory.invoke((Object)contrib, AboutToShow.class, (IEclipseContext)context, null);
                        int idx = element.getChildren().indexOf(e);
                        element.getChildren().addAll(idx, list);
                        dc.getTransientData().put(DYNAMIC_MENU_CONTRIBUTION, list);
                    }
                    catch (Throwable t) {
                        this.getLogger().debug("Unable to process AboutToShow", t);
                    }
                }
            }
            ++n2;
        }
        for (MMenuElement e : element.getChildren()) {
            if (!(e.getRenderer() instanceof BaseItemRenderer)) continue;
            BaseItemRenderer r = (BaseItemRenderer)e.getRenderer();
            r.checkEnablement(e);
        }
        context.dispose();
    }

    @Override
    protected boolean skipEnablementCheck() {
        return this.currentVisibleMenus.isEmpty();
    }

    @Override
    protected boolean isShowing(MMenuElement item) {
        return this.currentVisibleMenus.contains(item.getParent());
    }

    @Override
    public void doProcessContent(MMenu element) {
        WMenu menu = (WMenu)this.getWidget((MUIElement)element);
        if (menu == null) {
            this.getLogger().error("No widget found for '" + element + "'");
            return;
        }
        for (MMenuElement e : element.getChildren()) {
            WMenuElement widget;
            if (!e.isToBeRendered() || (widget = (WMenuElement)this.engineCreateWidget(e)) == null || !this.isChildRenderedAndVisible((MUIElement)e)) continue;
            menu.addElement(widget);
        }
    }

    @Override
    public void handleChildrenRemove(@NonNull MMenu parent, @NonNull Collection<@NonNull MMenuElement> elements) {
        for (MMenuElement element : elements) {
            if (!element.isToBeRendered() || element.getWidget() == null) continue;
            this.hideChild(parent, (MUIElement)element);
        }
    }

    @Override
    public void handleChildrenAddition(MMenu parent, Collection<MMenuElement> elements) {
        for (MMenuElement element : elements) {
            if (!element.isToBeRendered()) continue;
            if (element.getWidget() == null) {
                this.engineCreateWidget(element);
                continue;
            }
            this.childRendered(parent, (MUIElement)element);
        }
    }

    @Override
    public void do_childRendered(@NonNull MMenu parentElement, @NonNull MUIElement element) {
        if (this.inContentProcessing((MUIElement)parentElement) || !this.isChildRenderedAndVisible(element)) {
            return;
        }
        int idx = this.getRenderedIndex((MUIElement)parentElement, element);
        WMenu menu = (WMenu)this.getWidget((MUIElement)parentElement);
        if (menu == null) {
            this.getLogger().error("No widget found for '" + parentElement + "'");
            return;
        }
        WMenuElement menuElement = (WMenuElement)element.getWidget();
        if (menuElement != null) {
            menu.addElement(idx, menuElement);
        } else {
            this.getLogger().error("The widget of the element '" + element + "' is null");
        }
    }

    @Override
    public boolean isChildRenderedAndVisible(MUIElement u) {
        return super.isChildRenderedAndVisible(u) && !(u instanceof MDynamicMenuContribution);
    }

    @Override
    public void do_hideChild(MMenu container, MUIElement changedObj) {
        WMenu menu = (WMenu)this.getWidget((MUIElement)container);
        if (menu == null) {
            return;
        }
        WMenuElement widget = (WMenuElement)changedObj.getWidget();
        if (widget != null) {
            menu.removeElement(widget);
        }
    }
}

