/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.touchpoint.natives.actions;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.touchpoint.natives.IBackupStore;
import org.eclipse.equinox.internal.p2.touchpoint.natives.Messages;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;
import org.eclipse.osgi.util.NLS;

public class LinkAction
extends ProvisioningAction {
    public static final String ID = "ln";
    private static final boolean WINDOWS = File.separatorChar == '\\';

    public IStatus execute(Map<String, Object> parameters) {
        String targetDir = (String)parameters.get("targetDir");
        if (targetDir == null) {
            return new Status(4, "org.eclipse.equinox.p2.touchpoint.natives", 0, NLS.bind((String)Messages.param_not_set, (Object)"targetDir", (Object)ID), null);
        }
        String linkTarget = (String)parameters.get("linkTarget");
        if (linkTarget == null) {
            return new Status(4, "org.eclipse.equinox.p2.touchpoint.natives", 0, NLS.bind((String)Messages.param_not_set, (Object)"linkTarget", (Object)ID), null);
        }
        String linkName = (String)parameters.get("linkName");
        if (linkName == null) {
            return new Status(4, "org.eclipse.equinox.p2.touchpoint.natives", 0, NLS.bind((String)Messages.param_not_set, (Object)"linkName", (Object)ID), null);
        }
        String force = (String)parameters.get("force");
        IBackupStore store = (IBackupStore)parameters.get("backup");
        try {
            this.ln(targetDir, linkTarget, linkName, Boolean.parseBoolean(force), store);
        }
        catch (IOException e) {
            return new Status(4, "org.eclipse.equinox.p2.touchpoint.natives", 0, NLS.bind((String)Messages.link_failed, (Object)linkName, (Object)ID), (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    public IStatus undo(Map<String, Object> parameters) {
        if (WINDOWS) {
            return Status.OK_STATUS;
        }
        String targetDir = (String)parameters.get("targetDir");
        String linkName = (String)parameters.get("linkName");
        if (targetDir != null && linkName != null) {
            File linkFile = new File(targetDir, linkName);
            linkFile.delete();
        }
        return Status.OK_STATUS;
    }

    private void ln(String targetDir, String linkTarget, String linkName, boolean force, IBackupStore store) throws IOException {
        File xFile;
        if (WINDOWS) {
            return;
        }
        if (force && store != null && (xFile = new File(targetDir, linkName)).exists()) {
            store.backup(xFile);
        }
        Runtime r = Runtime.getRuntime();
        try {
            Process process = r.exec(new String[]{ID, "-s" + (force ? "f" : ""), linkTarget, String.valueOf(targetDir) + '/' + linkName});
            this.readOffStream(process.getErrorStream());
            this.readOffStream(process.getInputStream());
            try {
                process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        catch (IOException iOException) {}
    }

    private void readOffStream(InputStream inputStream) {
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
                while (reader.readLine() != null) {
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
    }
}

