/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zgrviewer;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

class PrintUtilities
extends JPanel
implements Printable {
    private BufferedImage bufferedImage;

    public PrintUtilities(BufferedImage bufferedImage) {
        this.bufferedImage = bufferedImage;
    }

    public void print() {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        PageFormat pf = new PageFormat();
        pf.setOrientation(0);
        printJob.setPrintable(this, pf);
        if (printJob.printDialog()) {
            try {
                printJob.print();
            }
            catch (PrinterException pe) {
                JOptionPane.showMessageDialog(null, "Error while printing", "Error", 0);
                System.err.println("** Error printing: " + pe);
                pe.printStackTrace();
            }
        }
    }

    public int print(Graphics g, PageFormat pf, int pageIndex) {
        Graphics2D g2d = (Graphics2D)g;
        int panelWidth = this.bufferedImage.getWidth();
        int panelHeight = this.bufferedImage.getHeight();
        double pageHeight = pf.getImageableHeight();
        double pageWidth = pf.getImageableWidth();
        if (pageIndex >= 1) {
            return 1;
        }
        this.setSize(new Dimension(panelWidth, panelHeight));
        g2d.translate(pf.getImageableX(), pf.getImageableY());
        g2d.translate(pf.getImageableWidth() / 2.0, pf.getImageableHeight() / 2.0);
        Dimension d = this.getSize();
        double scale = Math.min(pf.getImageableWidth() / (double)d.width, pf.getImageableHeight() / (double)d.height);
        if (scale < 1.0) {
            g2d.scale(scale, scale);
        }
        g2d.translate((double)(-d.width) / 2.0, (double)(-d.height) / 2.0);
        this.setOpaque(true);
        this.paint(g2d);
        return 0;
    }

    public void paint(Graphics g) {
        if (this.getSize().width <= 0 || this.getSize().height <= 0) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        if (this.bufferedImage != null) {
            g2.drawImage((Image)this.bufferedImage, 0, 0, this);
        }
    }
}

