/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.model.edit;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.SaveOptions;
import org.eclipse.xtext.serializer.ISerializer;
import org.eclipse.xtext.ui.editor.model.edit.ITextEditComposer;
import org.eclipse.xtext.util.ReplaceRegion;

public class DefaultTextEditComposer
extends EContentAdapter
implements ITextEditComposer {
    @Inject
    private ISerializer serializer;
    private Resource resource;
    private int resourceSize;
    private boolean resourceChanged;
    private Collection<EObject> modifiedObjects = new LinkedHashSet<EObject>();
    private boolean recording = false;

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        if (!this.doRecord(notification)) {
            return;
        }
        if (notification.getNotifier() instanceof EObject) {
            this.recordObjectModification((EObject)notification.getNotifier());
        } else if (notification.getNotifier() instanceof Resource) {
            this.recordResourceModification((Resource)notification.getNotifier());
        }
    }

    protected void recordObjectModification(EObject obj) {
        if (obj.eResource() == null || obj.eResource() != this.resource) {
            this.getModifiedObjects().remove(obj);
        } else {
            this.getModifiedObjects().add(obj);
        }
    }

    protected void recordResourceModification(Resource notifier) {
        this.resourceChanged = true;
    }

    protected Collection<EObject> getModifiedObjects() {
        return this.modifiedObjects;
    }

    protected boolean doRecord(Notification notification) {
        if (!this.recording || notification.isTouch()) {
            return false;
        }
        switch (notification.getEventType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    protected void reset() {
        this.getModifiedObjects().clear();
        this.resourceChanged = false;
    }

    @Override
    public void beginRecording(Resource newResource) {
        this.reset();
        if (newResource != this.resource) {
            if (this.resource != null) {
                this.resource.eAdapters().remove((Object)this);
            }
            newResource.eAdapters().add((Object)this);
            this.resource = newResource;
        }
        if (this.resource.getContents().isEmpty()) {
            this.resourceSize = 0;
        } else {
            EObject root = (EObject)this.resource.getContents().get(0);
            ICompositeNode rootNode = NodeModelUtils.getNode((EObject)root);
            if (rootNode == null) {
                throw new IllegalStateException("Cannot find root node in resource " + this.resource.getURI());
            }
            this.resourceSize = rootNode.getTotalLength();
        }
        this.recording = true;
    }

    @Override
    public TextEdit endRecording() {
        this.recording = false;
        TextEdit textEdit = this.getTextEdit();
        this.reset();
        return textEdit;
    }

    @Override
    public TextEdit getTextEdit() {
        ReplaceEdit result = null;
        if (this.resourceChanged) {
            String text = this.resource.getContents().isEmpty() ? "" : this.serializer.serialize((EObject)this.resource.getContents().get(0));
            result = new ReplaceEdit(0, this.resourceSize, text);
        } else {
            Collection<EObject> modifiedObjects = this.getModifiedObjects();
            if (!modifiedObjects.isEmpty()) {
                List<TextEdit> edits = this.getObjectEdits();
                if (edits.size() == 1) {
                    result = edits.get(0);
                } else {
                    result = new MultiTextEdit();
                    for (TextEdit edit : edits) {
                        result.addChild(edit);
                    }
                }
            }
        }
        return result;
    }

    protected List<TextEdit> getObjectEdits() {
        Collection<EObject> modifiedObjects = this.getModifiedObjects();
        List topLevelObjects = EcoreUtil.filterDescendants(modifiedObjects);
        Iterable<Object> containedModifiedObjects = Collections.emptyList();
        if (!this.resource.getContents().isEmpty()) {
            final EObject root = (EObject)this.resource.getContents().get(0);
            containedModifiedObjects = Iterables.filter((Iterable)topLevelObjects, (Predicate)new Predicate<EObject>(){

                public boolean apply(EObject input) {
                    return EcoreUtil.isAncestor((EObject)root, (EObject)input);
                }
            });
        }
        ArrayList edits = Lists.newArrayListWithExpectedSize((int)Iterables.size(containedModifiedObjects));
        for (EObject modifiedObject : containedModifiedObjects) {
            ReplaceRegion replaceRegion = this.serializer.serializeReplacement(modifiedObject, this.getSaveOptions());
            ReplaceEdit edit = new ReplaceEdit(replaceRegion.getOffset(), replaceRegion.getLength(), replaceRegion.getText());
            edits.add(edit);
        }
        return edits;
    }

    protected SaveOptions getSaveOptions() {
        return SaveOptions.defaultOptions();
    }

    @Deprecated
    public void setSerializerUtil(ISerializer serializer) {
        this.setSerializer(serializer);
    }

    public void setSerializer(ISerializer serializer) {
        this.serializer = serializer;
    }
}

