/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.metrics.risk;

import org.eclipse.titanium.metrics.IMetricEnum;
import org.eclipse.titanium.metrics.risk.BaseRisk;

public class LinearRisk
extends BaseRisk {
    public LinearRisk(IMetricEnum metric) {
        super(metric);
    }

    @Override
    public double getRiskValue(Number value) {
        double risk = 0.0;
        double val = value == null ? 0.0 : value.doubleValue();
        switch (this.method) {
            case NEVER: {
                risk = 1.0 - 1.0 / (val + 1.0);
                break;
            }
            case NO_HIGH: {
                double l1 = this.limits[0].doubleValue();
                if (val >= l1) {
                    risk = 3.0 - 1.0 / (val - l1 + 1.0);
                    break;
                }
                risk = val / l1;
                break;
            }
            case NO_LOW: {
                double l1 = this.limits[0].doubleValue();
                if (val >= l1) {
                    risk = 2.0 - 1.0 / (val - l1 + 1.0);
                    break;
                }
                risk = val / l1;
                break;
            }
            case NO_LOW_HIGH: {
                double l1 = this.limits[0].doubleValue();
                double l2 = this.limits[1].doubleValue();
                risk = val < l1 ? val / l1 : (val >= l2 ? 3.0 - 1.0 / (val - l2 + 1.0) : 1.0 + (val - l1) / (l2 - l1));
            }
        }
        return risk;
    }
}

