/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.spotters.implementation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.ParameterisedSubReference;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ActualParameter;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ActualParameterList;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Altstep;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Function;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Testcase;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameter;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.definitions.IParameterisedAssignment;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Value_ActualParameter;
import org.eclipse.titan.designer.AST.TTCN3.statements.AltGuard;
import org.eclipse.titan.designer.AST.TTCN3.statements.Function_Instance_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.If_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Return_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.SelectCase_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.AST.TTCN3.templates.ParsedActualParameters;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titanium.markers.spotters.BaseCodeSmellSpotter;
import org.eclipse.titanium.markers.spotters.BaseModuleCodeSmellSpotter;
import org.eclipse.titanium.markers.types.CodeSmellType;

public class Lazy
extends BaseModuleCodeSmellSpotter {
    private static final String ERROR_MESSAGE = "The {0} parameter should {1}be @lazy";
    private RelevantFormalParameterCollector formalParameterCollector;
    private boolean haveToContinue;

    public Lazy() {
        super(CodeSmellType.LAZY);
    }

    @Override
    protected void process(IVisitableNode node, BaseCodeSmellSpotter.Problems problems) {
        this.haveToContinue = true;
        this.formalParameterCollector = new RelevantFormalParameterCollector();
        node.accept((ASTVisitor)this.formalParameterCollector);
        RelevantNodeBuilder relevantNodeBuilder = new RelevantNodeBuilder(node);
        node.accept((ASTVisitor)relevantNodeBuilder);
        Set<FormalParameter> shouldBeEvaluated = relevantNodeBuilder.collectRelevantReferences();
        for (FormalParameter formalParameter : this.formalParameterCollector.getItems()) {
            boolean isLazy = formalParameter.getIsLazy();
            String message = null;
            if (shouldBeEvaluated.contains(formalParameter)) {
                if (isLazy) {
                    message = "not ";
                }
            } else if (!isLazy) {
                message = "";
            }
            if (message == null) continue;
            String msg = MessageFormat.format(ERROR_MESSAGE, formalParameter.getIdentifier().getDisplayName(), message);
            problems.report(formalParameter.getLocation(), msg);
        }
    }

    @Override
    public List<Class<? extends IVisitableNode>> getStartNode() {
        ArrayList<Class<? extends IVisitableNode>> ret = new ArrayList<Class<? extends IVisitableNode>>(3);
        ret.add(Def_Altstep.class);
        ret.add(Def_Function.class);
        ret.add(Def_Testcase.class);
        return ret;
    }

    public class RelevantFormalParameterCollector
    extends ASTVisitor {
        private List<FormalParameter> items = new ArrayList<FormalParameter>();

        public int visit(IVisitableNode node) {
            if (node instanceof IParameterisedAssignment) {
                FormalParameterList formalParameterList = ((IParameterisedAssignment)node).getFormalParameterList();
                block3: for (int i = 0; i < formalParameterList.getNofParameters(); ++i) {
                    FormalParameter formalParameter = formalParameterList.getParameterByIndex(i);
                    Assignment.Assignment_type type = formalParameter.getAssignmentType();
                    switch (type) {
                        case A_PAR_VAL: 
                        case A_PAR_VAL_IN: 
                        case A_PAR_TEMP_IN: {
                            this.items.add(formalParameter);
                            continue block3;
                        }
                        default: {
                            continue block3;
                        }
                    }
                }
                return 2;
            }
            return 3;
        }

        public List<FormalParameter> getItems() {
            return this.items;
        }
    }

    public class RelevantNodeBuilder
    extends ASTVisitor {
        private IVisitableNode root;
        private List<RelevantNodeBuilder> nodes;
        private Set<FormalParameter> strictFormalParameters;
        private Set<FormalParameter> referencedFormalParameters;
        private boolean nextFormalParameterIsNotRelevant = false;

        public RelevantNodeBuilder(IVisitableNode node) {
            this.root = node;
            this.referencedFormalParameters = new HashSet<FormalParameter>();
            this.strictFormalParameters = new HashSet<FormalParameter>();
            this.nodes = new ArrayList<RelevantNodeBuilder>();
        }

        public RelevantNodeBuilder(IVisitableNode node, boolean skipNextFormalParameter) {
            this(node);
            this.nextFormalParameterIsNotRelevant = skipNextFormalParameter;
        }

        public int visit(IVisitableNode node) {
            if (this.nextFormalParameterIsNotRelevant) {
                if (node instanceof Expression_Value) {
                    this.nextFormalParameterIsNotRelevant = false;
                } else if (!(node instanceof Value_ActualParameter)) {
                    return 1;
                }
            }
            if ((node instanceof StatementBlock || node instanceof Statement || node instanceof AltGuard) && !node.equals(this.root)) {
                RelevantNodeBuilder statementBlockCollector = new RelevantNodeBuilder(node, this.nextFormalParameterIsNotRelevant);
                if (this.root instanceof If_Statement || this.root instanceof SelectCase_Statement) {
                    statementBlockCollector.strictFormalParameters.addAll(this.strictFormalParameters);
                    this.strictFormalParameters.clear();
                }
                this.nodes.add(statementBlockCollector);
                node.accept((ASTVisitor)statementBlockCollector);
                return 1;
            }
            if (node instanceof Reference) {
                Reference reference = (Reference)node;
                Assignment assignment = reference.getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), false);
                if (assignment instanceof Def_Function) {
                    FormalParameterList formalParameterList = ((Def_Function)assignment).getFormalParameterList();
                    ISubReference subreference = (ISubReference)((Reference)node).getSubreferences().get(0);
                    if (!(subreference instanceof ParameterisedSubReference)) {
                        return 1;
                    }
                    ParameterisedSubReference subref = (ParameterisedSubReference)((Reference)node).getSubreferences().get(0);
                    ParsedActualParameters parsedActualParameters = subref.getParsedParameters();
                    ActualParameterList nonLazyActualParameters = new ActualParameterList();
                    ActualParameterList lazyActualParameters = new ActualParameterList();
                    formalParameterList.collateLazyAndNonLazyActualParameters(CompilationTimeStamp.getBaseTimestamp(), parsedActualParameters, lazyActualParameters, nonLazyActualParameters);
                    if (nonLazyActualParameters.getNofParameters() != 0) {
                        RelevantNodeBuilder statementBlockCollector = new RelevantNodeBuilder(this.root);
                        this.nodes.add(statementBlockCollector);
                        nonLazyActualParameters.accept((ASTVisitor)statementBlockCollector);
                    }
                    int size = lazyActualParameters.getNofParameters();
                    for (int i = 0; i < size; ++i) {
                        ActualParameter lazyActualParameter = lazyActualParameters.getParameter(i);
                        if (!(lazyActualParameter instanceof Value_ActualParameter)) continue;
                        RelevantNodeBuilder statementBlockCollector = new RelevantNodeBuilder(this.root, true);
                        this.nodes.add(statementBlockCollector);
                        lazyActualParameter.accept((ASTVisitor)statementBlockCollector);
                    }
                    return 1;
                }
                if (assignment instanceof FormalParameter) {
                    FormalParameter formalParameter = (FormalParameter)assignment;
                    if (this.nextFormalParameterIsNotRelevant) {
                        return 3;
                    }
                    if (Lazy.this.formalParameterCollector.getItems().contains(formalParameter)) {
                        if (this.root instanceof If_Statement || this.root instanceof SelectCase_Statement) {
                            this.strictFormalParameters.add(formalParameter);
                        } else {
                            this.referencedFormalParameters.add(formalParameter);
                        }
                    }
                }
            }
            return 3;
        }

        public Set<FormalParameter> collectRelevantReferences() {
            HashSet<FormalParameter> shouldBeEvaluated = new HashSet<FormalParameter>();
            if (this.root instanceof Return_Statement) {
                Lazy.this.haveToContinue = false;
                return this.referencedFormalParameters;
            }
            if (this.nodes.size() == 0) {
                return this.referencedFormalParameters;
            }
            HashSet<FormalParameter> tempStricts = new HashSet<FormalParameter>();
            int nodeSize = this.nodes.size();
            for (int index = 0; index < nodeSize; ++index) {
                if (!Lazy.this.haveToContinue) continue;
                tempStricts.addAll(this.nodes.get((int)index).strictFormalParameters);
                Set<FormalParameter> temp = this.nodes.get(index).collectRelevantReferences();
                if (this.root instanceof StatementBlock || this.root instanceof Definition || this.root instanceof AltGuard || this.root instanceof Function_Instance_Statement) {
                    shouldBeEvaluated.addAll(temp);
                    continue;
                }
                if ((this.root instanceof If_Statement || this.root instanceof SelectCase_Statement) && nodeSize == 1) break;
                if (shouldBeEvaluated.size() == 0 && index == 0) {
                    shouldBeEvaluated.addAll(temp);
                    continue;
                }
                shouldBeEvaluated.retainAll(temp);
            }
            shouldBeEvaluated.addAll(tempStricts);
            shouldBeEvaluated.addAll(this.referencedFormalParameters);
            return shouldBeEvaluated;
        }
    }
}

