/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.graph.utils;

import edu.uci.ics.jung.graph.Graph;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.TreeSet;
import org.apache.commons.collections15.Transformer;

public class GraphVizWriter<V, E> {
    public void save(Graph<V, E> g, String filename, Transformer<V, String> labeler, String graphName) throws IOException {
        TreeSet nodes = new TreeSet();
        HashMap successors = new HashMap();
        for (Object source : g.getVertices()) {
            Collection actSuccessors = g.getSuccessors(source);
            TreeSet successorTree = new TreeSet();
            for (Object destination : actSuccessors) {
                successorTree.add(destination);
            }
            nodes.add(source);
            successors.put(source, successorTree);
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "UTF-8"));
        writer.write("digraph \"" + graphName + "\" {\n");
        for (Object from : nodes) {
            Collection actSuccessors = (Collection)successors.get(from);
            for (Object to : actSuccessors) {
                writer.write("\t\"" + (String)labeler.transform(from) + "\" -> \"" + (String)labeler.transform(to) + "\";\n");
            }
            if (g.getPredecessorCount(from) != 0 || !actSuccessors.isEmpty()) continue;
            writer.write("\t\"" + (String)labeler.transform(from) + "\";\n");
        }
        writer.write("}");
        writer.close();
    }
}

