/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.titanium.organize.OrganizeImports;

class OrganizeImportsOp
implements IRunnableWithProgress {
    private final List<IFile> files;

    public OrganizeImportsOp(List<IFile> files) {
        this.files = files;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        HashSet<IProject> projects = new HashSet<IProject>();
        for (IFile f : this.files) {
            projects.add(f.getProject());
        }
        monitor.beginTask("Organize imports", this.files.size() + projects.size() * 20);
        for (IProject project : projects) {
            ProjectSourceParser parser = GlobalParser.getProjectSourceParser((IProject)project);
            WorkspaceJob job = parser.analyzeAll();
            monitor.subTask("Waiting for semantic analysis on project " + project.getName());
            try {
                job.join();
            }
            catch (InterruptedException e) {
                ErrorReporter.logExceptionStackTrace((String)"Error while waiting for the analysis to finish", (Throwable)e);
            }
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            monitor.worked(20);
        }
        CompositeChange compChange = new CompositeChange("Organize imports");
        for (IFile f : this.files) {
            monitor.subTask("Organizing " + f.getName());
            try {
                TextFileChange change = OrganizeImports.organizeImportsChange(f);
                compChange.add((Change)change);
                compChange.perform((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                MultiTextEdit edit = (MultiTextEdit)change.getEdit();
                if (edit != null && edit.getChildrenSize() > 0) {
                    WorkspaceJob job = GlobalParser.getProjectSourceParser((IProject)f.getProject()).reportOutdating(f);
                    try {
                        job.join();
                    }
                    catch (InterruptedException e) {
                        ErrorReporter.logExceptionStackTrace((String)"Error while waiting for the outdating report to finish", (Throwable)e);
                    }
                }
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((String)("Error while organizing file " + f.getName()), (Throwable)e);
            }
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            monitor.worked(1);
        }
        for (IProject project : projects) {
            GlobalParser.getProjectSourceParser((IProject)project).analyzeAll();
        }
        monitor.done();
    }
}

