/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.properties.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.properties.data.BuildLocation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ProjectRemoteBuildPropertyData {
    public static final String QUALIFIER = "org.eclipse.titan.designer.Properties.Project";
    public static final String PARALLEL_COMMAND_EXECUTION = "org.eclipse.titan.designer.parallelCommandExecution";
    public static final String REMOTE_BUILD_HOST_INFO = "org.eclipse.titan.designer.remoteBuildHostInfo";
    public static final String REMOTEBUILDPROPERTIES_XMLNODE = "RemoteBuildProperties";
    public static final String PARALLELCOMMANDEXECUTION_XMLNODE = "ParallelCommandExecution";
    public static final String REMOTEHOSTXMLNODE = "RemoteHost";
    public static final String ACTIVEXMLNODE = "Active";
    public static final String NAMEXMLNODE = "Name";
    public static final String COMMANDXMLNODE = "Command";
    private static final String TRUE = "true";
    private static final String FALSE = "false";

    private ProjectRemoteBuildPropertyData() {
    }

    public static List<String> intelligentSplit(String input, char delimeter, char escape) {
        ArrayList<String> results = new ArrayList<String>();
        if (input == null || input.length() == 0) {
            return results;
        }
        StringBuilder tempResult = new StringBuilder();
        int i = 0;
        while (i < input.length()) {
            char c = input.charAt(i);
            if (escape == c) {
                tempResult.append(input.charAt(i + 1));
                i += 2;
                continue;
            }
            if (delimeter == c) {
                results.add(tempResult.toString());
                tempResult = new StringBuilder();
                ++i;
                continue;
            }
            tempResult.append(c);
            ++i;
        }
        results.add(tempResult.toString());
        return results;
    }

    public static BuildLocation[] getBuildLocations(IProject project) {
        String temp = null;
        try {
            temp = project.getPersistentProperty(new QualifiedName(QUALIFIER, REMOTE_BUILD_HOST_INFO));
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While getting build locations of `" + project.getName() + "'"), (Throwable)e);
        }
        List<String> splittedList = ProjectRemoteBuildPropertyData.intelligentSplit(temp, '#', '\\');
        String[] tempArray = splittedList.toArray(new String[splittedList.size()]);
        BuildLocation[] result = new BuildLocation[tempArray.length];
        for (int i = 0; i < tempArray.length; ++i) {
            result[i] = new BuildLocation(tempArray[i]);
        }
        return result;
    }

    public static void setBuildLocations(IProject project, BuildLocation[] locations) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < locations.length; ++i) {
            if (i != 0) {
                builder.append('#');
            }
            String tempString = locations[i].getPropertyValueRepresentation().toString();
            tempString = tempString.replace("\\", "\\\\");
            builder.append(tempString.replace("#", "\\#"));
        }
        QualifiedName qualifiedName = new QualifiedName(QUALIFIER, REMOTE_BUILD_HOST_INFO);
        String newValue = builder.toString();
        try {
            String oldValue = project.getPersistentProperty(qualifiedName);
            if (newValue != null && !newValue.equals(oldValue)) {
                project.setPersistentProperty(qualifiedName, newValue);
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While setting build locations of `" + project.getName() + "'"), (Throwable)e);
        }
    }

    public static Element saveRemoteBuildProperties(Document document, IProject project) {
        BuildLocation[] locations;
        Element root = null;
        String temp = null;
        try {
            temp = project.getPersistentProperty(new QualifiedName(QUALIFIER, PARALLEL_COMMAND_EXECUTION));
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While reading parallel build property of `" + project.getName() + "'"), (Throwable)e);
        }
        if (temp != null && !"".equals(temp) && !FALSE.equals(temp)) {
            Element parallelExecution = document.createElement(PARALLELCOMMANDEXECUTION_XMLNODE);
            parallelExecution.appendChild(document.createTextNode(temp));
            root = document.createElement(REMOTEBUILDPROPERTIES_XMLNODE);
            root.appendChild(parallelExecution);
        }
        if ((locations = ProjectRemoteBuildPropertyData.getBuildLocations(project)).length == 0) {
            return root;
        }
        for (BuildLocation location : locations) {
            Element remoteHost = document.createElement(REMOTEHOSTXMLNODE);
            Element active = document.createElement(ACTIVEXMLNODE);
            active.appendChild(document.createTextNode(location.getActive() ? TRUE : FALSE));
            remoteHost.appendChild(active);
            Element name = document.createElement(NAMEXMLNODE);
            name.appendChild(document.createTextNode(location.getName()));
            remoteHost.appendChild(name);
            Element command = document.createElement(COMMANDXMLNODE);
            command.appendChild(document.createTextNode(location.getCommand()));
            remoteHost.appendChild(command);
            if (root == null) {
                root = document.createElement(REMOTEBUILDPROPERTIES_XMLNODE);
            }
            root.appendChild(remoteHost);
        }
        return root;
    }

    public static void loadRemoteBuildProperties(Node node, IProject project, Set<IResource> changedResources) {
        NodeList remoteBuildSettingsList = node.getChildNodes();
        String parallelRemoteBuild = FALSE;
        ArrayList<BuildLocation> locations = new ArrayList<BuildLocation>();
        changedResources.add((IResource)project);
        for (int i = 0; i < remoteBuildSettingsList.getLength(); ++i) {
            if (REMOTEHOSTXMLNODE.equals(remoteBuildSettingsList.item(i).getNodeName())) {
                NodeList possibleHostPropertiesList = remoteBuildSettingsList.item(i).getChildNodes();
                String active = null;
                String name = null;
                String command = null;
                for (int j = 0; j < possibleHostPropertiesList.getLength(); ++j) {
                    if (ACTIVEXMLNODE.equals(possibleHostPropertiesList.item(j).getNodeName())) {
                        active = possibleHostPropertiesList.item(j).getTextContent();
                        continue;
                    }
                    if (NAMEXMLNODE.equals(possibleHostPropertiesList.item(j).getNodeName())) {
                        name = possibleHostPropertiesList.item(j).getTextContent();
                        continue;
                    }
                    if (!COMMANDXMLNODE.equals(possibleHostPropertiesList.item(j).getNodeName())) continue;
                    command = possibleHostPropertiesList.item(j).getTextContent();
                }
                if (active == null || name == null || command == null) continue;
                locations.add(new BuildLocation(TRUE.equals(active), name, command));
                continue;
            }
            if (!PARALLELCOMMANDEXECUTION_XMLNODE.equals(remoteBuildSettingsList.item(i).getNodeName())) continue;
            parallelRemoteBuild = remoteBuildSettingsList.item(i).getTextContent();
        }
        ProjectRemoteBuildPropertyData.setBuildLocations(project, locations.toArray(new BuildLocation[locations.size()]));
        QualifiedName qualifiedName = new QualifiedName(QUALIFIER, PARALLEL_COMMAND_EXECUTION);
        String newValue = TRUE.equals(parallelRemoteBuild) ? TRUE : FALSE;
        try {
            String oldValue = project.getPersistentProperty(qualifiedName);
            if (!newValue.equals(oldValue)) {
                project.setPersistentProperty(qualifiedName, newValue);
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While loading parallel build property of `" + project.getName() + "'"), (Throwable)e);
        }
    }

    public static Element copyRemoteBuildProperties(Node sourceNode, Document document, boolean saveDefaultValues) {
        if (sourceNode == null) {
            return null;
        }
        NodeList remoteBuildSettingsList = sourceNode.getChildNodes();
        String parallelRemoteBuild = FALSE;
        ArrayList<BuildLocation> locations = new ArrayList<BuildLocation>();
        for (int i = 0; i < remoteBuildSettingsList.getLength(); ++i) {
            if (REMOTEHOSTXMLNODE.equals(remoteBuildSettingsList.item(i).getNodeName())) {
                NodeList possibleHostPropertiesList = remoteBuildSettingsList.item(i).getChildNodes();
                Object active = null;
                String name = null;
                String command = null;
                for (int j = 0; j < possibleHostPropertiesList.getLength(); ++j) {
                    if (ACTIVEXMLNODE.equals(possibleHostPropertiesList.item(j).getNodeName())) {
                        active = possibleHostPropertiesList.item(j).getTextContent();
                        continue;
                    }
                    if (NAMEXMLNODE.equals(possibleHostPropertiesList.item(j).getNodeName())) {
                        name = possibleHostPropertiesList.item(j).getTextContent();
                        continue;
                    }
                    if (!COMMANDXMLNODE.equals(possibleHostPropertiesList.item(j).getNodeName())) continue;
                    command = possibleHostPropertiesList.item(j).getTextContent();
                }
                if (active == null || name == null || command == null) continue;
                locations.add(new BuildLocation(TRUE.equals(active), name, command));
                continue;
            }
            if (!PARALLELCOMMANDEXECUTION_XMLNODE.equals(remoteBuildSettingsList.item(i).getNodeName())) continue;
            parallelRemoteBuild = remoteBuildSettingsList.item(i).getTextContent();
        }
        Node root = null;
        for (BuildLocation location : locations) {
            Element remoteHost = document.createElement(REMOTEHOSTXMLNODE);
            Element active = document.createElement(ACTIVEXMLNODE);
            active.appendChild(document.createTextNode(location.getActive() ? TRUE : FALSE));
            remoteHost.appendChild(active);
            Element name = document.createElement(NAMEXMLNODE);
            name.appendChild(document.createTextNode(location.getName()));
            remoteHost.appendChild(name);
            Element command = document.createElement(COMMANDXMLNODE);
            command.appendChild(document.createTextNode(location.getCommand()));
            remoteHost.appendChild(command);
            if (root == null) {
                root = document.createElement(REMOTEBUILDPROPERTIES_XMLNODE);
            }
            root.appendChild(remoteHost);
        }
        if (saveDefaultValues || !FALSE.equals(parallelRemoteBuild)) {
            Element command = document.createElement(PARALLELCOMMANDEXECUTION_XMLNODE);
            command.appendChild(document.createTextNode(parallelRemoteBuild));
            if (root == null) {
                root = document.createElement(REMOTEBUILDPROPERTIES_XMLNODE);
            }
            root.appendChild(command);
        }
        return root;
    }

    public static void removeTITANAttributes(IProject project) {
        try {
            project.setPersistentProperty(new QualifiedName(QUALIFIER, PARALLEL_COMMAND_EXECUTION), null);
            project.setPersistentProperty(new QualifiedName(QUALIFIER, REMOTE_BUILD_HOST_INFO), null);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While removing properties of `" + project.getName() + "'"), (Throwable)e);
        }
    }
}

