/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.preferences.pages;

import java.io.File;
import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.product.ProductIdentity;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.core.CompilerVersionInformationCollector;
import org.eclipse.titan.designer.core.ProductIdentityHelper;
import org.eclipse.titan.designer.core.TITANBuilder;
import org.eclipse.titan.designer.core.TITANInstallationValidator;
import org.eclipse.titan.designer.license.License;
import org.eclipse.titan.designer.license.LicenseValidator;
import org.eclipse.titan.designer.preferences.PreferenceConstantValues;
import org.eclipse.titan.designer.preferences.pages.ComboFieldEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public final class TITANPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    static final String DESCRIPTION = "Preferences for TITAN";
    static final String INSTALL_PATH = "TITAN installation path:";
    static final String INSTALL_PATH_TOOLTIP = "The directory TITAN was installed into.\nThis is the same directory which must be set in the $TTCN3_DIR environmental variable in case of using the tools from command line.";
    static final String LICENSE_FILE = "License file :";
    static final String LICENSE_FILE_TOOLTIP = "The path to a valid license file.\nThis is the same file which must be set in the $TTCN3_LICENSE_FILE environmental variable in case of using the tools from command line";
    static final String PROBLEM_WITH_MARKER = "Use markers for build error notification instead of a dialog.";
    static final String DEBUGINFORMATION = "Display debug information.";
    private static final String[][] COMPILER_ERROR_OPTIONS = new String[][]{{"Stay unchanged", "Stay unchanged"}, {"Become outdated", "Become outdated"}, {"Are removed", "Are removed"}};
    private static final String[][] ONTHEFLY_ERROR_OPTIONS = new String[][]{{"Are removed", "Are removed"}, {"Stay", "Stay"}};
    private static final String[][] CONSOLE_ACTION_BEFORE_BUILD = new String[][]{{"Nothing", "Nothing"}, {"Clear", "Clear"}, {"Print delimiter", "Print delimiter"}};
    private static final String LICENSERENEWALTEXT = "<A> Prolong expired license (only for Ericsson employees) </A>";
    private RenewLicense renewLicense = new RenewLicense();
    private DirectoryFieldEditor installPath;
    private FileFieldEditor licenseFile;
    private BooleanFieldEditor reportProgramErrorWithMarker;
    private BooleanFieldEditor treatOnTheFlyErrorsFatalforBuild;
    private IntegerFieldEditor processingUnitsToUse;
    private BooleanFieldEditor displayDebugPreferences;
    private Composite comp;
    private Label titanVersionInformation;
    private Label licenseInfoLabel;
    private Text licenseInfo;
    private Font licenseInfoFont;
    private Link link;
    private ProductIdentity compilerProductNumber;
    private static final String NEWLICENSETEXT = "<A> Order a new license (only for Ericsson employees) </A>";
    private CreateNewLicense createNewLicense = new CreateNewLicense();

    public TITANPreferencePage() {
        super(1);
    }

    public void init(IWorkbench workbench) {
        this.setDescription(DESCRIPTION);
    }

    protected Control createContents(Composite parent) {
        this.comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        this.comp.setLayout((Layout)layout);
        this.comp.setLayoutData((Object)new GridData(4, 4, true, true));
        super.createContents(this.comp);
        String temp = CompilerVersionInformationCollector.getCompilerProductNumber();
        this.compilerProductNumber = ProductIdentityHelper.getProductIdentity(temp, null);
        this.titanVersionInformation = new Label(this.comp, 0);
        this.titanVersionInformation.setText("The version of the compiler used: unknown");
        if (License.isLicenseNeeded()) {
            this.licenseInfoLabel = new Label(this.comp, 0);
            this.licenseInfoLabel.setText("License information:");
            this.licenseInfo = new Text(this.comp, 2826);
            this.licenseInfo.setEditable(false);
            this.licenseInfo.setLayoutData((Object)new GridData(4, 4, true, true));
            this.licenseInfoFont = new Font((Device)this.getShell().getDisplay(), "Courier New", 8, 0);
            this.licenseInfo.setFont(this.licenseInfoFont);
        }
        this.link = new Link(this.comp, 0);
        this.link.setVisible(false);
        this.link.setEnabled(false);
        this.refreshTITANInfo();
        this.refreshLicenseInfo();
        return this.comp;
    }

    private void refreshTITANInfo() {
        Path compilerPath;
        if (this.titanVersionInformation == null) {
            return;
        }
        String tempPath = this.installPath.getStringValue();
        if (tempPath == null || tempPath.length() == 0) {
            return;
        }
        String temp = this.installPath.getStringValue() + CompilerVersionInformationCollector.COMPILER_SUBPATH;
        if ("win32".equals(Platform.getOS())) {
            temp = temp + ".exe";
        }
        if (!(compilerPath = new Path(temp)).toFile().exists()) {
            this.installPath.getTextControl(this.getFieldEditorParent()).setToolTipText("The directory TITAN was installed into.\nThis is the same directory which must be set in the $TTCN3_DIR environmental variable in case of using the tools from command line.\n The compiler was not found on the path `" + compilerPath.toOSString() + "'");
            this.titanVersionInformation.setText("The compiler was not found on the path `" + compilerPath.toOSString() + "'");
            this.setErrorMessage("The compiler was not found on the path `" + compilerPath.toOSString() + "'");
            return;
        }
        String tempCompilerProductNumber = CompilerVersionInformationCollector.checkTemporalLocation(this.installPath.getStringValue());
        if (tempCompilerProductNumber == null) {
            this.installPath.getTextControl(this.getFieldEditorParent()).setToolTipText("The directory TITAN was installed into.\nThis is the same directory which must be set in the $TTCN3_DIR environmental variable in case of using the tools from command line.\n The version of the used compiler could not be determined.");
            this.titanVersionInformation.setText("The version of the compiler used: could not be determined");
            this.setErrorMessage("The version of the compiler used: could not be determined");
            return;
        }
        ProductIdentity versionNumber = ProductIdentityHelper.getProductIdentity(tempCompilerProductNumber, null);
        if (versionNumber == null) {
            this.installPath.getTextControl(this.getFieldEditorParent()).setToolTipText("The directory TITAN was installed into.\nThis is the same directory which must be set in the $TTCN3_DIR environmental variable in case of using the tools from command line.\n The version of the used compiler seems to be invalid/corrupted or there were problems while processing it.");
            this.titanVersionInformation.setText("The version of the compiler used: seems to be invalid/corrupted or there were problems while processing it");
            this.setErrorMessage("The version of the compiler used: seems to be invalid/corrupted or there were problems while processing it");
            return;
        }
        this.installPath.getTextControl(this.getFieldEditorParent()).setToolTipText("The directory TITAN was installed into.\nThis is the same directory which must be set in the $TTCN3_DIR environmental variable in case of using the tools from command line.\n The version of the used compiler is: " + versionNumber);
        this.titanVersionInformation.setText("The version of the compiler used: " + versionNumber);
    }

    public void refreshLicenseInfo() {
        if (!License.isLicenseNeeded()) {
            return;
        }
        if (this.licenseFile == null || this.licenseInfo == null) {
            this.createLinkNewLicense();
            return;
        }
        String fileName = this.licenseFile.getStringValue();
        if (fileName == null || fileName.length() == 0) {
            this.licenseInfo.setText("No license file provided");
            this.setErrorMessage("No license file provided");
            this.createLinkNewLicense();
            return;
        }
        if (!this.licenseFile.isValid()) {
            this.licenseInfo.setText("The license file seems to be corrupted, or not available on the provided path");
            this.setErrorMessage("The license file seems to be corrupted, or not available on the provided path");
            this.createLinkNewLicense();
            return;
        }
        File realFile = new File(fileName);
        if (!realFile.exists()) {
            this.licenseInfo.setText("File not found");
            this.setErrorMessage("File not found");
            this.createLinkNewLicense();
            return;
        }
        if (!realFile.isFile()) {
            this.licenseInfo.setText("A file was expected as license file");
            this.setErrorMessage("A file was expected as license file");
            this.createLinkNewLicense();
            return;
        }
        License license = new License(fileName);
        license.process();
        if (!license.isValid()) {
            this.licenseInfo.setText("The license file is invalid");
            this.setErrorMessage("The license file is invalid");
            this.createLinkNewLicense();
            return;
        }
        long validUntil = license.getValidUntil().getTime();
        long now = System.currentTimeMillis();
        StringBuilder builder = new StringBuilder();
        if (now > validUntil) {
            builder.append("Your TITAN license has expired\n\n");
            this.setErrorMessage("Your TITAN license has expired");
            this.createLinkLicenseRenewal(license.getUniqueID());
        } else {
            long difference = (validUntil - now) / 86400000L;
            if (difference == 1L) {
                builder.append("Your TITAN license will expire today\n\n");
                this.createLinkLicenseRenewal(license.getUniqueID());
            } else if (difference < 14L) {
                builder.append("Please note that your TITAN license will expire in ").append(difference).append(" days.\n\n");
                this.createLinkLicenseRenewal(license.getUniqueID());
            } else if (this.link != null) {
                this.link.setVisible(false);
                this.link.setEnabled(false);
                this.link.setText("");
            }
        }
        builder.append(license.toString());
        this.licenseInfo.setText(builder.toString());
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        this.installPath = new DirectoryFieldEditor("org.eclipse.titan.designer.TTCN3_INSTALL_DIR", INSTALL_PATH, parent);
        this.installPath.getTextControl(parent).setToolTipText(INSTALL_PATH_TOOLTIP);
        this.installPath.getTextControl(parent).addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TITANPreferencePage.this.setErrorMessage(null);
                CompilerVersionInformationCollector.clearStoredInformation();
                TITANPreferencePage.this.refreshTITANInfo();
                TITANPreferencePage.this.refreshLicenseInfo();
            }
        });
        this.addField((FieldEditor)this.installPath);
        parent = this.getFieldEditorParent();
        if (License.isLicenseNeeded()) {
            this.licenseFile = new FileFieldEditor("org.eclipse.titan.designer.LICENSE_FILE", LICENSE_FILE, parent);
            this.licenseFile.getTextControl(parent).setToolTipText(LICENSE_FILE_TOOLTIP);
            this.licenseFile.getTextControl(parent).addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    TITANPreferencePage.this.setErrorMessage(null);
                    CompilerVersionInformationCollector.clearStoredInformation();
                    TITANPreferencePage.this.refreshTITANInfo();
                    TITANPreferencePage.this.refreshLicenseInfo();
                }
            });
            this.addField((FieldEditor)this.licenseFile);
        }
        this.reportProgramErrorWithMarker = new BooleanFieldEditor("org.eclipse.titan.designer.reportProgramErrorWithMarker", PROBLEM_WITH_MARKER, this.getFieldEditorParent());
        this.addField((FieldEditor)this.reportProgramErrorWithMarker);
        this.treatOnTheFlyErrorsFatalforBuild = new BooleanFieldEditor("org.eclipse.titan.designer.treatOnTheFlyErrorsasFatalForBuild", "Treat on-the-fly errors as fatal for build (the project will not build).", this.getFieldEditorParent());
        this.addField((FieldEditor)this.treatOnTheFlyErrorsFatalforBuild);
        ComboFieldEditor comboedit = new ComboFieldEditor("org.eclipse.titan.designer.compilerMarkersAfterAnalyzation", "When On-the-Fly analyzation ends the compiler markers:", COMPILER_ERROR_OPTIONS, this.getFieldEditorParent());
        Label text = comboedit.getLabelControl(this.getFieldEditorParent());
        text.setToolTipText("Keeping the compiler markers can be good for consistency, but might lead to outdated error reports.");
        this.addField(comboedit);
        ComboFieldEditor comboedit2 = new ComboFieldEditor("org.eclipse.titan.designer.ontheflyMarkersAfterCompiler", "When the compiler runs the on-the-fly markers:", ONTHEFLY_ERROR_OPTIONS, this.getFieldEditorParent());
        Label text2 = comboedit2.getLabelControl(this.getFieldEditorParent());
        text2.setToolTipText("Keeping the on-the-fly marker is good for performance, but right now the compiler is more reliable.");
        this.addField(comboedit2);
        this.processingUnitsToUse = new IntegerFieldEditor("org.eclipse.titan.designer.processingUnitsToUse", "Maximum number of build processes to use:", this.getFieldEditorParent());
        this.processingUnitsToUse.getLabelControl(this.getFieldEditorParent()).setToolTipText("Maximum number of processors available right now: " + PreferenceConstantValues.AVAILABLEPROCESSORS);
        this.processingUnitsToUse.setValidRange(1, PreferenceConstantValues.AVAILABLEPROCESSORS + 1);
        this.addField((FieldEditor)this.processingUnitsToUse);
        this.displayDebugPreferences = new BooleanFieldEditor("org.eclipse.titan.designer.debug.preferencePage.enabled", "Display debug preferences", this.getFieldEditorParent());
        this.addField((FieldEditor)this.displayDebugPreferences);
        ComboFieldEditor comboedit3 = new ComboFieldEditor("org.eclipse.titan.designer.consoleActionBeforeBuild", "Action on the console before build:", CONSOLE_ACTION_BEFORE_BUILD, this.getFieldEditorParent());
        Label text3 = comboedit3.getLabelControl(this.getFieldEditorParent());
        text3.setToolTipText("Select what to do in the TITANConsole before starting the build to easier find the starting point of the actual build");
        this.addField(comboedit3);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    public void dispose() {
        this.installPath.dispose();
        if (this.licenseFile != null) {
            this.licenseFile.dispose();
        }
        this.reportProgramErrorWithMarker.dispose();
        this.treatOnTheFlyErrorsFatalforBuild.dispose();
        this.processingUnitsToUse.dispose();
        this.displayDebugPreferences.dispose();
        this.comp.dispose();
        if (this.licenseInfoLabel != null) {
            this.licenseInfoLabel.dispose();
        }
        if (this.licenseInfo != null) {
            this.licenseInfo.dispose();
        }
        if (this.licenseInfoFont != null) {
            this.licenseInfoFont.dispose();
        }
        if (this.link != null) {
            this.link.dispose();
        }
        super.dispose();
    }

    public boolean performOk() {
        boolean result = super.performOk();
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode("org.eclipse.titan.designer");
        if (node != null) {
            try {
                node.flush();
            }
            catch (Exception e) {
                ErrorReporter.logExceptionStackTrace((Exception)e);
            }
        }
        CompilerVersionInformationCollector.clearStoredInformation();
        String temp = CompilerVersionInformationCollector.getCompilerProductNumber();
        ProductIdentity finalVersion = ProductIdentityHelper.getProductIdentity(temp, null);
        if (this.compilerProductNumber != null && this.compilerProductNumber.compareTo(finalVersion) != 0) {
            IProject[] projects;
            ErrorReporter.parallelWarningDisplayInMessageDialog((String)"The compiler version has changed", (String)"All projects are cleaned, so that files generated by the old compiler shall not corrupt further builds.\nThis might take some time.");
            this.compilerProductNumber = finalVersion;
            for (IProject project : projects = ResourcesPlugin.getWorkspace().getRoot().getProjects()) {
                if (!project.isAccessible() || !TITANBuilder.isBuilderEnabled(project)) continue;
                TITANBuilder.cleanProjectForRebuild(project, false);
            }
        }
        TITANInstallationValidator.clear();
        LicenseValidator.clear();
        return result;
    }

    private void createLinkNewLicense() {
        if (this.link == null || NEWLICENSETEXT.equals(this.link.getText())) {
            return;
        }
        this.link.setText(NEWLICENSETEXT);
        this.link.removeSelectionListener((SelectionListener)this.renewLicense);
        this.link.addSelectionListener((SelectionListener)this.createNewLicense);
        this.link.setVisible(true);
        this.link.setEnabled(true);
        this.comp.layout();
    }

    private void createLinkLicenseRenewal(int licenseID) {
        if (this.link == null || LICENSERENEWALTEXT.equals(this.link.getText())) {
            return;
        }
        this.link.setText(LICENSERENEWALTEXT);
        this.link.removeSelectionListener((SelectionListener)this.createNewLicense);
        this.renewLicense.setUniqueID(licenseID);
        this.link.addSelectionListener((SelectionListener)this.renewLicense);
        this.link.setVisible(true);
        this.link.setEnabled(true);
        this.comp.layout();
    }

    private void openUrl(String url) {
        try {
            IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
            support.getExternalBrowser().openURL(new URL(url));
        }
        catch (Exception e) {
            ErrorReporter.logError((String)("Could not open URL in an external browser [" + url + "]"));
        }
    }

    static {
        Activator activator = Activator.getDefault();
        if (activator != null) {
            activator.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    String property = event.getProperty();
                    if (!"org.eclipse.titan.designer.debug.preferencePage.enabled".equals(property)) {
                        return;
                    }
                    IPreferencesService prefService = Platform.getPreferencesService();
                    boolean enable = prefService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.debug.preferencePage.enabled", false, null);
                    Activator.switchActivity("org.eclipse.titan.designer.activities.debug", enable);
                    if (!PlatformUI.isWorkbenchRunning()) {
                        return;
                    }
                    final IWorkbench wb = PlatformUI.getWorkbench();
                    if (wb == null) {
                        return;
                    }
                    wb.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Shell active = wb.getDisplay().getActiveShell();
                            if (active == null) {
                                return;
                            }
                            Object o = active.getData();
                            if (o instanceof PreferenceDialog) {
                                PreferenceDialog d = (PreferenceDialog)o;
                                d.getTreeViewer().refresh();
                            }
                        }
                    });
                }
            });
        }
    }

    private class RenewLicense
    extends SelectionAdapter {
        private int uniqueID;

        private RenewLicense() {
        }

        public void setUniqueID(int licenseID) {
            this.uniqueID = licenseID;
        }

        public void widgetSelected(SelectionEvent e) {
            TITANPreferencePage.this.openUrl("https://tcc-licorder.rnd.ki.sw.ericsson.se/order_form.php?type=ericsson");
        }
    }

    private class CreateNewLicense
    extends SelectionAdapter {
        private CreateNewLicense() {
        }

        public void widgetSelected(SelectionEvent e) {
            TITANPreferencePage.this.openUrl("https://tcc-licorder.rnd.ki.sw.ericsson.se/order_form.php?type=ericsson");
        }
    }
}

