/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.preferences.pages;

import java.util.List;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.titan.designer.commonFilters.ResourceExclusionHelper;
import org.eclipse.titan.designer.preferences.pages.RegexpEntryDialog;

public class ExcludeRegexpEditor
extends FieldEditor {
    private org.eclipse.swt.widgets.List list;
    private Composite buttonBox;
    private Button addButton;
    private Button editButton;
    private Button copyButton;
    private Button removeButton;
    private SelectionListener selectionListener;

    public ExcludeRegexpEditor(String name, String labelText, Composite parent) {
        this.init(name, labelText);
        this.createControl(parent);
    }

    private void addPressed() {
        this.setPresentsDefaultValue(false);
        String input = this.getNewInputObject();
        if (input != null) {
            int index = this.list.getSelectionIndex();
            if (index >= 0) {
                this.list.add(input, index + 1);
            } else {
                this.list.add(input);
            }
            this.selectionChanged();
        }
    }

    private void editPressed() {
        this.setPresentsDefaultValue(false);
        int index = this.list.getSelectionIndex();
        if (index >= 0) {
            String input = this.list.getItem(index);
            String output = this.getEditInputObject(input);
            this.list.setItem(index, output);
            this.selectionChanged();
        }
    }

    private void copyPressed() {
        this.setPresentsDefaultValue(false);
        int index = this.list.getSelectionIndex();
        if (index >= 0) {
            this.list.add(this.list.getItem(index));
        }
        this.selectionChanged();
    }

    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
        ((GridData)this.list.getLayoutData()).horizontalSpan = numColumns - 1;
    }

    private void createButtons(Composite box) {
        this.addButton = this.createPushButton(box, "New...");
        this.editButton = this.createPushButton(box, "Edit");
        this.copyButton = this.createPushButton(box, "Copy");
        this.removeButton = this.createPushButton(box, "Remove");
    }

    private Button createPushButton(Composite parent, String name) {
        Button button = new Button(parent, 8);
        button.setText(name);
        button.setFont(parent.getFont());
        GridData data = new GridData(768);
        int widthHint = this.convertHorizontalDLUsToPixels((Control)button, 61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
        button.addSelectionListener(this.getSelectionListener());
        return button;
    }

    public void createSelectionListener() {
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Widget widget = event.widget;
                if (widget == ExcludeRegexpEditor.this.addButton) {
                    ExcludeRegexpEditor.this.addPressed();
                } else if (widget == ExcludeRegexpEditor.this.removeButton) {
                    ExcludeRegexpEditor.this.removePressed();
                } else if (widget == ExcludeRegexpEditor.this.editButton) {
                    ExcludeRegexpEditor.this.editPressed();
                } else if (widget == ExcludeRegexpEditor.this.copyButton) {
                    ExcludeRegexpEditor.this.copyPressed();
                } else if (widget == ExcludeRegexpEditor.this.list) {
                    ExcludeRegexpEditor.this.selectionChanged();
                }
            }
        };
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        control.setLayoutData((Object)gd);
        this.list = this.getListControl(parent);
        gd = new GridData(768);
        gd.verticalAlignment = 4;
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = true;
        this.list.setLayoutData((Object)gd);
        this.buttonBox = this.getButtonBoxControl(parent);
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.buttonBox.setLayoutData((Object)gd);
    }

    protected void doLoad() {
        if (this.list != null) {
            String s = this.getPreferenceStore().getString(this.getPreferenceName());
            String[] array = this.parseString(s);
            for (int i = 0; i < array.length; ++i) {
                this.list.add(array[i]);
            }
        }
    }

    protected void doLoadDefault() {
        if (this.list != null) {
            this.list.removeAll();
            String s = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
            String[] array = this.parseString(s);
            for (int i = 0; i < array.length; ++i) {
                this.list.add(array[i]);
            }
        }
    }

    protected void doStore() {
        String newValue = this.createList(this.list.getItems());
        if (newValue != null) {
            String oldValue = this.getPreferenceStore().getString(this.getPreferenceName());
            this.getPreferenceStore().setValue(this.getPreferenceName(), newValue);
            this.fireValueChanged("field_editor_value", oldValue, newValue);
        }
    }

    public Composite getButtonBoxControl(Composite parent) {
        if (this.buttonBox == null) {
            this.buttonBox = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            this.buttonBox.setLayout((Layout)layout);
            this.createButtons(this.buttonBox);
            this.buttonBox.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    ExcludeRegexpEditor.this.addButton = null;
                    ExcludeRegexpEditor.this.removeButton = null;
                    ExcludeRegexpEditor.this.editButton = null;
                    ExcludeRegexpEditor.this.copyButton = null;
                    ExcludeRegexpEditor.this.buttonBox = null;
                }
            });
        } else {
            this.checkParent((Control)this.buttonBox, parent);
        }
        this.selectionChanged();
        return this.buttonBox;
    }

    public org.eclipse.swt.widgets.List getListControl(Composite parent) {
        if (this.list == null) {
            this.list = new org.eclipse.swt.widgets.List(parent, 2820);
            this.list.setFont(parent.getFont());
            this.list.addSelectionListener(this.getSelectionListener());
            this.list.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    ExcludeRegexpEditor.this.list = null;
                }
            });
        } else {
            this.checkParent((Control)this.list, parent);
        }
        return this.list;
    }

    public int getNumberOfControls() {
        return 2;
    }

    private SelectionListener getSelectionListener() {
        if (this.selectionListener == null) {
            this.createSelectionListener();
        }
        return this.selectionListener;
    }

    protected Shell getShell() {
        if (this.addButton == null) {
            return null;
        }
        return this.addButton.getShell();
    }

    private void removePressed() {
        this.setPresentsDefaultValue(false);
        int index = this.list.getSelectionIndex();
        if (index >= 0) {
            this.list.remove(index);
            this.selectionChanged();
        }
    }

    protected void selectionChanged() {
        int index = this.list.getSelectionIndex();
        int size = this.list.getItemCount();
        this.removeButton.setEnabled(index >= 0);
        this.editButton.setEnabled(size >= 1 && index >= 0);
        this.copyButton.setEnabled(size >= 1 && index >= 0 && index < size - 1);
    }

    public void setFocus() {
        if (this.list != null) {
            this.list.setFocus();
        }
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.getListControl(parent).setEnabled(enabled);
        this.addButton.setEnabled(enabled);
        this.removeButton.setEnabled(enabled);
        this.editButton.setEnabled(enabled);
        this.copyButton.setEnabled(enabled);
    }

    protected String createList(String[] items) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < items.length; ++i) {
            String item = items[i];
            if (i != 0) {
                builder.append('#');
            }
            builder.append(item.replace("#", "\\#"));
        }
        return builder.toString();
    }

    protected String getNewInputObject() {
        RegexpEntryDialog dialog = new RegexpEntryDialog(this.getShell());
        if (dialog.open() == 0) {
            return dialog.getEntry();
        }
        return null;
    }

    protected String getEditInputObject(String original) {
        RegexpEntryDialog dialog = new RegexpEntryDialog(this.getShell());
        dialog.setEntry(original);
        if (dialog.open() == 0) {
            return dialog.getEntry();
        }
        return original;
    }

    protected String[] parseString(String stringList) {
        List<String> splittedList = ResourceExclusionHelper.intelligentSplit(stringList, '#', '\\');
        return splittedList.toArray(new String[splittedList.size()]);
    }
}

