/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.ttcnppeditor.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.commonFilters.ResourceExclusionHelper;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;
import org.eclipse.titan.designer.core.TITANNature;
import org.eclipse.titan.designer.declarationsearch.Declaration;
import org.eclipse.titan.designer.declarationsearch.IdentifierFinderVisitor;
import org.eclipse.titan.designer.editors.ttcnppeditor.TTCNPPEditor;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public final class OpenDeclaration
extends AbstractHandler
implements IEditorActionDelegate {
    public static final String FILENOTIDENTIFIABLE = "The file related to the editor could not be identified";
    public static final String NOTTTCN3DECLARATION = "Current text selection does not resolve to a TTCN3 declaration";
    public static final String TTCNPPEDITORNOTFOUND = "The TTCNPP editor could not be found";
    private IEditorPart targetEditor = null;
    private ISelection selection = TextSelection.emptySelection();

    public void run(IAction action) {
        this.doOpenDeclaration();
    }

    private void selectAndRevealDeclaration(Location location) {
        IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(location.getFile().getName());
        if (desc == null) {
            this.targetEditor.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage(TTCNPPEDITORNOTFOUND);
            return;
        }
        try {
            IWorkbenchPage page = this.targetEditor.getSite().getPage();
            IEditorPart editorPart = page.openEditor((IEditorInput)new FileEditorInput((IFile)location.getFile()), desc.getId());
            if (editorPart != null && editorPart instanceof AbstractTextEditor) {
                ((AbstractTextEditor)editorPart).selectAndReveal(location.getOffset(), location.getEndOffset() - location.getOffset());
            }
        }
        catch (PartInitException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.targetEditor = targetEditor;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.targetEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        this.doOpenDeclaration();
        return null;
    }

    private final void doOpenDeclaration() {
        int offset;
        if (this.targetEditor == null || !(this.targetEditor instanceof TTCNPPEditor)) {
            return;
        }
        this.targetEditor.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage(null);
        IFile file = (IFile)this.targetEditor.getEditorInput().getAdapter(IFile.class);
        if (file == null) {
            this.targetEditor.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage(FILENOTIDENTIFIABLE);
            return;
        }
        if (!TITANNature.hasTITANNature(file.getProject())) {
            this.targetEditor.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage("The project containing the selected file does not have the TITAN nature among its natures");
            return;
        }
        if (ResourceExclusionHelper.isExcluded((IResource)file)) {
            MessageDialog.openError(null, (String)"Open Declaration does not work within excluded resources", (String)"This module is excluded from build. To use the Open Declaration feature please click on the 'Toggle exclude from build state' in the context menu of the Project Explorer. ");
            return;
        }
        IPreferencesService prefs = Platform.getPreferencesService();
        boolean reportDebugInformation = prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", true, null);
        if (!this.selection.isEmpty() && this.selection instanceof TextSelection && !"".equals(((TextSelection)this.selection).getText())) {
            if (reportDebugInformation) {
                TITANDebugConsole.println("text selected: " + ((TextSelection)this.selection).getText());
            }
            TextSelection tSelection = (TextSelection)this.selection;
            offset = tSelection.getOffset() + tSelection.getLength();
        } else {
            offset = ((TTCNPPEditor)this.targetEditor).getCarretOffset();
        }
        ProjectSourceParser projectSourceParser = GlobalParser.getProjectSourceParser(file.getProject());
        Module module = projectSourceParser.containedModule(file);
        if (module == null) {
            if (reportDebugInformation) {
                TITANDebugConsole.println("Can not find the module.");
            }
            return;
        }
        IdentifierFinderVisitor visitor = new IdentifierFinderVisitor(offset);
        module.accept(visitor);
        Declaration decl = visitor.getReferencedDeclaration();
        if (decl == null) {
            if (reportDebugInformation) {
                TITANDebugConsole.println("No visible elements found");
            }
            return;
        }
        this.selectAndRevealDeclaration(decl.getIdentifier().getLocation());
    }
}

