/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values.expressions;

import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Real_Value;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class UnaryMinusExpression
extends Expression_Value {
    private static final String OPERANDERROR = "The operand of the `unary -' operation should be an integer or float value";
    private final Value value;

    public UnaryMinusExpression(Value value) {
        this.value = value;
        if (value != null) {
            value.setFullNameParent(this);
        }
    }

    @Override
    public Expression_Value.Operation_type getOperationType() {
        return Expression_Value.Operation_type.UNARYMINUS_OPERATION;
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder();
        builder.append("-(").append(this.value.createStringRepresentation()).append(')');
        return builder.toString();
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.value != null) {
            this.value.setMyScope(scope);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.value == child) {
            return builder.append(".<operand>");
        }
        return builder;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        if (this.value == null) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        if (this.value.getIsErroneous(timestamp)) {
            this.setIsErroneous(true);
            return IType.Type_type.TYPE_UNDEFINED;
        }
        this.value.setLoweridToReference(timestamp);
        IType.Type_type tempType = this.value.getExpressionReturntype(timestamp, expectedValue);
        this.getValueRefdLast(timestamp, expectedValue, null);
        switch (tempType) {
            case TYPE_INTEGER: 
            case TYPE_REAL: {
                return tempType;
            }
            case TYPE_UNDEFINED: {
                return tempType;
            }
        }
        this.setIsErroneous(true);
        return IType.Type_type.TYPE_UNDEFINED;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.value == null) {
            return true;
        }
        return this.value.isUnfoldable(timestamp, expectedValue, referenceChain);
    }

    private void checkExpressionOperands(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.value == null) {
            return;
        }
        this.value.setLoweridToReference(timestamp);
        IType.Type_type tempType = this.value.getExpressionReturntype(timestamp, expectedValue);
        switch (tempType) {
            case TYPE_INTEGER: 
            case TYPE_REAL: {
                this.value.getValueRefdLast(timestamp, expectedValue, referenceChain);
                return;
            }
            case TYPE_UNDEFINED: {
                this.setIsErroneous(true);
                return;
            }
        }
        if (!this.isErroneous) {
            this.location.reportSemanticError(OPERANDERROR);
            this.setIsErroneous(true);
        }
    }

    @Override
    public IValue evaluateValue(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return this.lastValue;
        }
        this.isErroneous = false;
        this.lastTimeChecked = timestamp;
        this.lastValue = this;
        if (this.value == null) {
            return this.lastValue;
        }
        this.checkExpressionOperands(timestamp, expectedValue, referenceChain);
        if (this.getIsErroneous(timestamp) || this.isUnfoldable(timestamp, referenceChain)) {
            return this.lastValue;
        }
        IValue last = this.value.getValueRefdLast(timestamp, referenceChain);
        if (last.getIsErroneous(timestamp)) {
            this.setIsErroneous(true);
            return this.lastValue;
        }
        switch (last.getValuetype()) {
            case INTEGER_VALUE: {
                this.lastValue = ((Integer_Value)last).negate();
                this.lastValue.copyGeneralProperties(this);
                break;
            }
            case REAL_VALUE: {
                double tempFloat = ((Real_Value)last).getValue();
                this.lastValue = new Real_Value(-1.0 * tempFloat);
                this.lastValue.copyGeneralProperties(this);
                break;
            }
            default: {
                this.setIsErroneous(true);
            }
        }
        return this.lastValue;
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (referenceChain.add(this) && this.value != null) {
            referenceChain.markState();
            this.value.checkRecursions(timestamp, referenceChain);
            referenceChain.previousState();
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.value != null) {
            this.value.updateSyntax(reparser, false);
            reparser.updateLocation(this.value.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.value == null) {
            return;
        }
        this.value.findReferences(referenceFinder, foundIdentifiers);
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return this.value == null || this.value.accept(v);
    }
}

