/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.values.ObjectIdentifierComponent;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class ObjectIdentifier_Value
extends Value {
    private final List<ObjectIdentifierComponent> objectIdComponents = new ArrayList<ObjectIdentifierComponent>();

    @Override
    public IValue.Value_type getValuetype() {
        return IValue.Value_type.OBJECTID_VALUE;
    }

    public void addObjectIdComponent(ObjectIdentifierComponent component) {
        if (component == null) {
            return;
        }
        this.objectIdComponents.add(component);
        component.setFullNameParent(this);
        component.setMyScope(this.myScope);
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        int size = this.objectIdComponents.size();
        for (int i = 0; i < size; ++i) {
            ObjectIdentifierComponent component = this.objectIdComponents.get(i);
            if (component != child) continue;
            return builder.append(".").append(i + 1);
        }
        return builder;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        return IType.Type_type.TYPE_OBJECTID;
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder();
        if (!this.isAsn()) {
            builder.append("objid ");
        }
        builder.append('{');
        int size = this.objectIdComponents.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                builder.append(' ');
            }
            builder.append(this.objectIdComponents.get(i).createStringRepresentation());
        }
        builder.append('}');
        return builder.toString();
    }

    public int getNofComponents() {
        return this.objectIdComponents.size();
    }

    public void getOidComponents(List<Integer> components) {
        int size = this.objectIdComponents.size();
        for (int i = 0; i < size; ++i) {
            this.objectIdComponents.get(i).getOidComponents(components);
        }
    }

    @Override
    public IValue getReferencedSubValue(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, IReferenceChain refChain) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (this.getIsErroneous(timestamp) || subreferences.size() <= actualSubReference) {
            return this;
        }
        IType type = this.myGovernor.getTypeRefdLast(timestamp);
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid array element reference: type `{0}'' can not be indexed", type.getTypename()));
                return null;
            }
            case fieldSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((FieldSubReference)subreference).getId().getDisplayName(), type.getTypename()));
                return null;
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError("Invalid reference: internal parameterisation is not supported");
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        return true;
    }

    public void checkOID(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (this.objectIdComponents.isEmpty()) {
            return;
        }
        if (!referenceChain.add(this)) {
            return;
        }
        ObjectIdentifierComponent.oidState_type state = ObjectIdentifierComponent.oidState_type.START;
        int size = this.objectIdComponents.size();
        for (int i = 0; i < size; ++i) {
            referenceChain.markState();
            state = this.objectIdComponents.get(i).checkOID(timestamp, referenceChain, this, state);
            referenceChain.previousState();
        }
        if (!ObjectIdentifierComponent.oidState_type.LATER.equals((Object)state) && !ObjectIdentifierComponent.oidState_type.ITU_REC.equals((Object)state)) {
            this.getLocation().reportSemanticError("An OBJECT IDENTIFIER value must have at least two components");
        }
    }

    @Override
    public boolean evaluateIsvalue(boolean fromSequence) {
        return true;
    }

    @Override
    public boolean checkEquality(CompilationTimeStamp timestamp, IValue other) {
        ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        IValue last = other.getValueRefdLast(timestamp, referenceChain);
        referenceChain.release();
        if (!IValue.Value_type.OBJECTID_VALUE.equals((Object)last.getValuetype())) {
            return false;
        }
        ObjectIdentifier_Value otherObjid = (ObjectIdentifier_Value)last;
        if (this.objectIdComponents.size() != otherObjid.objectIdComponents.size()) {
            return false;
        }
        int size = this.objectIdComponents.size();
        for (int i = 0; i < size; ++i) {
            if (this.objectIdComponents.get(i) == otherObjid.objectIdComponents.get(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        int size = this.objectIdComponents.size();
        for (int i = 0; i < size; ++i) {
            ObjectIdentifierComponent component = this.objectIdComponents.get(i);
            component.updateSyntax(reparser, false);
            reparser.updateLocation(component.getLocation());
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.objectIdComponents != null) {
            for (ObjectIdentifierComponent c : this.objectIdComponents) {
                if (c.accept(v)) continue;
                return false;
            }
        }
        return true;
    }
}

