/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.MarkerHandler;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.IAppendableSyntax;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.TTCN3Scope;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Testcase;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Var;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Var_Template;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameter;
import org.eclipse.titan.designer.AST.TTCN3.statements.AltGuards;
import org.eclipse.titan.designer.AST.TTCN3.statements.Definition_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.DoWhile_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Goto_statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Label_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock_Statement;
import org.eclipse.titan.designer.AST.TTCN3.types.Component_Type;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.SkeletonTemplateProposal;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3CodeSkeletons;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3Keywords;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ITTCN3ReparseBase;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;
import org.eclipse.titan.designer.parsers.ttcn3parser.Ttcn3Reparser;

public final class StatementBlock
extends TTCN3Scope
implements ILocateableNode,
IIncrementallyUpdateable {
    private static final String FULLNAMEPART = ".statement_";
    private static final String INFINITELOOP = "Inifinite loop detected: the program can not escape from this goto statement";
    public static final String HIDINGSCOPEELEMENT = "Definition with identifier `{0}'' is not unique in the scope hierarchy";
    public static final String HIDDENSCOPEELEMENT = "Previous definition with identifier `{0}'' in higher scope unit is here";
    public static final String HIDINGMODULEIDENTIFIER = "Definition with name `{0}'' hides a module identifier";
    private static final String NEVER_REACH = "Control never reaches this statement";
    private static final String UNUSEDLABEL = "Label `{0}'' is defined, but not used";
    private static final String DUPLICATEDLABELFIRST = "Previous definition of label `{0}'' is here";
    private static final String DUPLICATELABELAGAIN = "Duplicated label `{0}''";
    private static final String EMPTY_STATEMENT_BLOCK = "Empty statement block";
    private static final String TOOMANYSTATEMENTS = "More than {0} statements in a single statementblock";
    private Location location = NULL_Location.INSTANCE;
    private final List<Statement> statements;
    private Map<String, Definition> definitionMap;
    private Map<String, Label_Statement> labelMap;
    private StatementBlock myStatementBlock;
    private int myStatementBlockIndex;
    private Definition myDefinition;
    private CompilationTimeStamp lastTimeChecked;
    private boolean ownerIsLoop;
    private boolean ownerIsAltguard;
    private ReturnStatus_type returnStatus;
    private List<FakeReference> referencesGoingOut = new ArrayList<FakeReference>();
    private boolean freed = false;
    private static final Comparator<Statement> STATEMENT_INSERTION_COMPARATOR = new Comparator<Statement>(){

        @Override
        public int compare(Statement o1, Statement o2) {
            return o1.getLocation().getOffset() - o2.getLocation().getOffset();
        }
    };
    protected static boolean minimiseMemoryUsage;
    private static String reportEmptyStatementBlock;
    private static String reportTooManyStatements;
    private static int reportTooManyStatementsSize;

    public StatementBlock() {
        this.scopeName = "statementblock";
        this.statements = new ArrayList<Statement>();
        this.ownerIsLoop = false;
        this.ownerIsAltguard = false;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        int size = this.statements.size();
        for (int i = 0; i < size; ++i) {
            if (this.statements.get(i) != child) continue;
            return builder.append(FULLNAMEPART).append(Integer.toString(i + 1));
        }
        return builder;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    public Definition getMyDefinition() {
        return this.myDefinition;
    }

    public void setMyDefinition(Definition definition) {
        this.myDefinition = definition;
        int size = this.statements.size();
        for (int i = 0; i < size; ++i) {
            this.statements.get(i).setMyDefinition(definition);
        }
    }

    public void setMyScope(Scope scope) {
        this.setParentScope(scope);
        if (this.location != null) {
            scope.addSubScope(this.location, this);
        }
        int size = this.statements.size();
        for (int i = 0; i < size; ++i) {
            this.statements.get(i).setMyScope(this);
        }
    }

    public void setOwnerIsLoop() {
        this.ownerIsLoop = true;
    }

    public void setOwnerIsAltguard() {
        this.ownerIsAltguard = true;
    }

    public void addStatement(Statement statement) {
        this.addStatement(statement, true);
    }

    public void addStatement(Statement statement, boolean append) {
        if (statement != null) {
            if (append) {
                this.statements.add(statement);
            } else {
                this.statements.add(0, statement);
            }
            statement.setMyStatementBlock(this, this.statements.size() - 1);
            statement.setMyScope(this);
            statement.setFullNameParent(this);
        }
    }

    void addStatementsOrdered(List<Statement> statements) {
        Statement statement;
        int i;
        if (statements == null || statements.isEmpty()) {
            return;
        }
        int size = statements.size();
        for (i = 0; i < size; ++i) {
            statement = statements.get(i);
            int position = Collections.binarySearch(this.statements, statement, STATEMENT_INSERTION_COMPARATOR);
            if (position < 0) {
                this.statements.add((position + 1) * -1, statement);
            } else {
                this.statements.add(position + 1, statement);
            }
            statement.setMyScope(this);
            statement.setFullNameParent(this);
            statement.setMyDefinition(this.myDefinition);
        }
        size = this.statements.size();
        for (i = 0; i < size; ++i) {
            statement = this.statements.get(i);
            statement.setMyStatementBlock(this, i);
        }
    }

    public int getSize() {
        return this.statements.size();
    }

    public Statement getStatementByIndex(int i) {
        return this.statements.get(i);
    }

    public Statement getFirstStatement() {
        int size = this.statements.size();
        block5: for (int i = 0; i < size; ++i) {
            Statement statement = this.statements.get(i);
            switch (statement.getType()) {
                case S_LABEL: {
                    continue block5;
                }
                case S_BLOCK: {
                    Statement firstStatement = ((StatementBlock_Statement)statement).getStatementBlock().getFirstStatement();
                    if (firstStatement == null) continue block5;
                    return firstStatement;
                }
                case S_DOWHILE: {
                    Statement firstStatement = ((DoWhile_Statement)statement).getStatementBlock().getFirstStatement();
                    if (firstStatement == null) continue block5;
                    return firstStatement;
                }
                default: {
                    return statement;
                }
            }
        }
        return null;
    }

    public StatementBlock getMyStatementBlock() {
        return this.myStatementBlock;
    }

    public void setMyStatementBlock(StatementBlock statementBlock, int index) {
        this.myStatementBlock = statementBlock;
        this.myStatementBlockIndex = index;
        int size = this.statements.size();
        for (int i = 0; i < size; ++i) {
            this.statements.get(i).setMyStatementBlock(this, i);
        }
    }

    public int getMyStatementBlockIndex() {
        return this.myStatementBlockIndex;
    }

    public void setMyAltguards(AltGuards altGuards) {
        int size = this.statements.size();
        for (int i = 0; i < size; ++i) {
            this.statements.get(i).setMyAltguards(altGuards);
        }
    }

    public ReturnStatus_type hasReturn(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && this.returnStatus != null) {
            return this.returnStatus;
        }
        this.returnStatus = ReturnStatus_type.RS_NO;
        int size = this.statements.size();
        block4: for (int i = 0; i < size; ++i) {
            Statement statement = this.statements.get(i);
            if (Statement.Statement_type.S_GOTO.equals((Object)statement.getType())) {
                Goto_statement gotoStatement = (Goto_statement)statement;
                if (gotoStatement.getJumpsForward()) {
                    ++i;
                    while (!(i >= size || (statement = this.statements.get(i)) instanceof Label_Statement && ((Label_Statement)statement).labelIsUsed())) {
                        ++i;
                    }
                } else {
                    if (ReturnStatus_type.RS_NO.equals((Object)this.returnStatus)) {
                        statement.getLocation().reportConfigurableSemanticProblem(Platform.getPreferencesService().getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportInifinteLoops", "warning", null), INFINITELOOP);
                    }
                    return this.returnStatus;
                }
            }
            switch (statement.hasReturn(timestamp)) {
                case RS_YES: {
                    this.returnStatus = ReturnStatus_type.RS_YES;
                    continue block4;
                }
                case RS_MAYBE: {
                    this.returnStatus = ReturnStatus_type.RS_MAYBE;
                    continue block4;
                }
            }
        }
        return this.returnStatus;
    }

    public void registerDefinition(CompilationTimeStamp timestamp, Definition definition) {
        String definitionName;
        if (definition == null) {
            return;
        }
        Identifier identifier = definition.getIdentifier();
        if (identifier == null) {
            return;
        }
        if (this.definitionMap == null) {
            this.definitionMap = new HashMap<String, Definition>(3);
        }
        if (this.definitionMap.containsKey(definitionName = identifier.getName())) {
            if (definition.getLocation() != null && this.definitionMap.get(definitionName).getLocation() != null) {
                Location otherLocation = this.definitionMap.get(definitionName).getLocation();
                otherLocation.reportSingularSemanticError(MessageFormat.format("Duplicate definition with name `{0}'' was first declared here", identifier.getDisplayName()));
                definition.getLocation().reportSemanticError(MessageFormat.format("Duplicate definition with name `{0}'' was declared here again", identifier.getDisplayName()));
            }
        } else {
            this.definitionMap.put(definitionName, definition);
            if (this.parentScope != null && definition.getLocation() != null) {
                if (this.parentScope.hasAssignmentWithId(timestamp, identifier)) {
                    definition.getLocation().reportSemanticError(MessageFormat.format(HIDINGSCOPEELEMENT, identifier.getDisplayName()));
                    ArrayList<ISubReference> subReferences = new ArrayList<ISubReference>();
                    subReferences.add(new FieldSubReference(identifier));
                    Reference reference = new Reference(null, subReferences);
                    Assignment assignment = this.parentScope.getAssBySRef(timestamp, reference);
                    if (assignment != null && assignment.getLocation() != null) {
                        assignment.getLocation().reportSingularSemanticError(MessageFormat.format(HIDDENSCOPEELEMENT, identifier.getDisplayName()));
                    }
                } else if (this.parentScope.isValidModuleId(identifier)) {
                    definition.getLocation().reportSemanticWarning(MessageFormat.format(HIDINGMODULEIDENTIFIER, identifier.getDisplayName()));
                }
            }
        }
    }

    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        if (this.freed && minimiseMemoryUsage) {
            MarkerHandler.reEnableAllSemanticMarkers((IFile)this.location.getFile(), this.location.getOffset(), this.location.getEndOffset());
            ArrayList<FakeReference> copy = new ArrayList<FakeReference>(this.referencesGoingOut);
            for (FakeReference reference : copy) {
                Reference tempRef = reference.moduleName != null ? new Reference(new Identifier(Identifier.Identifier_type.ID_TTCN, reference.moduleName)) : new Reference(null);
                tempRef.addSubReference(new FieldSubReference(new Identifier(Identifier.Identifier_type.ID_TTCN, reference.definition)));
                tempRef.setMyScope(this);
                Assignment assignment = tempRef.getRefdAssignment(timestamp, false);
                if (assignment == null) {
                    return;
                }
                if (!reference.usedOnLeftSide) continue;
                switch (assignment.getAssignmentType()) {
                    case A_VAR_TEMPLATE: {
                        ((Def_Var_Template)assignment).setWritten();
                        break;
                    }
                    case A_VAR: {
                        ((Def_Var)assignment).setWritten();
                        break;
                    }
                    case A_PAR_TEMP_OUT: 
                    case A_PAR_TEMP_INOUT: 
                    case A_PAR_VAL_OUT: 
                    case A_PAR_VAL_INOUT: 
                    case A_PAR_VAL: {
                        ((FormalParameter)assignment).setWritten();
                        break;
                    }
                }
            }
            return;
        }
        this.referencesGoingOut.clear();
        if (this.definitionMap != null) {
            this.definitionMap.clear();
        }
        if (this.labelMap != null) {
            this.labelMap.clear();
        }
        this.checkLabels(timestamp);
        boolean unreachableFound = false;
        Statement previousStatement = null;
        int size = this.statements.size();
        for (int i = 0; i < size; ++i) {
            Statement statement = this.statements.get(i);
            try {
                statement.check(timestamp);
            }
            catch (Exception e) {
                Location loc = statement.getLocation();
                ErrorReporter.logExceptionStackTrace((String)("An exception was thrown when analyzing the statement in file '" + loc.getFile().getLocationURI() + "' at line " + loc.getLine()), (Throwable)e);
            }
            if (!unreachableFound && !Statement.Statement_type.S_LABEL.equals((Object)statement.getType()) && previousStatement != null && previousStatement.isTerminating(timestamp)) {
                statement.getLocation().reportSemanticWarning(NEVER_REACH);
                unreachableFound = true;
            }
            previousStatement = statement;
        }
        if (this.statements.isEmpty()) {
            this.getLocation().reportConfigurableSemanticProblem(reportEmptyStatementBlock, EMPTY_STATEMENT_BLOCK);
        } else if (this.statements.size() > reportTooManyStatementsSize) {
            this.getLocation().reportConfigurableSemanticProblem(reportTooManyStatements, MessageFormat.format(TOOMANYSTATEMENTS, reportTooManyStatementsSize));
        }
        this.checkUnusedLabels(timestamp);
        this.lastTimeChecked = timestamp;
    }

    public void postCheck() {
        if (this.statements.isEmpty()) {
            return;
        }
        int size = this.statements.size();
        for (int i = 0; i < size; ++i) {
            this.statements.get(i).postCheck();
        }
    }

    public void free() {
        if (minimiseMemoryUsage && !this.freed) {
            this.freed = true;
            this.statements.clear();
            if (this.definitionMap != null) {
                this.definitionMap.clear();
            }
            if (this.labelMap != null) {
                this.labelMap.clear();
            }
        }
    }

    private void checkLabels(CompilationTimeStamp timestamp) {
        int size = this.statements.size();
        for (int i = 0; i < size; ++i) {
            Statement statement = this.statements.get(i);
            if (!Statement.Statement_type.S_LABEL.equals((Object)statement.getType())) continue;
            Label_Statement labelStatement = (Label_Statement)statement;
            labelStatement.setUsed(false);
            Identifier identifier = labelStatement.getLabelIdentifier();
            if (this.hasLabel(identifier)) {
                statement.getLocation().reportSemanticError(MessageFormat.format(DUPLICATELABELAGAIN, identifier.getDisplayName()));
                Label_Statement statement2 = this.getLabel(identifier);
                statement2.getLocation().reportSemanticError(MessageFormat.format(DUPLICATEDLABELFIRST, identifier.getDisplayName()));
                continue;
            }
            if (this.labelMap == null) {
                this.labelMap = new HashMap<String, Label_Statement>(1);
            }
            this.labelMap.put(identifier.getName(), labelStatement);
        }
    }

    private void checkUnusedLabels(CompilationTimeStamp timestamp) {
        int size = this.statements.size();
        for (int i = 0; i < size; ++i) {
            Label_Statement labelStatement;
            Statement statement = this.statements.get(i);
            if (!Statement.Statement_type.S_LABEL.equals((Object)statement.getType()) || (labelStatement = (Label_Statement)statement).labelIsUsed()) continue;
            statement.getLocation().reportSemanticError(MessageFormat.format(UNUSEDLABEL, labelStatement.getLabelIdentifier().getDisplayName()));
        }
    }

    public void checkAllowedInterleave() {
        int size = this.statements.size();
        for (int i = 0; i < size; ++i) {
            this.statements.get(i).checkAllowedInterleave();
        }
    }

    protected boolean hasLabel(Identifier identifier) {
        StatementBlock statementBlock = this;
        while (statementBlock != null) {
            if (statementBlock.labelMap != null && statementBlock.labelMap.containsKey(identifier.getName())) {
                return true;
            }
            statementBlock = statementBlock.myStatementBlock;
        }
        return false;
    }

    protected Label_Statement getLabel(Identifier identifier) {
        StatementBlock statementBlock = this;
        while (statementBlock != null) {
            if (statementBlock.labelMap != null && statementBlock.labelMap.containsKey(identifier.getName())) {
                return statementBlock.labelMap.get(identifier.getName());
            }
            statementBlock = statementBlock.myStatementBlock;
        }
        return null;
    }

    public boolean hasEnclosingLoop() {
        return this.ownerIsLoop || this.myStatementBlock != null && this.myStatementBlock.hasEnclosingLoop();
    }

    public boolean hasEnclosingLoopOrAltguard() {
        return this.ownerIsLoop || this.ownerIsAltguard || this.myStatementBlock != null && this.myStatementBlock.hasEnclosingLoopOrAltguard();
    }

    @Override
    public StatementBlock getStatementBlockScope() {
        return this;
    }

    @Override
    public Component_Type getMtcSystemComponentType(CompilationTimeStamp timestamp, boolean isSystem) {
        Component_Type type;
        if (this.myDefinition == null || !Assignment.Assignment_type.A_TESTCASE.equals(this.myDefinition.getAssignmentType())) {
            return null;
        }
        Def_Testcase testcase = (Def_Testcase)this.myDefinition;
        if (isSystem && (type = testcase.getSystemType(timestamp)) != null) {
            return type;
        }
        return testcase.getRunsOnType(timestamp);
    }

    @Override
    public boolean hasAssignmentWithId(CompilationTimeStamp timestamp, Identifier identifier) {
        if (this.definitionMap != null && this.definitionMap.containsKey(identifier.getName())) {
            return true;
        }
        if (this.parentScope != null) {
            return this.parentScope.hasAssignmentWithId(timestamp, identifier);
        }
        return false;
    }

    @Override
    public Assignment getAssBySRef(CompilationTimeStamp timestamp, Reference reference) {
        return this.getAssBySRef(timestamp, reference, null);
    }

    @Override
    public Assignment getAssBySRef(CompilationTimeStamp timestamp, Reference reference, IReferenceChain refChain) {
        FakeReference fakeReference;
        if (reference.getModuleIdentifier() != null || this.definitionMap == null) {
            FakeReference fakeReference2;
            if (minimiseMemoryUsage && !this.referencesGoingOut.contains(fakeReference2 = new FakeReference(reference))) {
                this.referencesGoingOut.add(fakeReference2);
            }
            return this.getParentScope().getAssBySRef(timestamp, reference);
        }
        Assignment assignment = this.definitionMap.get(reference.getId().getName());
        if (assignment != null) {
            return assignment;
        }
        if (minimiseMemoryUsage && !this.referencesGoingOut.contains(fakeReference = new FakeReference(reference))) {
            this.referencesGoingOut.add(fakeReference);
        }
        return this.getParentScope().getAssBySRef(timestamp, reference);
    }

    @Override
    public void addProposal(ProposalCollector propCollector) {
        HashMap<String, ASTNode> temp;
        if (this.definitionMap != null && propCollector.getReference().getModuleIdentifier() == null) {
            temp = new HashMap<String, Definition>(this.definitionMap);
            for (Definition definition : temp.values()) {
                definition.addProposal(propCollector, 0);
            }
        }
        if (this.labelMap != null && propCollector.getReference().getModuleIdentifier() == null) {
            temp = new HashMap<String, Label_Statement>(this.labelMap);
            for (String name : temp.keySet()) {
                propCollector.addProposal(name, name, null);
            }
        }
        super.addProposal(propCollector);
    }

    @Override
    public void addSkeletonProposal(ProposalCollector propCollector) {
        for (SkeletonTemplateProposal templateProposal : TTCN3CodeSkeletons.STATEMENT_LEVEL_SKELETON_PROPOSALS) {
            propCollector.addTemplateProposal(templateProposal.getPrefix(), templateProposal.getProposal(), TTCN3CodeSkeletons.SKELETON_IMAGE);
        }
    }

    @Override
    public void addKeywordProposal(ProposalCollector propCollector) {
        propCollector.addProposal(TTCN3Keywords.STATEMENT_SCOPE, null, "keyword");
        super.addKeywordProposal(propCollector);
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector) {
        String name;
        if (this.definitionMap != null && declarationCollector.getReference().getModuleIdentifier() == null && this.definitionMap.containsKey(name = declarationCollector.getReference().getId().getName())) {
            declarationCollector.addDeclaration(name, this.definitionMap.get(name).getLocation(), this);
        }
        if (this.labelMap != null && declarationCollector.getReference().getModuleIdentifier() == null && this.labelMap.containsKey(name = declarationCollector.getReference().getId().getName())) {
            declarationCollector.addDeclaration(name, this.labelMap.get(name).getLocation(), this);
        }
        super.addDeclaration(declarationCollector);
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        List<Integer> temp;
        boolean isBeingExtended;
        if (!isDamaged) {
            int size = this.statements.size();
            for (int i = 0; i < size; ++i) {
                Statement statement = this.statements.get(i);
                statement.updateSyntax(reparser, false);
                reparser.updateLocation(statement.getLocation());
            }
            return;
        }
        this.freed = false;
        this.returnStatus = null;
        this.lastTimeChecked = null;
        boolean enveloped = false;
        int nofDamaged = 0;
        int leftBoundary = this.location.getOffset() + 1;
        int rightBoundary = this.location.getEndOffset() - 1;
        int damageOffset = reparser.getDamageStart();
        IAppendableSyntax lastAppendableBeforeChange = null;
        IAppendableSyntax lastPrependableBeforeChange = null;
        int size = this.statements.size();
        for (int i = 0; i < size && !enveloped; ++i) {
            Location cumulativeLocation;
            Statement statement = this.statements.get(i);
            Location temporalLocation = statement.getLocation();
            if (temporalLocation.equals(cumulativeLocation = statement instanceof Definition_Statement ? ((Definition_Statement)statement).getDefinition().getCumulativeDefinitionLocation() : temporalLocation) && reparser.envelopsDamage(cumulativeLocation)) {
                enveloped = true;
                leftBoundary = cumulativeLocation.getOffset();
                rightBoundary = cumulativeLocation.getEndOffset();
                continue;
            }
            if (reparser.isDamaged(cumulativeLocation)) {
                ++nofDamaged;
                if (reparser.getDamageStart() == cumulativeLocation.getEndOffset()) {
                    lastAppendableBeforeChange = statement;
                    continue;
                }
                if (reparser.getDamageEnd() != cumulativeLocation.getOffset()) continue;
                lastPrependableBeforeChange = statement;
                continue;
            }
            if (cumulativeLocation.getEndOffset() < damageOffset && cumulativeLocation.getEndOffset() > leftBoundary) {
                leftBoundary = cumulativeLocation.getEndOffset() + 1;
                lastAppendableBeforeChange = statement;
            }
            if (cumulativeLocation.getOffset() < damageOffset || cumulativeLocation.getOffset() >= rightBoundary) continue;
            rightBoundary = cumulativeLocation.getOffset();
            lastPrependableBeforeChange = statement;
        }
        if (!enveloped) {
            reparser.extendDamagedRegion(leftBoundary, rightBoundary);
        }
        if (lastAppendableBeforeChange != null && (isBeingExtended = reparser.startsWithFollow(lastAppendableBeforeChange.getPossibleExtensionStarterTokens()))) {
            leftBoundary = lastAppendableBeforeChange.getLocation().getOffset();
            ++nofDamaged;
            enveloped = false;
            reparser.extendDamagedRegion(leftBoundary, rightBoundary);
        }
        if (lastPrependableBeforeChange != null && (temp = lastPrependableBeforeChange.getPossiblePrefixTokens()) != null && reparser.endsWithToken(temp)) {
            rightBoundary = lastPrependableBeforeChange.getLocation().getEndOffset();
            ++nofDamaged;
            enveloped = false;
            reparser.extendDamagedRegion(leftBoundary, rightBoundary);
        }
        if (nofDamaged != 0) {
            this.removeStuffInRange(reparser);
        }
        Iterator<Statement> iterator = this.statements.iterator();
        while (iterator.hasNext()) {
            Statement statement = iterator.next();
            Location temporalLocation = statement.getLocation();
            Location cumulativeLocation = statement instanceof Definition_Statement ? ((Definition_Statement)statement).getDefinition().getCumulativeDefinitionLocation() : temporalLocation;
            if (!reparser.isAffectedAppended(cumulativeLocation)) continue;
            try {
                statement.updateSyntax(reparser, enveloped && reparser.envelopsDamage(cumulativeLocation));
                reparser.updateLocation(statement.getLocation());
            }
            catch (ReParseException e) {
                if (e.getDepth() == 1) {
                    enveloped = false;
                    iterator.remove();
                    reparser.extendDamagedRegion(cumulativeLocation);
                    continue;
                }
                e.decreaseDepth();
                throw e;
            }
        }
        if (!enveloped) {
            reparser.extendDamagedRegion(leftBoundary, rightBoundary);
            int result = this.reparse(reparser);
            if (result > 1) {
                throw new ReParseException(result - 1);
            }
        }
    }

    private int reparse(TTCN3ReparseUpdater aReparser) {
        return aReparser.parse(new ITTCN3ReparseBase(){

            @Override
            public void reparse(Ttcn3Reparser parser) {
                List<Statement> statements = parser.pr_reparse_FunctionStatementOrDefList().statements;
                if (statements != null) {
                    StatementBlock.this.addStatementsOrdered(statements);
                }
            }
        });
    }

    private void removeStuffInRange(TTCN3ReparseUpdater reparser) {
        for (int i = this.statements.size() - 1; i >= 0; --i) {
            Statement statement = this.statements.get(i);
            Location cumulativeLocation = statement instanceof Definition_Statement ? ((Definition_Statement)statement).getDefinition().getCumulativeDefinitionLocation() : statement.getLocation();
            if (!reparser.isDamaged(cumulativeLocation)) continue;
            reparser.extendDamagedRegion(cumulativeLocation);
            this.statements.remove(i);
        }
    }

    @Override
    public Assignment getEnclosingAssignment(int offset) {
        if (this.definitionMap == null) {
            return null;
        }
        for (Definition definition : this.definitionMap.values()) {
            if (!definition.getLocation().containsOffset(offset)) continue;
            return definition;
        }
        return null;
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.statements == null) {
            return;
        }
        ArrayList<Statement> tempList = new ArrayList<Statement>(this.statements);
        for (Statement statement : tempList) {
            statement.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    public boolean accept(ASTVisitor v) {
        switch (v.visit(this)) {
            case 2: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        if (this.statements != null) {
            for (Statement statement : this.statements) {
                if (statement.accept(v)) continue;
                return false;
            }
        }
        return v.leave(this) != 2;
    }

    public boolean isEmpty() {
        return this.statements.isEmpty();
    }

    static {
        final IPreferencesService ps = Platform.getPreferencesService();
        if (ps != null) {
            minimiseMemoryUsage = ps.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.minimiseMemoryUsage", false, null);
            reportEmptyStatementBlock = ps.getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportEmptyStatementBlock", "warning", null);
            reportTooManyStatements = ps.getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportTooManyStatements", "warning", null);
            reportTooManyStatementsSize = ps.getInt("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportTooManyStatementsSize", 150, null);
            Activator activator = Activator.getDefault();
            if (activator != null) {
                activator.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent event) {
                        String property = event.getProperty();
                        if ("org.eclipse.titan.designer.minimiseMemoryUsage".equals(property)) {
                            minimiseMemoryUsage = ps.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.minimiseMemoryUsage", false, null);
                        } else if ("org.eclipse.titan.designer.reportEmptyStatementBlock".equals(property)) {
                            reportEmptyStatementBlock = ps.getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportEmptyStatementBlock", "warning", null);
                        } else if ("org.eclipse.titan.designer.reportTooManyStatements".equals(property)) {
                            reportTooManyStatements = ps.getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportTooManyStatements", "warning", null);
                        } else if ("org.eclipse.titan.designer.reportTooManyStatementsSize".equals(property)) {
                            reportTooManyStatementsSize = ps.getInt("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportTooManyStatementsSize", 150, null);
                        }
                    }
                });
            }
        }
    }

    private static final class FakeReference {
        String moduleName;
        String definition;
        boolean usedOnLeftSide;

        FakeReference(Reference reference) {
            Identifier moduleId = reference.getModuleIdentifier();
            this.moduleName = moduleId != null ? moduleId.getTtcnName() : null;
            Identifier id = reference.getId();
            this.definition = id != null ? id.getTtcnName() : null;
            this.usedOnLeftSide = reference.getUsedOnLeftHandSide();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof FakeReference) {
                FakeReference other = (FakeReference)obj;
                if (this.moduleName == null ? other.moduleName != null : !this.moduleName.equals(other.moduleName)) {
                    return false;
                }
                if (this.definition == null ? other.definition != null : !this.definition.equals(other.definition)) {
                    return false;
                }
                return this.usedOnLeftSide == other.usedOnLeftSide;
            }
            return false;
        }

        public int hashCode() {
            if (this.definition != null) {
                return this.definition.hashCode();
            }
            return super.hashCode();
        }
    }

    public static enum ReturnStatus_type {
        RS_NO,
        RS_MAYBE,
        RS_YES;

    }
}

