/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.statements.Parameter_Assignment;
import org.eclipse.titan.designer.AST.TTCN3.statements.Parameter_Assignments;
import org.eclipse.titan.designer.AST.TTCN3.statements.Parameter_Redirect;
import org.eclipse.titan.designer.AST.TTCN3.statements.Variable_Entries;
import org.eclipse.titan.designer.AST.TTCN3.statements.Variable_Entry;
import org.eclipse.titan.designer.AST.TTCN3.types.SignatureFormalParameter;
import org.eclipse.titan.designer.AST.TTCN3.types.SignatureFormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.types.Signature_Type;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class AssignmentList_Parameter_Redirect
extends Parameter_Redirect {
    private static final String FULLNAMEPART = ".parameterassignments";
    private final Parameter_Assignments assignments;

    public AssignmentList_Parameter_Redirect(Parameter_Assignments assignments) {
        this.assignments = assignments;
        if (assignments != null) {
            assignments.setFullNameParent(this);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.assignments == child) {
            return builder.append(FULLNAMEPART);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.assignments != null) {
            this.assignments.setMyScope(scope);
        }
    }

    @Override
    public void checkErroneous(CompilationTimeStamp timestamp) {
        HashMap<String, Parameter_Assignment> parameterMap = new HashMap<String, Parameter_Assignment>();
        int size = this.assignments.getNofParameterAssignments();
        for (int i = 0; i < size; ++i) {
            Parameter_Assignment assignment = this.assignments.getParameterAssignmentByIndex(i);
            String name = assignment.getIdentifier().getName();
            if (parameterMap.containsKey(name)) {
                assignment.getLocation().reportSemanticError(MessageFormat.format("Duplicate redirect for parameter `{0}''", assignment.getIdentifier().getDisplayName()));
                Location otherLocation = ((Parameter_Assignment)parameterMap.get(name)).getLocation();
                otherLocation.reportSemanticWarning(MessageFormat.format("A variable entry for parameter `{0}'' is already given here", assignment.getIdentifier().getDisplayName()));
            } else {
                parameterMap.put(name, assignment);
            }
            this.checkVariableReference(timestamp, assignment.getReference(), null);
        }
    }

    @Override
    public void check(CompilationTimeStamp timestamp, Signature_Type signature, boolean isOut) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        SignatureFormalParameterList parameterList = signature.getParameterList();
        if (parameterList.getNofParameters() == 0) {
            this.getLocation().reportSemanticError(MessageFormat.format("Parameter redirect cannot be used because signature `{0}'' does not have parameters", signature.getTypename()));
            this.checkErroneous(timestamp);
            return;
        }
        boolean errorFlag = false;
        HashMap<String, Parameter_Assignment> parameterMap = new HashMap<String, Parameter_Assignment>();
        int size = this.assignments.getNofParameterAssignments();
        for (int i = 0; i < size; ++i) {
            Parameter_Assignment assignment = this.assignments.getParameterAssignmentByIndex(i);
            String name = assignment.getIdentifier().getName();
            if (parameterMap.containsKey(name)) {
                assignment.getLocation().reportSemanticError(MessageFormat.format("Duplicate redirect for parameter `{0}''", assignment.getIdentifier().getDisplayName()));
                Location otherLocation = ((Parameter_Assignment)parameterMap.get(name)).getLocation();
                otherLocation.reportSemanticWarning(MessageFormat.format("A variable entry for parameter `{0}'' is already given here", assignment.getIdentifier().getDisplayName()));
                errorFlag = true;
            } else {
                parameterMap.put(name, assignment);
            }
            if (parameterList.hasParameterWithName(name)) {
                String message;
                SignatureFormalParameter parameterTemplate = parameterList.getParameterByName(name);
                if (isOut) {
                    if (0 == parameterTemplate.getDirection()) {
                        message = MessageFormat.format("Parameter `{0}'' of signature `{1}'' has `in'' direction", assignment.getIdentifier().getDisplayName(), signature.getTypename());
                        assignment.getLocation().reportSemanticError(message);
                        errorFlag = true;
                    }
                } else if (1 == parameterTemplate.getDirection()) {
                    message = MessageFormat.format("Parameter `{0}'' of signature `{1}'' has `out'' direction", assignment.getIdentifier().getDisplayName(), signature.getTypename());
                    assignment.getLocation().reportSemanticError(message);
                    errorFlag = true;
                }
                this.checkVariableReference(timestamp, assignment.getReference(), parameterTemplate.getType());
                continue;
            }
            assignment.getLocation().reportSemanticError(MessageFormat.format("Signature `{0}'' does not have parameter named `{1}''", signature.getTypename(), assignment.getIdentifier().getDisplayName()));
            errorFlag = true;
            this.checkVariableReference(timestamp, assignment.getReference(), null);
        }
        if (!errorFlag) {
            Variable_Entries variableEntries = new Variable_Entries();
            int upperLimit = isOut ? parameterList.getNofOutParameters() : parameterList.getNofInParameters();
            for (int i = 0; i < upperLimit; ++i) {
                SignatureFormalParameter parameter = isOut ? parameterList.getOutParameterByIndex(i) : parameterList.getInParameterByIndex(i);
                String name = parameter.getIdentifier().getName();
                if (parameterMap.containsKey(name)) {
                    variableEntries.add(new Variable_Entry(((Parameter_Assignment)parameterMap.get(name)).getReference()));
                    continue;
                }
                variableEntries.add(new Variable_Entry());
            }
        }
        this.lastTimeChecked = timestamp;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        this.assignments.updateSyntax(reparser, isDamaged);
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.assignments == null) {
            return;
        }
        this.assignments.findReferences(referenceFinder, foundIdentifiers);
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return this.assignments == null || this.assignments.accept(v);
    }
}

