/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASN1.ASN1Assignment;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ArraySubReference;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.Error_Setting;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IReferenceableElement;
import org.eclipse.titan.designer.AST.IReferencingElement;
import org.eclipse.titan.designer.AST.ISetting;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.ParameterisedSubReference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ActualParameterList;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Altstep;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Var;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameter;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.definitions.IParameterisedAssignment;
import org.eclipse.titan.designer.AST.TTCN3.types.Component_Type;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.declarationsearch.Declaration;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public class Reference
extends ASTNode
implements ILocateableNode,
IIncrementallyUpdateable,
IReferencingElement {
    private static final String STRINGELEMENTUNUSABLE = "Reference to a string element of type `{0}'' cannot be used in this context";
    private static final String VARIABLEXPECTED = "Reference to a variable or value parameter was expected instead of {0}";
    private static final String ALTSTEPEXPECTED = "Reference to an altstep was expected in the argument instead of {0}";
    private static final String FULLNAMEPART = ".<sub_reference";
    public static final String COMPONENTEXPECTED = "component type expected";
    public static final String TYPEEXPECTED = "Type reference expected";
    public static final String ASN1SETTINGEXPECTED = "Reference to ASN.1 setting expected";
    protected Identifier modid;
    protected ArrayList<ISubReference> subReferences;
    private boolean refersToStringElement = false;
    protected boolean detectedModuleId = false;
    private boolean isErroneous;
    protected Assignment referredAssignment;
    protected CompilationTimeStamp lastTimeChecked;
    private boolean usedOnLeftSide = false;
    private boolean usedInIsbound = false;

    public Reference(Identifier modid) {
        this.modid = modid;
        this.detectedModuleId = modid != null;
        this.subReferences = new ArrayList();
    }

    public Reference(Identifier modid, List<ISubReference> subReferences) {
        this.modid = modid;
        this.detectedModuleId = modid != null;
        this.subReferences = new ArrayList<ISubReference>(subReferences);
        this.subReferences.trimToSize();
        for (int i = 0; i < subReferences.size(); ++i) {
            subReferences.get(i).setFullNameParent(this);
        }
    }

    public Reference newInstance() {
        return new Reference(this.modid, this.subReferences);
    }

    public Assignment getAssOld() {
        return this.referredAssignment;
    }

    public void setBaseScope(Scope scope) {
        super.setMyScope(scope);
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        this.subReferences.trimToSize();
        for (int i = 0; i < this.subReferences.size(); ++i) {
            this.subReferences.get(i).setMyScope(scope);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        for (int i = 0; i < this.subReferences.size(); ++i) {
            if (child != this.subReferences.get(i)) continue;
            return builder.append(FULLNAMEPART).append(String.valueOf(i + 1)).append(">");
        }
        return builder;
    }

    @Override
    public void setLocation(Location location) {
    }

    @Override
    public Location getLocation() {
        Location temp;
        if (this.modid != null) {
            temp = new Location(this.modid.getLocation());
        } else if (!this.subReferences.isEmpty()) {
            temp = new Location(this.subReferences.get(0).getLocation());
        } else {
            return NULL_Location.INSTANCE;
        }
        if (!this.subReferences.isEmpty()) {
            temp.setEndOffset(this.subReferences.get(this.subReferences.size() - 1).getLocation().getEndOffset());
        }
        return temp;
    }

    public final CompilationTimeStamp getLastTimeChecked() {
        return this.lastTimeChecked;
    }

    public final boolean getIsErroneous(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return this.isErroneous;
        }
        return false;
    }

    public void setIsErroneous(boolean isErroneous) {
        this.isErroneous = isErroneous;
    }

    public boolean getUsedOnLeftHandSide() {
        return this.usedOnLeftSide;
    }

    public void setUsedOnLeftHandSide() {
        this.usedOnLeftSide = true;
    }

    public boolean getUsedInIsbound() {
        return this.usedInIsbound;
    }

    public void setUsedInIsbound() {
        this.usedInIsbound = true;
    }

    public Identifier getModuleIdentifier() {
        this.detectModid();
        return this.modid;
    }

    public Identifier getId() {
        this.detectModid();
        if (!this.subReferences.isEmpty()) {
            return this.subReferences.get(0).getId();
        }
        return null;
    }

    public List<ISubReference> getSubreferences() {
        return this.subReferences;
    }

    public List<ISubReference> getSubreferences(int from, int till) {
        ArrayList<ISubReference> result = new ArrayList<ISubReference>();
        int size = Math.min(this.subReferences.size() - 1, till);
        for (int i = Math.max(0, from); i <= size; ++i) {
            result.add(this.subReferences.get(i));
        }
        return result;
    }

    public void addSubReference(ISubReference subReference) {
        this.subReferences.add(subReference);
        subReference.setFullNameParent(this);
    }

    public ISubReference removeLastSubReference() {
        if (this.subReferences.isEmpty()) {
            return null;
        }
        ISubReference result = this.subReferences.remove(this.subReferences.size() - 1);
        if (this.subReferences.isEmpty() && this.modid != null) {
            this.subReferences.add(new FieldSubReference(this.modid));
            this.modid = null;
            this.detectedModuleId = false;
        }
        return result;
    }

    public boolean refersToStringElement() {
        return this.refersToStringElement;
    }

    public void setStringElementReferencing() {
        this.refersToStringElement = true;
    }

    public void clearStringElementReferencing() {
        this.refersToStringElement = false;
    }

    public void clear() {
        this.referredAssignment = null;
        this.lastTimeChecked = null;
    }

    public void detectModid() {
        if (this.detectedModuleId || this.modid != null) {
            return;
        }
        Identifier firstId = null;
        if (!this.subReferences.isEmpty() && ISubReference.Subreference_type.fieldSubReference.equals((Object)this.subReferences.get(0).getReferenceType())) {
            firstId = this.subReferences.get(0).getId();
            if (this.subReferences.size() > 1 && !ISubReference.Subreference_type.arraySubReference.equals((Object)this.subReferences.get(1).getReferenceType()) && this.myScope != null && !this.myScope.hasAssignmentWithId(CompilationTimeStamp.getBaseTimestamp(), firstId) && this.myScope.isValidModuleId(firstId)) {
                this.modid = firstId;
                this.subReferences.remove(0);
            }
        }
        this.detectedModuleId = true;
    }

    public ISetting getRefdSetting(CompilationTimeStamp timestamp) {
        Assignment assignment = this.getRefdAssignment(timestamp, true);
        if (assignment != null) {
            return assignment.getSetting(timestamp);
        }
        return new Error_Setting();
    }

    public Assignment getRefdAssignment(CompilationTimeStamp timestamp, boolean checkParameterList) {
        return this.getRefdAssignment(timestamp, checkParameterList, null);
    }

    public Assignment getRefdAssignment(CompilationTimeStamp timestamp, boolean checkParameterList, IReferenceChain referenceChain) {
        String referingModuleName;
        if (this.myScope == null || this.getId() == null) {
            return null;
        }
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp) && !checkParameterList) {
            return this.referredAssignment;
        }
        boolean newChain = null == referenceChain;
        IReferenceChain tempReferenceChain = newChain ? ReferenceChain.getInstance("Circular reference chain: `{0}''", true) : referenceChain;
        this.isErroneous = false;
        this.detectedModuleId = false;
        this.detectModid();
        this.referredAssignment = this.myScope.getAssBySRef(timestamp, this, referenceChain);
        if (this.referredAssignment == null) {
            this.isErroneous = true;
            this.lastTimeChecked = timestamp;
            return this.referredAssignment;
        }
        this.referredAssignment.check(timestamp, tempReferenceChain);
        this.referredAssignment.setUsed();
        if (this.referredAssignment instanceof Definition && !((Definition)this.referredAssignment).referingHere.contains(referingModuleName = this.getMyScope().getModuleScope().getName())) {
            ((Definition)this.referredAssignment).referingHere.add(referingModuleName);
        }
        if (checkParameterList) {
            FormalParameterList formalParameterList = null;
            if (this.referredAssignment instanceof IParameterisedAssignment) {
                formalParameterList = ((IParameterisedAssignment)((Object)this.referredAssignment)).getFormalParameterList();
            }
            if (formalParameterList == null) {
                if (!this.subReferences.isEmpty() && this.subReferences.get(0) instanceof ParameterisedSubReference) {
                    String message = MessageFormat.format("The referenced {0} cannot have actual parameters", this.referredAssignment.getDescription());
                    this.getLocation().reportSemanticError(message);
                }
            } else if (!this.subReferences.isEmpty()) {
                ISubReference firstSubReference = this.subReferences.get(0);
                if (firstSubReference instanceof ParameterisedSubReference) {
                    formalParameterList.check(timestamp, this.referredAssignment.getAssignmentType());
                    this.isErroneous = ((ParameterisedSubReference)firstSubReference).checkParameters(timestamp, formalParameterList);
                } else if (!Assignment.Assignment_type.A_TEMPLATE.equals(this.referredAssignment.getAssignmentType()) || !formalParameterList.hasOnlyDefaultValues()) {
                    String message = MessageFormat.format("Reference to parameterized definition `{0}'' without actual parameter list", this.referredAssignment.getIdentifier().getDisplayName());
                    this.getLocation().reportSemanticError(message);
                }
            }
        }
        this.lastTimeChecked = timestamp;
        return this.referredAssignment;
    }

    public Declaration getReferencedDeclaration(ISubReference subReference) {
        Assignment ass = this.getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), false);
        if (ass == null) {
            return null;
        }
        if (subReference == null) {
            return Declaration.createInstance(ass.getMyScope().getModuleScope());
        }
        if (this.subReferences.size() == 1 || this.subReferences.get(0) == subReference) {
            return Declaration.createInstance(ass);
        }
        IType assignmentType = ass.getType(CompilationTimeStamp.getBaseTimestamp());
        if (assignmentType == null) {
            return null;
        }
        IType type = assignmentType.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
        if (type instanceof IReferenceableElement) {
            IReferenceableElement iTypeWithComponents = (IReferenceableElement)((Object)type);
            return iTypeWithComponents.resolveReference(this, 1, subReference);
        }
        return Declaration.createInstance(ass);
    }

    public final Component_Type chkComponentypeReference(CompilationTimeStamp timestamp) {
        Assignment assignment = this.getRefdAssignment(timestamp, true);
        if (assignment != null) {
            if (Assignment.Assignment_type.A_TYPE.equals(assignment.getAssignmentType())) {
                IType type = assignment.getType(timestamp);
                if (type != null && (type = type.getTypeRefdLast(timestamp)) != null && !type.getIsErroneous(timestamp)) {
                    switch (type.getTypetype()) {
                        case TYPE_COMPONENT: {
                            return (Component_Type)type;
                        }
                        case TYPE_REFERENCED: {
                            return null;
                        }
                    }
                    this.getLocation().reportSemanticError(COMPONENTEXPECTED);
                }
            } else {
                this.getLocation().reportSemanticError(TYPEEXPECTED);
            }
        }
        return null;
    }

    public IType checkVariableReference(CompilationTimeStamp timestamp) {
        Type type;
        Assignment assignment = this.getRefdAssignment(timestamp, true);
        if (assignment == null) {
            return null;
        }
        switch (assignment.getAssignmentType()) {
            case A_PAR_VAL_IN: {
                ((FormalParameter)assignment).useAsLValue(this);
                type = ((FormalParameter)assignment).getType(timestamp);
                ((FormalParameter)assignment).setUsed();
                break;
            }
            case A_PAR_VAL: 
            case A_PAR_VAL_OUT: 
            case A_PAR_VAL_INOUT: {
                type = ((FormalParameter)assignment).getType(timestamp);
                ((FormalParameter)assignment).setUsed();
                break;
            }
            case A_VAR: {
                type = ((Def_Var)assignment).getType(timestamp);
                ((Def_Var)assignment).setUsed();
                break;
            }
            default: {
                this.getLocation().reportSemanticError(MessageFormat.format(VARIABLEXPECTED, assignment.getDescription()));
                return null;
            }
        }
        IType result = type.getFieldType(timestamp, this, 1, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, null, false);
        if (result != null && this.subReferences != null && this.refersToStringElement()) {
            this.getLocation().reportSemanticError(MessageFormat.format(STRINGELEMENTUNUSABLE, result.getTypename()));
        }
        return result;
    }

    public final boolean checkActivateArgument(CompilationTimeStamp timestamp) {
        Assignment assignment = this.getRefdAssignment(timestamp, true);
        if (assignment == null) {
            return false;
        }
        if (!Assignment.Assignment_type.A_ALTSTEP.equals(assignment.getAssignmentType())) {
            this.getLocation().reportSemanticError(MessageFormat.format(ALTSTEPEXPECTED, assignment.getDescription()));
            return false;
        }
        if (this.myScope != null) {
            this.myScope.checkRunsOnScope(timestamp, assignment, (ILocateableNode)this, "activate");
        }
        if (!this.subReferences.isEmpty() && ISubReference.Subreference_type.parameterisedSubReference.equals((Object)this.subReferences.get(0).getReferenceType())) {
            ActualParameterList actualParameters = ((ParameterisedSubReference)this.subReferences.get(0)).getActualParameters();
            FormalParameterList formalParameterList = ((Def_Altstep)assignment).getFormalParameterList();
            if (formalParameterList != null) {
                return formalParameterList.checkActivateArgument(timestamp, actualParameters, assignment.getDescription());
            }
        }
        return false;
    }

    public final boolean hasUnfoldableIndexSubReference(CompilationTimeStamp timestamp) {
        int size = this.subReferences.size();
        for (int i = 0; i < size; ++i) {
            IValue value;
            ISubReference subReference = this.subReferences.get(i);
            if (!ISubReference.Subreference_type.arraySubReference.equals((Object)subReference.getReferenceType()) || (value = ((ArraySubReference)subReference).getValue()) == null || !(value = value.setLoweridToReference(timestamp)).isUnfoldable(timestamp)) continue;
            return true;
        }
        return false;
    }

    public boolean refersToSettingType(CompilationTimeStamp timestamp, ISetting.Setting_type settingType, IReferenceChain referenceChain) {
        if (this.myScope == null) {
            return ISetting.Setting_type.S_ERROR.equals((Object)settingType);
        }
        Assignment assignment = this.getRefdAssignment(timestamp, true);
        if (assignment == null) {
            return false;
        }
        if (!(assignment instanceof ASN1Assignment)) {
            this.getLocation().reportSemanticError(ASN1SETTINGEXPECTED);
            return false;
        }
        ASN1Assignment asnAssignment = (ASN1Assignment)assignment;
        switch (settingType) {
            case S_OC: {
                return asnAssignment.isAssignmentType(timestamp, Assignment.Assignment_type.A_OC, referenceChain);
            }
            case S_T: {
                return asnAssignment.isAssignmentType(timestamp, Assignment.Assignment_type.A_TYPE, referenceChain);
            }
            case S_O: {
                return asnAssignment.isAssignmentType(timestamp, Assignment.Assignment_type.A_OBJECT, referenceChain);
            }
            case S_V: {
                return asnAssignment.isAssignmentType(timestamp, Assignment.Assignment_type.A_CONST, referenceChain);
            }
            case S_OS: {
                return asnAssignment.isAssignmentType(timestamp, Assignment.Assignment_type.A_OS, referenceChain);
            }
            case S_VS: {
                return asnAssignment.isAssignmentType(timestamp, Assignment.Assignment_type.A_VS, referenceChain);
            }
            case S_ERROR: {
                return asnAssignment.getIsErroneous();
            }
        }
        return false;
    }

    public final String toString() {
        return this.getDisplayName();
    }

    public String getDisplayName() {
        StringBuilder builder = new StringBuilder();
        if (this.modid != null) {
            builder.append(this.modid.getDisplayName());
        }
        for (int i = 0; i < this.subReferences.size(); ++i) {
            this.subReferences.get(i).appendDisplayName(builder);
        }
        return builder.toString();
    }

    @Override
    public final void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.modid != null) {
            reparser.updateLocation(this.modid.getLocation());
        }
        int size = this.subReferences.size();
        for (int i = 0; i < size; ++i) {
            ISubReference subreference = this.subReferences.get(i);
            subreference.updateSyntax(reparser, false);
            reparser.updateLocation(subreference.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        for (ISubReference sr : this.subReferences) {
            sr.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.referredAssignment == null) {
            return;
        }
        if (referenceFinder.fieldId == null) {
            if (referenceFinder.assignment != this.referredAssignment) {
                return;
            }
            foundIdentifiers.add(new ReferenceFinder.Hit(this.getId(), this));
        } else {
            IType t = this.referredAssignment.getType(CompilationTimeStamp.getBaseTimestamp());
            if (t == null) {
                return;
            }
            ArrayList<IType> typeArray = new ArrayList<IType>();
            boolean success = t.getFieldTypesAsArray(this, 1, typeArray);
            if (!success) {
                return;
            }
            if (this.subReferences.size() != typeArray.size() + 1) {
                ErrorReporter.INTERNAL_ERROR();
                return;
            }
            for (int i = 1; i < this.subReferences.size(); ++i) {
                if (typeArray.get(i - 1) != referenceFinder.type || this.subReferences.get(i) instanceof ArraySubReference || !this.subReferences.get(i).getId().equals(referenceFinder.fieldId)) continue;
                foundIdentifiers.add(new ReferenceFinder.Hit(this.subReferences.get(i).getId()));
            }
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.modid != null && !this.modid.accept(v)) {
            return false;
        }
        if (this.subReferences != null) {
            for (ISubReference sr : this.subReferences) {
                if (sr.accept(v)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Declaration getDeclaration() {
        return this.getReferencedDeclaration(null);
    }
}

