/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1.values;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Undefined_LowerIdentifier_Value;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Named_Integer_Value
extends Value {
    private final Identifier identifier;
    private Integer_Value calculatedValue = null;

    public Named_Integer_Value(Undefined_LowerIdentifier_Value original) {
        this.copyGeneralProperties(original);
        this.identifier = original.getIdentifier();
    }

    @Override
    public IValue.Value_type getValuetype() {
        return IValue.Value_type.NAMED_INTEGER_VALUE;
    }

    @Override
    public String createStringRepresentation() {
        if (null == this.calculatedValue) {
            return this.identifier.getName();
        }
        StringBuilder builder = new StringBuilder(this.identifier.getName());
        builder.append('(').append(this.calculatedValue.createStringRepresentation()).append(')');
        return builder.toString();
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        return IType.Type_type.TYPE_INTEGER;
    }

    @Override
    public IValue getReferencedSubValue(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, IReferenceChain refChain) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (this.getIsErroneous(timestamp) || subreferences.size() <= actualSubReference) {
            return this;
        }
        IType type = this.myGovernor.getTypeRefdLast(timestamp);
        if (type.getIsErroneous(timestamp)) {
            return null;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid array element reference: type `{0}'' can not be indexed", type.getTypename()));
                return null;
            }
            case fieldSubReference: {
                this.location.reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((FieldSubReference)subreference).getId().getDisplayName(), type.getTypename()));
                return null;
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError("Invalid reference: internal parameterisation is not supported");
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public IValue getValueRefdLast(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (null != this.calculatedValue) {
            return this.calculatedValue;
        }
        return this;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        return true;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public void setCalculatedValue(Integer_Value calculatedValue) {
        this.calculatedValue = calculatedValue;
    }

    public Integer_Value getCalculatedValue() {
        return this.calculatedValue;
    }

    @Override
    public Value setValuetype(CompilationTimeStamp timestamp, IValue.Value_type newType) {
        return super.setValuetype(timestamp, newType);
    }

    @Override
    public boolean checkEquality(CompilationTimeStamp timestamp, IValue other) {
        if (null != this.calculatedValue) {
            return this.calculatedValue.checkEquality(timestamp, other);
        }
        return false;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        reparser.updateLocation(this.identifier.getLocation());
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return this.identifier == null || this.identifier.accept(v);
    }
}

